/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pdf.gx;

import com.tridium.pdf.gx.PdfDocument;
import com.tridium.pdf.gx.PdfObject;
import com.tridium.pdf.gx.PdfStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PdfPage
extends PdfObject {
    private PdfStream content = this.getParent().createStream();
    private Vector<PdfStream> xObjects = new Vector();
    private Hashtable<String, Integer> xObjectsRef = new Hashtable();
    private Hashtable<String, Integer> fontRef = new Hashtable();

    public PdfPage(PdfDocument parent, int objectId, int generationNum) {
        super(parent, objectId, generationNum);
    }

    public PdfStream getContentStream() {
        return this.content;
    }

    public void addXObject(String name, PdfStream stream) {
        this.xObjectsRef.put(name, stream.getObjectId());
        this.xObjects.add(stream);
    }

    public void addXObject(String name, int objectId) {
        this.xObjectsRef.put(name, objectId);
    }

    public void addFont(String name, int objectId) {
        this.fontRef.put(name, objectId);
    }

    @Override
    public void toPdf() throws IOException {
        String name;
        Enumeration<Object> e;
        PdfDocument doc = this.getParent();
        doc.markOffset(this.getObjectId());
        doc.writeln(this.getObjectId() + " " + this.getGenerationNum() + " obj");
        doc.write("<< /Type /Page /Parent " + doc.getPageTreeId() + " 0 R");
        doc.write(" /MediaBox [0 0 " + doc.getPageSize().width + " " + doc.getPageSize().height + "]");
        doc.write(" /Contents " + this.content.getObjectId() + " 0 R");
        doc.write(" /Resources << /ProcSet [/PDF /Text /ImageC]");
        if (!this.fontRef.isEmpty()) {
            doc.write(" /Font <<");
            e = this.fontRef.keys();
            while (e.hasMoreElements()) {
                name = e.nextElement();
                doc.write(" /" + name + " " + this.fontRef.get(name) + " 0 R");
            }
            doc.write(" >>");
        }
        if (!this.xObjects.isEmpty()) {
            doc.write(" /XObject <<");
            e = this.xObjectsRef.keys();
            while (e.hasMoreElements()) {
                name = e.nextElement();
                doc.write(" /" + name + " " + this.xObjectsRef.get(name) + " 0 R");
            }
            doc.write(" >>");
        }
        doc.writeln(" >> >>");
        doc.writeln("endobj");
        this.content.toPdf();
        e = this.xObjects.elements();
        while (e.hasMoreElements()) {
            ((PdfStream)e.nextElement()).toPdf();
        }
    }
}

