/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mobile.ux.schedule;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONException;
import com.tridium.json.JSONObject;
import com.tridium.schedule.ScheduleUtil;
import java.util.ArrayList;
import javax.baja.box.BIServerSideCallHandler;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BCompositeSchedule;
import javax.baja.schedule.BControlSchedule;
import javax.baja.schedule.BWeeklySchedule;
import javax.baja.security.PermissionException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BMonth;
import javax.baja.sys.BSingleton;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.CannotValidateException;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"schedule:WeeklySchedule", "schedule:CalendarSchedule", "schedule:TriggerSchedule"}, app="defaultMobile", requiredPermissions="r")})
@NiagaraSingleton
public class BScheduleServerSideCallHandler
extends BSingleton
implements BIServerSideCallHandler {
    @Generated
    public static final BScheduleServerSideCallHandler INSTANCE = new BScheduleServerSideCallHandler();
    @Generated
    public static final Type TYPE = Sys.loadType(BScheduleServerSideCallHandler.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    private BScheduleServerSideCallHandler() {
    }

    public BValue save(BComponent comp, BValue arg, Context cx) {
        BAbstractSchedule originalSchedule = (BAbstractSchedule)comp;
        BAbstractSchedule newSchedule = (BAbstractSchedule)arg;
        try {
            ScheduleUtil.validateSchedule((BAbstractSchedule)newSchedule, (Context)cx);
        }
        catch (CannotValidateException e) {
            Lexicon lex = Lexicon.make((String)"schedule", (Context)cx);
            return BString.make((String)(lex.get("validation.cannotValidate") + ": " + e.toString(cx)));
        }
        ScheduleUtil.stationSideAuditableCopyFrom((BAbstractSchedule)originalSchedule, (BAbstractSchedule)newSchedule, (Context)cx);
        if (originalSchedule instanceof BControlSchedule) {
            BControlSchedule schedule = (BControlSchedule)originalSchedule;
            schedule.setLastModified(BAbsTime.now());
            schedule.execute();
        }
        return comp;
    }

    public BString getHighlightedDates(BComponent comp, BValue arg, Context cx) {
        BVector vec = (BVector)arg;
        BAbstractSchedule sched = (BAbstractSchedule)vec.get("schedule");
        BAbsTime day = (BAbsTime)vec.get("time");
        BAbsTime nextMonth = (day = BAbsTime.make((int)day.getYear(), (BMonth)day.getMonth(), (int)1)).getMonth() == BMonth.december ? BAbsTime.make((int)(day.getYear() + 1), (BMonth)BMonth.january, (int)1) : BAbsTime.make((int)day.getYear(), (BMonth)day.getMonth().next(), (int)1);
        BAbsTime nextDay = day.nextDay();
        ArrayList<BAbsTime> highlightedDays = new ArrayList<BAbsTime>();
        while (day.isBefore(nextMonth)) {
            if (sched.isEffective(day) || sched.next(true, day, nextDay) != null) {
                highlightedDays.add(day);
            }
            day = nextDay;
            nextDay = day.nextDay();
        }
        JSONArray arr = new JSONArray();
        for (int i = 0; i < highlightedDays.size(); ++i) {
            BAbsTime hday = (BAbsTime)highlightedDays.get(i);
            int y = hday.getYear();
            int m = hday.getMonth().getOrdinal() + 1;
            int d = hday.getDay();
            arr.put((Object)(y + "-" + (m < 10 ? "0" : "") + m + "-" + (d < 10 ? "0" : "") + d));
        }
        return BString.make((String)arr.toString());
    }

    public BString getDaySummary(BComponent comp, BValue arg, Context cx) throws JSONException {
        BVector vec = (BVector)arg;
        BWeeklySchedule sched = (BWeeklySchedule)vec.get("schedule");
        BFacets facets = sched.getFacets();
        BAbsTime t = (BAbsTime)vec.get("time");
        JSONArray arr = new JSONArray();
        BTimeZone z = this.getTimeZone(cx);
        t = BAbsTime.make((int)t.getYear(), (BMonth)t.getMonth(), (int)t.getDay(), (int)0, (int)0, (int)0, (int)0, (BTimeZone)z);
        BAbsTime end = t.nextDay();
        while (t != null && t.isBefore(end)) {
            JSONObject obj = new JSONObject();
            obj.put("timestamp", (Object)t.toString(cx));
            obj.put("output", (Object)sched.getOutput(t).toString((Context)facets));
            obj.put("source", (Object)sched.getSummary(sched.getOutputSource(t), null));
            arr.put((Object)obj);
            t = sched.nextEvent(t);
        }
        return BString.make((String)arr.toString());
    }

    public BString getDailyScheduleDisplayString(BComponent comp, BValue arg, Context cx) {
        return BString.make((String)arg.toString(cx));
    }

    public BValue getSnapshot(BComponent component, Context cx) {
        if (component instanceof BCompositeSchedule) {
            return component.newCopy(true);
        }
        throw new PermissionException("Can only retrieve snapshot of a BCompositeSchedule");
    }

    private BTimeZone getTimeZone(Context cx) {
        BTimeZone z = null;
        if (cx != null) {
            z = (BTimeZone)cx.getFacets().get("TimeZone");
        }
        return z == null ? BTimeZone.getLocal() : z;
    }
}

