/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.videoHx;

import com.tridium.ndriver.discover.BINDiscoveryHost;
import com.tridium.ndriver.discover.BINDiscoveryLeaf;
import com.tridium.ndriver.discover.BINDiscoveryObject;
import com.tridium.ndriver.discover.BNDiscoveryJob;
import com.tridium.ndriver.discover.BNDiscoveryLeaf;
import com.tridium.ndriver.discover.BNDiscoveryPreferences;
import com.tridium.ndriver.discover.BNPointDiscoveryLeaf;
import com.tridium.ndriver.ui.NMgrColumnUtil;
import com.tridium.nvideo.datatypes.BVideoDeviceId;
import com.tridium.nvideo.display.BDisplayDeviceExt;
import com.tridium.nvideo.recordingServer.BVideoRecordingServerDeviceExt;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.securityUtil.query.QueryUtil;
import com.tridiumx.entsec.securityUtil.query.TypeSpecPath;
import com.tridiumx.videoHx.BHxVideoFieldSheet;
import com.tridiumx.videoHx.discover.BAutoDiscoverPointsJob;
import java.lang.reflect.Method;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDeviceExt;
import javax.baja.hx.HxOp;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BQuery;
import javax.baja.registry.DependencyInfo;
import javax.baja.registry.ModuleInfo;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.MgrColumn;

public abstract class VideoHxUtil {
    static final Lexicon secUtilLex = Lexicon.make(VideoHxUtil.class);

    public static BComplex getVideoDeviceIdComponent(Type cameraType) {
        BComponent instance = cameraType.getInstance().asComponent();
        if (instance.get("videoDeviceId") != null) {
            return instance.get("videoDeviceId").asComplex();
        }
        if (instance.get("deviceId") != null) {
            return instance.get("deviceId").asComplex();
        }
        throw new RuntimeException("Unknown Video Device id for type:" + cameraType);
    }

    public static boolean isNDriver(Type type) {
        if (type.getModule().getModuleName().equals("ndriver")) {
            return true;
        }
        ModuleInfo[] moduleInfos = type.getModule().getAllModuleInfo();
        for (int i = 0; i < moduleInfos.length; ++i) {
            DependencyInfo[] info = moduleInfos[i].getDependencies();
            for (int j = 0; j < info.length; ++j) {
                ModuleInfo m = info[j].getModuleInfo();
                if (!m.getModuleName().equals("ndriver")) continue;
                return true;
            }
        }
        return false;
    }

    public static void addVideoDeviceIdToDiscoveryQuery(BQuery query, Type cameraType) {
        Property[] props = null;
        boolean naxisDiscovery = cameraType.toString().equals("naxisVideo:AxisVideoCamera");
        if (naxisDiscovery) {
            BComplex c = BTypeSpec.make((String)"naxisVideo:AxisCameraDiscoveryLeaf").getInstance().asComplex();
            props = c.getPropertiesArray();
        } else {
            props = VideoHxUtil.getVideoDeviceIdComponent(cameraType).getPropertiesArray();
        }
        for (int i = 0; i < props.length; ++i) {
            if (naxisDiscovery) {
                QueryUtil.addColumn((BQuery)query, (TypeSpecPath)new TypeSpecPath(props[i]));
                continue;
            }
            if (VideoHxUtil.isNDriver(cameraType)) {
                QueryUtil.addColumn((BQuery)query, (TypeSpecPath)new TypeSpecPath(props[i].getType().getTypeSpec(), "id." + props[i].getName(), secUtilLex.getText("videoDeviceId." + props[i].getName())));
                continue;
            }
            QueryUtil.addColumn((BQuery)query, (TypeSpecPath)new TypeSpecPath(props[i].getType().getTypeSpec(), props[i].getName(), secUtilLex.getText("deviceId." + props[i].getName())));
        }
    }

    public static void addVideoDeviceIdToQuery(BQuery query, Type cameraType) {
        Property[] props = VideoHxUtil.getVideoDeviceIdComponent(cameraType).getPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            if (VideoHxUtil.isNDriver(cameraType)) {
                QueryUtil.addColumn((BQuery)query, (TypeSpecPath)new TypeSpecPath(props[i].getType().getTypeSpec(), "videoDeviceId." + props[i].getName(), secUtilLex.getText("videoDeviceId." + props[i].getName())));
                continue;
            }
            QueryUtil.addColumn((BQuery)query, (TypeSpecPath)new TypeSpecPath(props[i].getType().getTypeSpec(), "deviceId." + props[i].getName(), secUtilLex.getText("deviceId." + props[i].getName())));
        }
    }

    public static String[] getDeviceFields(Type cameraType) {
        Property[] props = VideoHxUtil.getVideoDeviceIdComponent(cameraType).getPropertiesArray();
        String[] fields = new String[props.length + 1];
        for (int i = 0; i < props.length; ++i) {
            fields[i] = VideoHxUtil.isNDriver(cameraType) ? "videoDeviceId." + props[i].getName() : "deviceId." + props[i].getName();
        }
        fields[props.length] = "status";
        return fields;
    }

    public static BJob submitDiscoveryJob(BComponent deviceSys) {
        if (VideoHxUtil.isNDriver(deviceSys.getType())) {
            BOrd ord = ((BINDiscoveryHost)deviceSys).submitDiscoveryJob((BNDiscoveryPreferences)deviceSys.get("discoveryPreferences"));
            return (BJob)ord.get((BObject)deviceSys);
        }
        try {
            Class bIDdfDiscoveryHostClass = Sys.loadClass((String)"devDriver", (String)"com.tridium.ddf.discover.BIDdfDiscoveryHost");
            Class bDdfAutoDiscoveryPreferencesClass = Sys.loadClass((String)"devDriver", (String)"com.tridium.ddf.discover.auto.BDdfAutoDiscoveryPreferences");
            Method submitMethod = bIDdfDiscoveryHostClass.getMethod("submitDiscoveryJob", bDdfAutoDiscoveryPreferencesClass);
            if (submitMethod != null) {
                BComplex preferences = (BComplex)deviceSys.get("discoveryPreferences");
                BOrd ord = (BOrd)submitMethod.invoke((Object)deviceSys, preferences);
                return (BJob)ord.get((BObject)deviceSys);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isDiscoveryHost(BComponent device) {
        try {
            if (device instanceof BINDiscoveryHost) {
                return true;
            }
            if (device.getType().is(BTypeSpec.make((String)"devDriver:IDdfDiscoveryHost").getResolvedType())) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean showDiscoveryDialog(BComponent container) {
        try {
            BValue preferences = container.get("discoveryPreferences");
            if (preferences instanceof BNDiscoveryPreferences) {
                return !((BNDiscoveryPreferences)preferences).getDoNotAskAgain();
            }
            if (preferences.getType().is(BTypeSpec.make((String)"devDriver:DdfDiscoveryPreferences").getResolvedType())) {
                Class bIDdfDiscoveryPreferencesClass = Sys.loadClass((String)"devDriver", (String)"com.tridium.ddf.discover.BDdfDiscoveryPreferences");
                Method doNotAskAgainMethod = bIDdfDiscoveryPreferencesClass.getMethod("doNotAskAgain", new Class[0]);
                return (Boolean)doNotAskAgainMethod.invoke((Object)preferences, new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static Type getDisplayType(HxOp op) {
        if (op.get() instanceof BDisplayDeviceExt) {
            return ((BDisplayDeviceExt)op.get()).getVideoSystem().getVideoDisplayType();
        }
        return BTypeSpec.make((String)"devVideoDriver:DdfDisplayDeviceExt").getResolvedType();
    }

    public static Type getRecordingServerType(HxOp op) {
        if (op.get() instanceof BDeviceExt) {
            return ((BVideoRecordingServerDeviceExt)op.get()).getVideoSystem().getVideoRecordingServerType();
        }
        throw new BajaRuntimeException("Cannot determine Video Recording Server Type ");
    }

    public static Type getLeafType(Type jobType) {
        if (jobType.is(BNDiscoveryJob.TYPE)) {
            return BNDiscoveryLeaf.TYPE;
        }
        if (jobType.is(BTypeSpec.make((String)"devDriver:DdfDiscoveryJob").getResolvedType())) {
            return BTypeSpec.make((String)"devDriver:DdfDiscoveryLeaf").getResolvedType();
        }
        throw new BajaRuntimeException("Cannot determine Leaf for a BJob of Type " + jobType);
    }

    public static Type getLeafType(BComplex container) {
        if (VideoHxUtil.isNDriver(container.getType())) {
            return BINDiscoveryLeaf.TYPE;
        }
        return BTypeSpec.make((String)"devDriver:IDdfDiscoveryLeaf").getResolvedType();
    }

    public static BComponent getComponentFromLeaf(BComponent container, BComplex complexLeaf, Context cx) {
        if (complexLeaf instanceof BNDiscoveryLeaf) {
            BNDiscoveryLeaf leaf = (BNDiscoveryLeaf)complexLeaf;
            TypeInfo[] types = leaf.getValidDatabaseTypes();
            if (types.length >= 1) {
                BVideoDeviceId videoDeviceId = (BVideoDeviceId)leaf.get("id");
                BComponent c = (BComponent)types[0].getInstance();
                if (videoDeviceId != null) {
                    c.set("videoDeviceId", videoDeviceId.newCopy());
                }
                leaf.updateTarget(c);
                return c;
            }
        } else {
            try {
                Class biDdfDiscoveryLeafClass = Sys.loadClass((String)"devDriver", (String)"com.tridium.ddf.discover.BIDdfDiscoveryLeaf");
                Method getValidDatabaseTypesMethod = biDdfDiscoveryLeafClass.getMethod("getValidDatabaseTypes", new Class[0]);
                TypeInfo[] types = (TypeInfo[])getValidDatabaseTypesMethod.invoke((Object)complexLeaf, new Object[0]);
                if (types.length >= 1) {
                    BComponent c = (BComponent)types[0].getInstance();
                    c.set("deviceId", complexLeaf.newCopy());
                    return c;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String getComponentNameFromLeaf(BComponent container, BComplex complexLeaf, Context cx) {
        if (complexLeaf instanceof BNDiscoveryLeaf) {
            BNDiscoveryLeaf leaf = (BNDiscoveryLeaf)complexLeaf;
            return leaf.getDiscoveryName();
        }
        try {
            return SlotPath.escape((String)complexLeaf.get("description").toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean hasUsefulPreferences(BComponent c) {
        if (VideoHxUtil.isNDriver(c.getType())) {
            BNDiscoveryPreferences preferences = (BNDiscoveryPreferences)c.get("discoveryPreferences");
            return preferences != null && preferences.getType() != BNDiscoveryPreferences.TYPE && preferences.getPropertiesArray().length > 1;
        }
        BComplex preferences = (BComplex)c.get("discoveryPreferences");
        return preferences != null && preferences.get("min").getType() != BTypeSpec.make((String)"devDriver:DdfIdParams").getResolvedType();
    }

    public static String getDiscoveryNameForLeaf(Object o) {
        if (o instanceof BNPointDiscoveryLeaf) {
            return ((BNPointDiscoveryLeaf)o).getDiscoveryName();
        }
        try {
            Class leafClass = BTypeSpec.make((String)"devDriver:DdfPointDiscoveryLeaf").getResolvedType().getTypeClass();
            Method getDiscoveryNameMethod = leafClass.getMethod("getDiscoveryName", new Class[0]);
            return (String)getDiscoveryNameMethod.invoke(o, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static MgrColumn[] getMgrColumns(BComponent component) {
        if (VideoHxUtil.isNDriver(component.getType())) {
            Array columns = new Array(MgrColumn.class);
            NMgrColumnUtil.getColumnsFor((BComplex)component, (Array)columns);
            MgrColumn[] mgrCol = new MgrColumn[columns.size()];
            Object[] columsArray = columns.array();
            for (int i = 0; i < columsArray.length; ++i) {
                if (columsArray[i] == null) continue;
                mgrCol[i] = (MgrColumn)columsArray[i];
            }
            return mgrCol;
        }
        try {
            Class ddfMgrColumnUtilClass = Sys.loadClass((String)"devDriver", (String)"com.tridium.ddf.ui.DdfMgrColumnUtil");
            Method getColumnsForMethod = ddfMgrColumnUtilClass.getMethod("getColumnsFor", BComplex.class);
            return (MgrColumn[])getColumnsForMethod.invoke((Object)ddfMgrColumnUtilClass, component);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void updateExistenceFacetsForEvents(BJob job, HxOp op) {
        block10: {
            BComponent eventsContainer;
            block9: {
                BINDiscoveryObject[] leafs = null;
                eventsContainer = op.getComponent();
                if (!job.getType().is(BNDiscoveryJob.TYPE)) break block9;
                BNDiscoveryJob autoDiscoveryJob = (BNDiscoveryJob)job;
                leafs = autoDiscoveryJob.getRootDiscoveryObjects();
                for (int i = 0; i < leafs.length; ++i) {
                    BNPointDiscoveryLeaf leaf = (BNPointDiscoveryLeaf)leafs[i];
                    Property prop = leaf.getPropertyInParent();
                    String leafName = leaf.getDiscoveryName();
                    if (leafName == null || leafName.equals("")) {
                        leafName = SlotPath.escape((String)TextUtil.toFriendly((String)leaf.getDisplayName((Context)op)));
                    }
                    BBoolean eventExists = BBoolean.make((eventsContainer.get(leafName) != null ? 1 : 0) != 0);
                    BString eventType = BString.make((String)SlotPath.unescape((String)TextUtil.toFriendly((String)leafName)));
                    BFacets facets = leaf.getParent().getSlotFacets((Slot)prop);
                    BFacets facetUpdates = BFacets.make((String[])new String[]{"dbExistence", "eventType"}, (BIDataValue[])new BIDataValue[]{eventExists, eventType});
                    leaf.getParent().asComponent().setFacets((Slot)prop, BFacets.make((BFacets)facets, (BFacets)facetUpdates));
                }
                break block10;
            }
            if (!job.getType().is(BAutoDiscoverPointsJob.TYPE)) break block10;
            BAutoDiscoverPointsJob autoDiscoveryJob = (BAutoDiscoverPointsJob)job;
            try {
                BJob discoveryLeavesContainer = null;
                discoveryLeavesContainer = job;
                if (discoveryLeavesContainer == null) {
                    return;
                }
                SlotCursor c = discoveryLeavesContainer.getProperties();
                Type leafType = autoDiscoveryJob.getLeafType();
                while (c.next(leafType.getTypeClass())) {
                    Property prop = c.property();
                    BStruct leaf = (BStruct)discoveryLeavesContainer.get(prop);
                    String leafName = "";
                    if (leaf.getType().is(BNPointDiscoveryLeaf.TYPE)) {
                        leafName = ((BNPointDiscoveryLeaf)leaf).getDiscoveryName();
                    } else {
                        Method getDiscoveryNameMethod = leafType.getTypeClass().getMethod("getDiscoveryName", new Class[0]);
                        leafName = (String)getDiscoveryNameMethod.invoke((Object)leaf, new Object[0]);
                    }
                    if (leafName == null || leafName.equals("")) {
                        leafName = SlotPath.escape((String)TextUtil.toFriendly((String)leaf.getDisplayName((Context)op)));
                    }
                    BBoolean eventExists = BBoolean.make((eventsContainer.get(leafName) != null ? 1 : 0) != 0);
                    BString eventType = BString.make((String)SlotPath.unescape((String)TextUtil.toFriendly((String)leafName)));
                    BFacets facets = discoveryLeavesContainer.getSlotFacets((Slot)prop);
                    BFacets facetUpdates = BFacets.make((String[])new String[]{"dbExistence", "eventType"}, (BIDataValue[])new BIDataValue[]{eventExists, eventType});
                    discoveryLeavesContainer.setFacets((Slot)prop, BFacets.make((BFacets)facets, (BFacets)facetUpdates));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static BControlPoint eventLeafToPoint(BComplex complexLeaf, Type proxyType, Context cx) {
        if (complexLeaf instanceof BNDiscoveryLeaf) {
            BNPointDiscoveryLeaf leaf = (BNPointDiscoveryLeaf)complexLeaf;
            TypeInfo[] types = leaf.getValidDatabaseTypes();
            if (types.length >= 1) {
                BControlPoint controlPoint = (BControlPoint)types[0].getInstance();
                BAbstractProxyExt proxy = (BAbstractProxyExt)proxyType.getInstance();
                controlPoint.setProxyExt(proxy);
                leaf.updateTarget((BComponent)controlPoint);
                return controlPoint;
            }
            return null;
        }
        try {
            Class bDdfPointDiscoveryLeafClass = BTypeSpec.make((String)"devDriver:DdfPointDiscoveryLeaf").getResolvedType().getTypeClass();
            Method getValidDatabaseTypesMethod = bDdfPointDiscoveryLeafClass.getMethod("getValidDatabaseTypes", new Class[0]);
            TypeInfo[] types = (TypeInfo[])getValidDatabaseTypesMethod.invoke((Object)complexLeaf, new Object[0]);
            if (types.length >= 1) {
                BControlPoint controlPoint = (BControlPoint)types[0].getInstance();
                BComplex proxy = (BComplex)proxyType.getInstance();
                proxy.set("readParameters", complexLeaf.get("readParameters").newCopy());
                proxy.set("writeParameters", complexLeaf.get("writeParameters").newCopy());
                proxy.set("pointId", complexLeaf.get("pointId").newCopy());
                controlPoint.setProxyExt((BAbstractProxyExt)proxy);
                return controlPoint;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void registerOptionalFieldEditors(Tab tab, HxOp op) {
        tab.view = BHxVideoFieldSheet.INSTANCE;
    }
}

