/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.alarm;

import com.tridium.alarm.ui.BAlarmConsole;
import com.tridium.ui.Binder;
import com.tridium.ui.UiEnv;
import com.tridium.videoDriver.VideoDriverLexicon;
import com.tridium.videoDriver.alarm.BIVideoAlarmRecorder;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.ui.alarm.AlarmConsoleExt;
import com.tridium.videoDriver.ui.camera.BVideoPtzDialogPane;
import com.tridium.videoDriver.ui.playback.BVideoPlayback;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.gx.IRectGeom;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BWindowEvent;

@NiagaraType
public class BAlarmConsoleVideoPlayerDialog
extends BDialog {
    @Generated
    public static final Type TYPE = Sys.loadType(BAlarmConsoleVideoPlayerDialog.class);
    protected boolean closed;
    protected Binder binder;
    protected BVideoPlayback videoPlayback2;
    protected double preferredWidth;
    protected double preferredHeight;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAlarmConsoleVideoPlayerDialog() {
    }

    public BAlarmConsoleVideoPlayerDialog(BAlarmConsole alarmConsole) {
        super((BWidget)alarmConsole, BVideoPtzDialogPane.LEX.getText("AlarmConsole.ShowVideo.Dialog.Title"), true);
        this.layoutWindow(alarmConsole);
        this.videoPlayback2 = new BVideoPlayback();
        this.videoPlayback2.drawView();
        this.videoPlayback2.overrideCurrentInfoMessage(VideoDriverLexicon.LEX.getText("AlarmConsoleExt.ResolvingCamera"));
        this.setContent((BWidget)this.videoPlayback2);
    }

    void loadAsync(BAlarmConsole alarmConsole, BAlarmRecord selectedRecord, BOrd videoCameraOrd, BObject videoCameraObject) {
        if (videoCameraObject instanceof BIVideoCamera && videoCameraObject instanceof BIVideoSource) {
            BAbsTime alarmTime = (BAbsTime)selectedRecord.getAlarmData().get("videoEventTimestamp");
            if (alarmTime == null) {
                selectedRecord = AlarmConsoleExt.refreshAlarmRecord(alarmConsole, selectedRecord);
                alarmTime = (BAbsTime)selectedRecord.getAlarmData().get("videoEventTimestamp");
            }
            String alarmSummary = this.toSummaryString(selectedRecord, alarmTime);
            if (alarmTime == null || alarmTime.isNull()) {
                alarmTime = selectedRecord.getTimestamp();
                alarmSummary = VideoDriverLexicon.LEX.getText("AlarmRecallTimeApproximate", new Object[]{alarmSummary});
            }
            boolean shouldBeLive = !(videoCameraObject instanceof BIVideoAlarmRecorder);
            this.videoPlayback2 = new BVideoPlayback(alarmSummary, alarmTime, shouldBeLive);
            this.setContent((BWidget)this.videoPlayback2);
            this.hookViewToCamera(videoCameraObject, selectedRecord);
        }
    }

    protected void hookViewToCamera(BObject videoCameraObject, BAlarmRecord selectedRecord) {
        this.binder = BAlarmConsoleVideoPlayerDialog.hookViewToCamera(videoCameraObject, selectedRecord, this.videoPlayback2);
    }

    public static Binder hookViewToCamera(BObject videoCameraObject, BAlarmRecord selectedRecord, BVideoPlayback videoPlayback2) {
        ((BComponent)videoCameraObject).lease();
        videoPlayback2.fw(403);
        Context context = null;
        try {
            BISession session = BOrd.toSession((BObject)videoCameraObject);
            if (session != null) {
                context = session.getSessionContext();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        videoPlayback2.prime();
        videoPlayback2.relayout();
        videoPlayback2.start();
        videoPlayback2.loadValue(videoCameraObject, context);
        if (videoPlayback2.getLoadError() != null) {
            throw new BajaRuntimeException(videoPlayback2.getLoadError());
        }
        Binder binder = (Binder)videoPlayback2.fw(302);
        binder.start(((BComponent)videoCameraObject).getNavOrd().resolve(), context);
        return binder;
    }

    protected BAlarmService getAlarmService() {
        return (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
    }

    protected void layoutWindow(BAlarmConsole alarmConsole) {
        IRectGeom screenSize = UiEnv.get().getScreenBounds((BWidget)alarmConsole);
        this.preferredWidth = screenSize.width() / 2.0;
        this.preferredHeight = this.preferredWidth * 0.75;
        this.setScreenSizeToPreferredSize();
        this.setBoundsCenteredOnOwner();
    }

    protected String toSummaryString(BAlarmRecord selectedRecord, BAbsTime alarmTime) {
        StringBuilder s = new StringBuilder(selectedRecord.getAlarmData().gets("msgText", ""));
        if (s.toString().trim().length() > 0) {
            s.append(" <-> ");
        }
        if (alarmTime == null || BAbsTime.NULL.equals((Object)alarmTime)) {
            s.append(selectedRecord.getTimestamp().toString((Context)BAlarmRecord.TIMESTAMP_FACETS));
        } else {
            s.append(alarmTime.toString((Context)BAlarmRecord.TIMESTAMP_FACETS));
        }
        s.append(": (").append(selectedRecord.getAckState()).append(':').append(selectedRecord.getSourceState()).append(") ");
        return s.toString();
    }

    public void windowClosing(BWindowEvent event) {
        try {
            if (this.binder != null) {
                this.binder.stop();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.close();
        }
    }

    public void close() {
        this.closed = true;
        super.close();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void computePreferredSize() {
        this.setPreferredSize(this.preferredWidth, this.preferredWidth * 0.75);
    }
}

