/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.alarm;

import com.tridium.alarm.ui.BAlarmConsole;
import com.tridium.alarm.ui.ConsoleTableModel;
import com.tridium.alarm.ui.SourceTableModel;
import com.tridium.videoDriver.alarm.BVideoAlarmActionEnum;
import com.tridium.videoDriver.alarm.BVideoAlarmConsoleOptions;
import com.tridium.videoDriver.ui.alarm.AlarmConsoleController;
import com.tridium.videoDriver.ui.alarm.BVideoAlarmConsoleSettingPropertySheet;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableSelection;

@NiagaraType(agent={@AgentOn(types={"videoDriver:VideoAlarmRecipient"}, requiredPermissions="r")})
public class BVideoAlarmConsole
extends BAlarmConsole {
    @Generated
    public static final Type TYPE = Sys.loadType(BVideoAlarmConsole.class);
    private Command popupSettingsCommand;
    private AlarmConsoleController alarmConsoleController;
    private int lastRowSelected = -1;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void deactivated() {
        super.deactivated();
        if (this.alarmConsoleController != null) {
            this.alarmConsoleController.deactivate();
        }
    }

    public BGridPane makeToolBar() {
        BGridPane currentToolbar = super.makeToolBar();
        BWidget[] currentToolbarWidgets = currentToolbar.getChildWidgets();
        for (int i = 0; i < currentToolbarWidgets.length; ++i) {
            currentToolbar.remove((BComplex)currentToolbarWidgets[i]);
        }
        BGridPane newToolbar = new BGridPane(currentToolbarWidgets.length + 1, currentToolbarWidgets);
        this.popupSettingsCommand = new PopupSettingsCommand((BWidget)this, "Popup Settings");
        newToolbar.add("settings", (BValue)new BButton(this.popupSettingsCommand, true, true));
        return newToolbar;
    }

    protected void loadComplete() {
        super.loadComplete();
        this.performLayout();
    }

    protected void performLayout() {
        if (this.alarmConsoleController == null) {
            this.alarmConsoleController = new AlarmConsoleController(this);
        }
        if (this.alarmConsoleController != null) {
            this.alarmConsoleController.layout();
        }
    }

    public void processAlarm(BAlarmRecord alarm) {
        super.processAlarm(alarm);
        if (this.alarmConsoleController != null) {
            this.alarmConsoleController.processAlarm(alarm, false);
        }
    }

    protected void ackAlarms(BAlarmRecord[] alarms) {
        super.ackAlarms(alarms);
        BVideoAlarmConsoleOptions co = this.alarmConsoleController.getVideoAlarmConsoleOptions();
        if (co == null || co.getActionOnAlarmAck().equals((Object)BVideoAlarmActionEnum.noAction)) {
            return;
        }
        BAlarmRecord newestAlarm = this.alarmConsoleController.getNewestUnackedOffnormalAlarm();
        if (newestAlarm != null) {
            this.alarmConsoleController.processAlarm(newestAlarm, false);
        }
    }

    BWidget getInstructionsPane() {
        BWidget widget = this.instructions.getParentWidget();
        while (!widget.getType().is(BGridPane.TYPE)) {
            widget = widget.getParentWidget();
        }
        return widget;
    }

    BComponent getConsoleRecipient() {
        return this.recipient;
    }

    SourceTableModel getSourceTableModel() {
        return this.sourceModel;
    }

    protected BAlarmConsole.Controller getController() {
        return new AlarmTableController();
    }

    protected class PopupSettingsCommand
    extends Command {
        public PopupSettingsCommand(BWidget owner, String label) {
            super(owner, label);
        }

        public BImage getIcon() {
            return BImage.make((BIcon)BIcon.std((String)"gears.png"));
        }

        public CommandArtifact doInvoke() throws Exception {
            if (BVideoAlarmConsole.this.alarmConsoleController != null) {
                BComponent monitor = BVideoAlarmConsole.this.alarmConsoleController.getAlarmMonitor();
                if (monitor != null) {
                    BVideoAlarmConsoleSettingPropertySheet propSheet = new BVideoAlarmConsoleSettingPropertySheet();
                    BDialog dialog = new BDialog(this.getOwner(), BVideoAlarmConsole.this.getTitle(), true, (BWidget)propSheet);
                    propSheet.loadValue((BObject)monitor, BVideoAlarmConsole.this.getCurrentContext());
                    dialog.setBoundsCenteredOnOwner();
                    dialog.open();
                } else {
                    BDialog.message(null, (Object)"Popup settings could not be located for the user.\nPlease make sure the Video Alarm Configuration service is present in the station.");
                }
            }
            return super.doInvoke();
        }
    }

    protected class AlarmTableController
    extends BAlarmConsole.Controller {
        protected AlarmTableController() {
            super((BAlarmConsole)BVideoAlarmConsole.this);
        }

        public void keyReleased(BKeyEvent event) {
            super.keyReleased(event);
            if (event.getKeyCode() == 38 || event.getKeyCode() == 40) {
                this.loadSelectedAlarm();
            }
        }

        protected void cellReleased(BMouseEvent event, int row, int column) {
            super.cellReleased(event, row, column);
            BVideoAlarmConsoleOptions options = BVideoAlarmConsole.this.alarmConsoleController.getVideoAlarmConsoleOptions();
            BVideoAlarmActionEnum actionOnAlarmSelection = options.getActionOnAlarmSelection();
            if (actionOnAlarmSelection.equals((Object)BVideoAlarmActionEnum.loadVideo)) {
                this.loadSelectedAlarm();
            }
        }

        private void loadSelectedAlarm() {
            TableSelection sel = this.getTable().getSelection();
            if (sel.getRows().length == 1) {
                int currentRowSelected = sel.getRow();
                ConsoleTableModel tm = (ConsoleTableModel)((DynamicTableModel)this.getTable().getModel()).getRootModel();
                BAlarmRecord alarm = tm.getRecord(currentRowSelected);
                if (BVideoAlarmConsole.this.alarmConsoleController != null && (BVideoAlarmConsole.this.lastRowSelected == -1 || currentRowSelected != BVideoAlarmConsole.this.lastRowSelected)) {
                    BVideoAlarmConsole.this.lastRowSelected = currentRowSelected;
                    BVideoAlarmConsole.this.alarmConsoleController.processAlarm(alarm, true);
                }
            }
        }
    }
}

