/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.playback;

import com.tridium.videoDriver.ui.playback.BVideoPlayback;
import com.tridium.videoDriver.ui.videoStream.BVideoStreamBinding;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.IVideoPlayback;
import com.tridium.videoDriver.videoStream.IVideoPlaybackSession;
import com.tridium.videoDriver.videoStream.IVideoSession;
import com.tridium.videoDriver.videoStream.IVideoStream;
import com.tridium.videoDriver.videoStream.WaitForStopDecoding;
import com.tridium.videoDriver.videoStream.decoder.IVideoDecoder;
import com.tridium.videoDriver.videoStream.fox.FoxVideoStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.util.Array;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;

public class VideoPlaybackSession
implements IVideoPlaybackSession {
    protected IVideoPlayback videoPlaybackWidget;
    protected static int nextVideoSessionId = 0;
    protected int videoSessionId = nextVideoSessionId++;
    protected final Object waitForStreamMonitor = new Object();
    protected volatile boolean waitingForStream = false;
    protected volatile boolean waitingForDataInStream = false;
    protected IVideoStream videoStream;
    protected IVideoDecoder videoDecoder;
    protected Array<Thread> establishVideoStreamThreads = new Array(Thread.class);
    protected boolean stopVideoSession = false;
    public static final String[] DOTS = new String[]{".", "..", "...", "....", "....."};
    public static final String ESTABLISH_STREAM_TIMEOUT = BVideoPlayback.LEX.getText("VideoPlaybackSession.EstablishStreamTimeout");
    public static final String ESTABLISH_STREAM_MESSAGE = "   " + BVideoPlayback.LEX.getText("VideoPlaybackSession.EstablishingStream") + "   ";
    public static final Logger log = Logger.getLogger("videoDriver.VideoPlaybackSession");

    public VideoPlaybackSession(IVideoPlayback videoPlaybackWidget) {
        this.videoPlaybackWidget = videoPlaybackWidget;
    }

    public void changePlayback(BPlaybackParams playbackParams) {
        if (this.videoPlaybackWidget != null) {
            this.videoPlaybackWidget.changePlayback(playbackParams);
        }
    }

    public int getVideoSessionId() {
        return this.videoSessionId;
    }

    public void stopVideoSession() {
        this.stopVideoSession = true;
        Thread[] t = (Thread[])this.establishVideoStreamThreads.trim();
        if (t != null) {
            for (int i = 0; i < t.length; ++i) {
                t[i].interrupt();
            }
        }
    }

    public IVideoSession getVideoSession() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveVideoStream(IVideoStream videoStream) {
        Object object;
        if (log.isLoggable(Level.FINE)) {
            this.trace("receiveVideoStream - was waiting->" + this.waitingForStream);
        }
        if (videoStream instanceof FoxVideoStream) {
            object = this.waitForStreamMonitor;
            synchronized (object) {
                try {
                    if (this.stopVideoSession || videoStream != null && videoStream.getInputStream() != null && videoStream.getInputStream().available() > 0) {
                        this.waitingForDataInStream = false;
                    }
                }
                catch (Exception e) {
                    throw new BajaRuntimeException((Throwable)e);
                }
                finally {
                    if (this.stopVideoSession) {
                        try {
                            videoStream.closeVideoStream();
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                }
            }
        }
        if (this.videoDecoder.getVideoPlayer() != null) {
            this.videoDecoder.getVideoPlayer().setMessage("");
        }
        if (this.waitingForStream) {
            this.waitingForStream = false;
            this.videoStream = videoStream;
            this.videoDecoder.receiveVideoStream(videoStream);
            object = this.waitForStreamMonitor;
            synchronized (object) {
                this.waitForStreamMonitor.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void videoStreamTimeout() {
        if (log.isLoggable(Level.FINE)) {
            this.trace("videoStreamTimeout");
        }
        if (this.videoDecoder != null) {
            this.videoDecoder.getVideoPlayer().setMessage(ESTABLISH_STREAM_TIMEOUT);
        }
        if (this.waitingForStream) {
            Object object = this.waitForStreamMonitor;
            synchronized (object) {
                this.videoStream = null;
                this.waitingForStream = false;
                this.waitForStreamMonitor.notifyAll();
            }
        }
    }

    public IVideoDecoder getVideoDecoder() {
        return this.videoDecoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IVideoStream establishVideoStream(final BIVideoSource videoSource, final BPlaybackParams playbackParams, IVideoDecoder videoDecoder, BVideoStreamBinding binding) {
        if (log.isLoggable(Level.FINE)) {
            this.trace("establishVideoStream");
        }
        Object object = this.waitForStreamMonitor;
        synchronized (object) {
            this.videoStream = null;
            this.videoDecoder = videoDecoder;
            this.waitingForStream = true;
            this.waitingForDataInStream = true;
            Thread t = new Thread(Thread.currentThread().getName() + "_ConnectStream"){

                @Override
                public void run() {
                    try {
                        videoSource.streamToDestination(playbackParams, (IVideoDestination)VideoPlaybackSession.this);
                        return;
                    }
                    catch (BajaRuntimeException bre) {
                        if (bre.getCause() instanceof InterruptedIOException) {
                            if (log.isLoggable(Level.FINE)) {
                                VideoPlaybackSession.this.trace("Interrupted while asking the Niagara server to establish the video stream.");
                            }
                        } else {
                            log.severe("BajaRuntimeException connecting stream. Cause = " + bre.getCause() + " Video Decoder Finished = " + VideoPlaybackSession.this.videoDecoder.isFinished());
                        }
                    }
                    catch (Throwable e) {
                        log.severe("Exception connecting stream. Exception = " + e + "+ Video Decoder Finished = " + VideoPlaybackSession.this.videoDecoder.isFinished());
                    }
                    VideoPlaybackSession.this.waitingForStream = false;
                }
            };
            this.establishVideoStreamThreads.add((Object)t);
            t.start();
            try {
                if (log.isLoggable(Level.FINE)) {
                    this.trace("Waiting for stream");
                }
                long ticksBeforeWait = Clock.ticks();
                String message = ESTABLISH_STREAM_MESSAGE;
                int i = 0;
                while (!binding.isStopped() && this.waitingForStream && Clock.ticks() - ticksBeforeWait < 30000L) {
                    message = ESTABLISH_STREAM_MESSAGE + DOTS[i / 10 % 5];
                    if (videoDecoder.getVideoPlayer() != null) {
                        videoDecoder.getVideoPlayer().setMessage(message);
                    }
                    if (log.isLoggable(Level.FINE)) {
                        this.trace("<wait_for_stream>");
                    }
                    ++i;
                    this.waitForStreamMonitor.wait(100L);
                }
            }
            catch (InterruptedException ie) {
                if (log.isLoggable(Level.FINE)) {
                    this.trace("establishVideoStream Interrupted While Waiting for waitForStreamMonitor");
                }
            }
            finally {
                if (log.isLoggable(Level.FINE)) {
                    this.trace("Finished waiting for stream");
                }
            }
            return this.videoStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDecoding(IVideoDecoder videoDecoder, IVideoStream videoStream) {
        WaitForStopDecoding waitForStop;
        WaitForStopDecoding waitForStopDecoding = waitForStop = new WaitForStopDecoding();
        synchronized (waitForStopDecoding) {
            block10: {
                try {
                    videoDecoder.stopDecoding(waitForStop);
                    if (waitForStop.isStopped()) break block10;
                    if (log.isLoggable(Level.FINE)) {
                        this.trace("<wait_for_stop>");
                    }
                    waitForStop.wait(1000L);
                    try {
                        if (videoStream != null) {
                            videoStream.closeVideoStream();
                        }
                    }
                    catch (IOException ioe) {
                        if (log.isLoggable(Level.FINE)) {
                            this.trace("stopDecoding - IOException when called videoStream.closeVideoStream()");
                        }
                    }
                }
                catch (InterruptedException ie) {
                    if (!log.isLoggable(Level.FINE)) break block10;
                    this.trace("stopDecoding Interrupted While Waiting for waitForStreamMonitor");
                }
            }
        }
    }

    protected void trace(String memo) {
        log.fine("[" + this.videoSessionId + "] " + memo);
    }
}

