/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.videoStream;

import com.tridium.videoDriver.BIVideoPlayer;
import com.tridium.videoDriver.ui.multistream.BVideoMultistreamPane;
import com.tridium.videoDriver.ui.videoStream.BVideoStreamBinding;
import com.tridium.videoDriver.ui.videoStream.ReplayManager;
import com.tridium.videoDriver.videoStream.BIVideoMultistreamServer;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoSession;
import com.tridium.videoDriver.videoStream.decoder.IVideoMultistreamDecoder;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BWidget;

@NiagaraType
public class BVideoMultistreamBinding
extends BVideoStreamBinding {
    @Generated
    public static final Type TYPE = Sys.loadType(BVideoMultistreamBinding.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BVideoMultistreamBinding() {
        super(new ReplayManager());
        ((ReplayManager)this.videoPlaybackWidget).prepareForReplay(this);
    }

    @Override
    protected boolean resolveStationTarget() {
        if (super.resolveStationTarget()) {
            return this.stationTargetComponent instanceof BIVideoMultistreamServer;
        }
        return false;
    }

    public static BOrd getCameraOrdForVideoPlayer(BIVideoPlayer videoPlayer) {
        BVideoStreamBinding videoPlayerBinding = BVideoMultistreamBinding.getVideoStreamBinding(videoPlayer);
        if (videoPlayerBinding != null) {
            return videoPlayerBinding.getOrd();
        }
        return null;
    }

    public BOrdList getCameraList() {
        BVideoMultistreamPane videoMultistreamPane = this.getVideoMultistreamPane();
        if (videoMultistreamPane == null) {
            throw new IllegalStateException("Unable to find video MULTISTREAM pane.");
        }
        return this.getCameraList(videoMultistreamPane);
    }

    public BOrdList getCameraList(BVideoMultistreamPane videoMultistreamPane) {
        BIVideoPlayer[] videoPlayers = videoMultistreamPane.getVideoPlayers();
        if (videoPlayers != null && videoPlayers.length > 0) {
            Array videoSourceOrds = new Array(BOrd.class);
            for (int i = 0; i < videoPlayers.length; ++i) {
                BOrd videoSourceOrd = BVideoMultistreamBinding.getCameraOrdForVideoPlayer(videoPlayers[i]);
                if (videoSourceOrd == null || videoSourceOrd.equals((Object)BOrd.NULL)) continue;
                videoSourceOrds.add((Object)videoSourceOrd);
            }
            BOrd[] videoCameraOrds = (BOrd[])videoSourceOrds.trim();
            return BOrdList.make((BOrd[])videoCameraOrds);
        }
        return BOrdList.NULL;
    }

    @Override
    protected void resolvePlaybackParams() {
        BVideoMultistreamPane videoMultistreamPane = this.getVideoMultistreamPane();
        if (videoMultistreamPane == null) {
            throw new IllegalStateException("Unable to find video MULTISTREAM pane.");
        }
        BPlaybackParams playbackParams = (BPlaybackParams)videoMultistreamPane.getPlaybackParams().newCopy();
        this.videoSource.initPlaybackParams(playbackParams, (IVideoSession)this.videoPlaybackSession);
        playbackParams.setVideoSourceOrd(this.videoSource.getSlotPathOrd());
        BIVideoPlayer[] videoPlayers = videoMultistreamPane.getVideoPlayers();
        if (videoPlayers != null && videoPlayers.length > 0) {
            BOrdList videoSourceOrdList = this.getCameraList(videoMultistreamPane);
            playbackParams.setVideoSourceOrds(videoSourceOrdList);
            this.playbackParams = playbackParams;
        }
    }

    @Override
    protected boolean resolveVideoDecoder() {
        boolean resolved = super.resolveVideoDecoder();
        return resolved && this.videoDecoder != null && this.videoDecoder instanceof IVideoMultistreamDecoder;
    }

    public static BVideoStreamBinding getVideoStreamBinding(BIVideoPlayer videoPlayer) {
        if (videoPlayer instanceof BWidget) {
            BWidget videoPlayerWidget = (BWidget)videoPlayer;
            BBinding[] videoPlayerBindings = videoPlayerWidget.getBindings();
            for (int i = 0; i < videoPlayerBindings.length; ++i) {
                if (!(videoPlayerBindings[i] instanceof BVideoStreamBinding)) continue;
                return (BVideoStreamBinding)videoPlayerBindings[i];
            }
            return null;
        }
        System.out.println("VideoPlayer must be a BWidget.");
        return null;
    }

    public BVideoMultistreamPane getVideoMultistreamPane() {
        return (BVideoMultistreamPane)this.getWidget();
    }
}

