/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.videoStream.decoder;

import com.tridium.util.EscUtil;
import com.tridium.videoDriver.BIVideoPlayer;
import com.tridium.videoDriver.enums.BPlaybackTypeEnum;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoSession;
import com.tridium.videoDriver.videoStream.IVideoStream;
import com.tridium.videoDriver.videoStream.WaitForStopDecoding;
import com.tridium.videoDriver.videoStream.decoder.IVideoDecoder;
import com.tridium.videoDriver.videoStream.decoder.IVideoMultistreamDecoder;
import com.tridium.videoDriver.videoStream.decoder.VidFrame;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.BDevice;
import javax.baja.gx.BImage;
import javax.baja.nre.util.Array;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.Lexicon;

public abstract class VideoDecoder
implements IVideoDecoder,
Runnable {
    static int decodeId = 0;
    int myId = decodeId++;
    protected BIVideoSource videoSource;
    protected Array<WaitForStopDecoding> waitForStopMonitors = new Array(WaitForStopDecoding.class);
    protected IVideoStream videoStream;
    protected IVideoSession videoSession;
    protected InputStream videoIn = null;
    protected BRelTime stopDecodingTimeout;
    protected BAbsTime timeIndex = BAbsTime.NULL;
    protected String httpContentType = null;
    protected String httpPushBoundary = null;
    protected BIVideoPlayer videoPlayer;
    protected long subscriptionTicks = 0L;
    protected boolean requestToStop;
    boolean singleImage;
    protected Thread decodeThread;
    protected IVideoMultistreamDecoder multistreamDecoder;
    protected static int nextThreadId = 0;
    public static final BImage DISCONNECTED_IMAGE = BImage.make((String)"module://videoDriver/images/VideoStreamDisconnected.png");
    public static final String[] DOTS = new String[]{".", "..", "...", "....", "....."};
    public static final String MULTIPART_START_PATTERN = "multipart";
    public static final String CONTENT_TYPE_KEY = EscUtil.slot.escape("content-type");
    public static final String SINGLE_IMAGE_PATTERN = "image";
    protected static final Logger log = Logger.getLogger("videoDriver.videoDecoder");
    protected static final Logger keepAliveLog = Logger.getLogger("videoDriver.videoDecoder.keepAlive");
    public static final Lexicon LEX = Lexicon.make((String)"videoDriver");

    public IVideoMultistreamDecoder getMultistreamDecoder() {
        return this.multistreamDecoder;
    }

    public void setMultistreamDecoder(IVideoMultistreamDecoder multistreamDecoder) {
        this.multistreamDecoder = multistreamDecoder;
    }

    public void init(BIVideoSource videoSource, BIVideoPlayer videoPlayer, BRelTime stopDecodingTimeout, IVideoSession videoSession) {
        if (log.isLoggable(Level.FINE)) {
            this.trace("init:" + this.getClass().getName());
        }
        this.videoSource = videoSource;
        this.videoPlayer = videoPlayer;
        this.stopDecodingTimeout = stopDecodingTimeout;
        this.httpContentType = null;
        this.httpPushBoundary = null;
        this.timeIndex = BAbsTime.NULL;
        this.videoIn = null;
        this.videoStream = null;
        this.videoSession = videoSession;
    }

    public boolean isFinished() {
        return this.decodeThread != null && !this.decodeThread.isAlive();
    }

    public void stopDecoding(WaitForStopDecoding stopMonitor) {
        if (log.isLoggable(Level.FINE)) {
            this.trace("### Somebody called 'stopDecoding'. Thread name=" + Thread.currentThread().getName());
        }
        if (stopMonitor != null) {
            this.waitForStopMonitors.add((Object)stopMonitor);
        }
        this.videoPlayer = null;
        this.requestToStop = true;
        if (this.decodeThread == null || !this.decodeThread.isAlive()) {
            this.notifyStopMonitors();
        }
    }

    public void keepAlive() {
    }

    protected InputStream makeInputStreamForDecoder(IVideoStream videoStream) {
        return videoStream.getInputStream();
    }

    public void receiveVideoStream(IVideoStream videoStream) {
        if (log.isLoggable(Level.FINE)) {
            this.trace("receiveVideoStream");
        }
        this.videoStream = videoStream;
        this.subscriptionTicks = Clock.ticks();
        if (this.videoPlayer != null) {
            this.videoPlayer.setVideoDecoder((IVideoDecoder)this);
        }
        if (videoStream == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Cannot receive video stream, videoStream is null");
            }
            return;
        }
        this.videoIn = this.makeInputStreamForDecoder(videoStream);
        if (!(this.videoPlayer == null || this.decodeThread != null && this.decodeThread.isAlive())) {
            this.decodeThread = new Thread((Runnable)this, "videoDriver.decode." + ++nextThreadId);
            this.decodeThread.start();
        }
    }

    public void videoStreamTimeout() {
        this.stopDecoding(null);
    }

    public IVideoSession getVideoSession() {
        return this.videoSession;
    }

    public BIVideoSource getVideoSource() {
        return this.videoSource;
    }

    public String getHttpContentType() {
        if (this.httpContentType == null && this.videoStream != null) {
            BFacets httpRspHdrFacets = this.videoStream.getPlaybackParams().getHttpRspHeader();
            this.httpContentType = httpRspHdrFacets.gets(CONTENT_TYPE_KEY, null);
            if (this.httpContentType != null) {
                this.httpContentType = EscUtil.slot.unescape(this.httpContentType);
            }
        }
        return this.httpContentType;
    }

    public boolean isSingleImage() {
        return this.videoStream.getPlaybackParams().getPlaybackType() == BPlaybackTypeEnum.pause;
    }

    public String getHttpPushBoundary() {
        int startingIndexOfBoundaryKey;
        String contentType;
        if (this.httpPushBoundary == null && (contentType = this.getHttpContentType()) != null && (startingIndexOfBoundaryKey = contentType.indexOf("boundary=")) >= 0) {
            int startingIndexOfBoundaryVal = startingIndexOfBoundaryKey + 9;
            this.httpPushBoundary = this.getImpliedBoundaryPrefix() + contentType.substring(startingIndexOfBoundaryVal) + this.getImpliedBoundarySuffix();
        }
        return this.httpPushBoundary;
    }

    public boolean isMultiPartMime() {
        String contentType = this.getHttpContentType();
        return contentType != null && contentType.startsWith(MULTIPART_START_PATTERN);
    }

    protected String getImpliedBoundaryPrefix() {
        return "\n--";
    }

    protected String getImpliedBoundarySuffix() {
        return "\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BIVideoPlayer videoPlayer;
        boolean trace = log.isLoggable(Level.FINE);
        if (trace) {
            this.trace(">> Entering run. Thread = " + Thread.currentThread().getName());
        }
        if ((videoPlayer = this.getVideoPlayer()) != null) {
            videoPlayer.setMessage(LEX.getText(""));
        }
        if (trace) {
            this.trace(">> Calling initVideoStream()");
        }
        this.initVideoStream();
        this.singleImage = this.isSingleImage();
        if (trace) {
            this.trace(">> Start ReadFrame");
        }
        ReadFrame readFrame = new ReadFrame();
        Thread readThread = new Thread((Runnable)readFrame, Thread.currentThread().getName() + "-ReadFrame");
        readThread.setPriority(10);
        readThread.start();
        try {
            boolean firstImage = true;
            long tmo = this.videoSource.getInterframeTimeout().getMillis();
            while (!this.requestToStop && this.isStillBeingViewed()) {
                trace = log.isLoggable(Level.FINE);
                VidFrame newFrame = null;
                if (firstImage) {
                    if (trace) {
                        this.trace(">> Waiting for first image from the stream");
                    }
                    newFrame = this.readFirstFrame(readFrame);
                    firstImage = false;
                } else {
                    if (trace) {
                        this.trace(">> Waiting for video frame.");
                    }
                    newFrame = readFrame.getFrame((int)tmo);
                }
                if (trace) {
                    this.trace(">> Calling processImageFromStream()");
                }
                this.processImageFromStream(newFrame);
                if (this.videoSource instanceof BDevice && ((BDevice)this.videoSource).isDisabled()) {
                    if (trace) {
                        this.trace(">> VideoSource is disabled - requestToStop");
                    }
                    this.requestToStop = true;
                }
                if (!this.singleImage) continue;
                this.requestToStop = true;
            }
            if (trace) {
                this.trace(">> Calling gracefulEndOfStream");
            }
            this.gracefulEndOfVideoStream();
        }
        catch (Throwable e) {
            if (!this.requestToStop && this.isStillBeingViewed()) {
                BPlaybackParams livePlayback = videoPlayer.getPlaybackParams();
                if (e instanceof EOFException && livePlayback.getPlaybackType().isPlayForward()) {
                    if (trace) {
                        this.trace(">> EOFException occurred while ffwd, sfwd, or play. Switching to live playback...");
                    }
                    livePlayback = (BPlaybackParams)livePlayback.newCopy();
                    livePlayback.setPlaybackType(BPlaybackTypeEnum.live);
                } else {
                    String msg = LEX.getText("VideoDecoder.ProblemWithStream", new Object[]{e.getMessage(), ((BComplex)this.videoSource).getDisplayName(null)});
                    if (trace) {
                        this.trace(msg);
                    }
                }
                if (trace) {
                    this.trace(">> Calling videoSession.changePlayback( videoPlayer.getPlaybackParams() )");
                }
                this.videoSession.changePlayback(videoPlayer.getPlaybackParams());
            }
        }
        finally {
            if (trace) {
                this.trace(">> Shutdown readFrame");
            }
            try {
                readFrame.close();
            }
            catch (Throwable firstImage) {}
            try {
                this.closeStream();
            }
            catch (Throwable firstImage) {}
            this.notifyStopMonitors();
        }
    }

    private VidFrame readFirstFrame(ReadFrame readFrame) throws Throwable {
        int i = 0;
        VidFrame newFrame = null;
        while (newFrame == null && i < 10) {
            String message = LEX.getText("VideoPlaybackSession.EstablishingStream") + DOTS[i++ % 5];
            this.getVideoPlayer().setMessage(message);
            try {
                newFrame = readFrame.getFrame(1000);
            }
            catch (Throwable throwable) {}
        }
        this.getVideoPlayer().setMessage("");
        return newFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyStopMonitors() {
        if (log.isLoggable(Level.FINE)) {
            this.trace(">> notifyStopMonitors");
        }
        if (this.waitForStopMonitors.size() <= 0) {
            return;
        }
        WaitForStopDecoding[] stopMonitors = (WaitForStopDecoding[])this.waitForStopMonitors.trim();
        for (int i = 0; i < stopMonitors.length; ++i) {
            WaitForStopDecoding waitForStopDecoding = stopMonitors[i];
            synchronized (waitForStopDecoding) {
                stopMonitors[i].setStopped();
                continue;
            }
        }
    }

    protected void gracefulEndOfVideoStream() {
        this.trace("gracefulEndOfVideoStream");
    }

    protected void initVideoStream() {
    }

    protected VidFrame updateImageFromStream() throws IOException, InterruptedIOException {
        VidFrame vf = this.initVidFrame();
        try {
            this.readFrameData(vf);
            this.decodeFrame(vf);
        }
        catch (Exception e) {
            if (this.requestToStop) {
                return null;
            }
            throw new BajaRuntimeException("Unable to parse video frame", (Throwable)e);
        }
        return vf;
    }

    protected VidFrame initVidFrame() {
        return new VidFrame();
    }

    public abstract void readFrameData(VidFrame var1) throws Exception;

    public abstract void decodeFrame(VidFrame var1) throws Exception;

    protected void processImageFromStream(VidFrame newFrame) {
        if (newFrame != null && newFrame.image != null && this.videoPlayer != null) {
            this.videoPlayer.updateVideoFrame(newFrame);
        }
    }

    protected void frameStarting() throws IOException {
    }

    protected void frameFinished() throws IOException {
    }

    protected void closeStream() {
        if (log.isLoggable(Level.FINE)) {
            this.trace(">> Calling closeStream()");
        }
        if (this.videoStream != null) {
            block5: {
                try {
                    this.videoStream.closeVideoStream();
                }
                catch (IOException ioe) {
                    if (!log.isLoggable(Level.FINE)) break block5;
                    this.trace(">> Caught IOException while calling closeStream(): " + ioe);
                }
            }
            this.videoStream = null;
        }
        if (this.videoPlayer != null && !this.singleImage) {
            this.videoPlayer.setMessage(LEX.getText("StreamClosed"));
        }
    }

    public boolean isStillBeingViewed() {
        boolean isStillBeingViewed;
        boolean bl = isStillBeingViewed = this.videoPlayer != null && this.videoPlayer.isRunning();
        if (keepAliveLog.isLoggable(Level.FINE)) {
            keepAliveLog.fine("isStillBeingViewed = " + isStillBeingViewed);
        }
        return isStillBeingViewed;
    }

    public IVideoStream getVideoStream() {
        return this.videoStream;
    }

    public IVideoDecoder getVideoDecoder() {
        return this;
    }

    public BRelTime getStopDecodingTimeout() {
        return this.stopDecodingTimeout;
    }

    public BIVideoPlayer getVideoPlayer() {
        return this.videoPlayer;
    }

    protected void trace(String memo) {
        log.fine("[" + this.myId + "] " + memo);
    }

    protected void trace(String memo, Throwable e) {
        log.log(Level.FINE, "[" + this.myId + "] " + memo, e);
    }

    private class ReadFrame
    implements Runnable {
        boolean done = false;
        CoalesceQueue q = new CoalesceQueue();

        private ReadFrame() {
        }

        @Override
        public void run() {
            while (!this.done && !VideoDecoder.this.requestToStop) {
                VidFrame vf;
                boolean trace = log.isLoggable(Level.FINE);
                try {
                    VideoDecoder.this.frameStarting();
                    if (trace) {
                        VideoDecoder.this.trace(">>>> Calling updateImageFromStream()");
                    }
                    vf = VideoDecoder.this.updateImageFromStream();
                    if (trace) {
                        if (vf != null) {
                            VideoDecoder.this.trace(">>>> updateImageFromStream success.");
                        } else {
                            VideoDecoder.this.trace(">>>> updateImageFromStream returned null.");
                        }
                    }
                    VideoDecoder.this.frameFinished();
                }
                catch (Throwable t) {
                    if (this.done || VideoDecoder.this.requestToStop) {
                        return;
                    }
                    if (trace) {
                        VideoDecoder.this.trace(">>>> updateImageFromStream threw :" + t, t);
                    }
                    vf = VideoDecoder.this.initVidFrame();
                    vf.imageThrowable = t;
                    this.done = true;
                }
                if (vf != null) {
                    this.q.enqueue((Object)vf);
                }
                if (!VideoDecoder.this.singleImage) continue;
                this.done = true;
            }
            this.q.clear();
            if (log.isLoggable(Level.FINE)) {
                VideoDecoder.this.trace(">>>> Exit ReadFrame");
            }
        }

        VidFrame getFrame(int waitms) throws Throwable {
            VidFrame vf = (VidFrame)this.q.dequeue(waitms);
            if (vf == null) {
                throw new IOException("Timeout waiting for video frame from " + VideoDecoder.this.videoSource.getSlotPathOrd());
            }
            if (vf.imageThrowable != null) {
                throw vf.imageThrowable;
            }
            if (log.isLoggable(Level.FINE)) {
                VideoDecoder.this.trace(">>>> return image ");
            }
            return vf;
        }

        void close() {
            if (log.isLoggable(Level.FINE)) {
                VideoDecoder.this.trace(">>>> close ");
            }
            this.done = true;
            this.notify();
        }
    }
}

