/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platHwScan.ui;

import com.tridium.platHwScan.BBaseBoard;
import com.tridium.platHwScan.BHardwareScanService;
import com.tridium.platHwScan.enums.BLeftRightBottomTopEnum;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="topView", type="boolean", defaultValue="true"), @NiagaraProperty(name="pinsPosition", type="BLeftRightBottomTopEnum", defaultValue="BLeftRightBottomTopEnum.bottom")})
public abstract class BCardWidget
extends BWidget {
    @Generated
    public static final Property topView = BCardWidget.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property pinsPosition = BCardWidget.newProperty((int)0, (BValue)BLeftRightBottomTopEnum.bottom, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCardWidget.class);
    protected BImage image = BImage.NULL;

    @Generated
    public boolean getTopView() {
        return this.getBoolean(topView);
    }

    @Generated
    public void setTopView(boolean v) {
        this.setBoolean(topView, v, null);
    }

    @Generated
    public BLeftRightBottomTopEnum getPinsPosition() {
        return (BLeftRightBottomTopEnum)this.get(pinsPosition);
    }

    @Generated
    public void setPinsPosition(BLeftRightBottomTopEnum v) {
        this.set(pinsPosition, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.paintImage(g);
    }

    protected BImage makeImage(String imageString, BBaseBoard baseBoard) {
        String ref = imageString;
        for (int i = 0; i < 3; ++i) {
            BOrd ord = BOrd.make((String)ref);
            try {
                ord.resolve();
                return BImage.make((BOrd)ord);
            }
            catch (Exception exception) {
                if (i == 0) {
                    ref = baseBoard.getImagesDirectory() + imageString;
                    continue;
                }
                if (i != 1) continue;
                ref = "module://" + BHardwareScanService.TYPE.getModule().getModuleName() + "/images/" + imageString;
                continue;
            }
        }
        return BImage.NULL;
    }

    protected void paintImage(Graphics g) {
        if (this.image.isNull()) {
            return;
        }
        int x = (int)(this.getWidth() - this.image.getWidth()) / 2;
        if (x < 0) {
            x = 0;
        }
        g.drawImage(this.image, (double)x, 0.0);
    }
}

