/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platHwScan.ui;

import com.tridium.platHwScan.BBaseBoard;
import com.tridium.platHwScan.BHardwareScanService;
import com.tridium.platHwScan.optionCards.BOptionCard;
import com.tridium.platHwScan.optionCards.BOptionSlot;
import com.tridium.platHwScan.ports.BPort;
import com.tridium.platHwScan.ui.BCalloutLabel;
import com.tridium.platHwScan.ui.BCardWidget;
import com.tridium.platHwScan.ui.BHardwareScanFormatPalette;
import javax.baja.gx.BBrush;
import javax.baja.gx.BPen;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BWidget;
import javax.baja.workbench.BWbShell;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="slot", type="int", defaultValue="0"), @NiagaraProperty(name="formatPalette", type="BHardwareScanFormatPalette", defaultValue="new BHardwareScanFormatPalette()")})
public class BOptionCardWidget
extends BCardWidget {
    @Generated
    public static final Property slot = BOptionCardWidget.newProperty((int)0, (int)0, null);
    @Generated
    public static final Property formatPalette = BOptionCardWidget.newProperty((int)0, (BValue)new BHardwareScanFormatPalette(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BOptionCardWidget.class);
    protected Array<BCalloutLabel> refTags = new Array(BCalloutLabel.class);

    @Generated
    public int getSlot() {
        return this.getInt(slot);
    }

    @Generated
    public void setSlot(int v) {
        this.setInt(slot, v, null);
    }

    @Generated
    public BHardwareScanFormatPalette getFormatPalette() {
        return (BHardwareScanFormatPalette)this.get(formatPalette);
    }

    @Generated
    public void setFormatPalette(BHardwareScanFormatPalette v) {
        this.set(formatPalette, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() {
        BWbShell shell = BWbShell.getWbShell((BWidget)this);
        if (shell == null) {
            return;
        }
        int slotNo = this.getSlot();
        if (slotNo > 0) {
            BHardwareScanService scanService = (BHardwareScanService)BOrd.make((BOrd)shell.getActiveOrd(), (String)"service:platHwScan:HardwareScanService").get();
            scanService.lease(3);
            BHardwareScanFormatPalette palette = this.getFormatPalette();
            BBaseBoard baseBoard = scanService.getBaseBoardType();
            BOptionSlot slot = (BOptionSlot)baseBoard.get("optionSlot" + slotNo);
            if (slot != null && !slot.isEmpty()) {
                BOptionCard optionCard = (BOptionCard)slot.getContents();
                String imageString = optionCard.getTopViewImage();
                if (!this.getTopView()) {
                    imageString = optionCard.getSideViewImage();
                    BPort[] ports = (BPort[])optionCard.getChildren(BPort.class);
                    for (int i = 0; i < ports.length; ++i) {
                        if (!ports[i].getHasConnector()) continue;
                        BCalloutLabel label = new BCalloutLabel(slotNo + "-" + (i + 1));
                        label.setFont(palette.getBoldFont());
                        label.setForeground(palette.getReferenceColor());
                        label.setBorder(BBorder.make((double)palette.getBorderWidth(), (int)1, (BBrush)palette.getBorderColor()));
                        label.setPadding(palette.getCalloutPadding());
                        label.computePreferredSize();
                        this.refTags.add((Object)label);
                    }
                }
                this.image = this.makeImage(TextUtil.replace((String)imageString, (String)"{0}", (String)TextUtil.toFriendly((String)this.getPinsPosition().getTag())), baseBoard);
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.paintRefTags(g);
    }

    protected void paintRefTags(Graphics g) {
        double w = this.getWidth();
        double h = this.getHeight();
        if (this.refTags.isEmpty()) {
            return;
        }
        BHardwareScanFormatPalette palette = this.getFormatPalette();
        int refCount = this.refTags.size();
        double labelX = w - (double)((refCount - 1) * palette.getCalloutGap());
        for (int i = 0; i < refCount; ++i) {
            labelX -= ((BCalloutLabel)((Object)this.refTags.get(i))).getPreferredWidth();
        }
        if ((labelX = (double)((int)labelX / 2)) < 0.0) {
            labelX = 0.0;
        }
        for (int j = 0; j < refCount; ++j) {
            BCalloutLabel label = (BCalloutLabel)((Object)this.refTags.get(j));
            double labelY = h - (double)((int)label.getPreferredHeight()) - 1.0;
            this.paintTag(g, label, labelX, labelY);
            labelX += label.getPreferredWidth() + (double)palette.getCalloutGap();
        }
    }

    protected void paintTag(Graphics g, BCalloutLabel label, double x, double y) {
        double pw = label.getPreferredWidth();
        double ph = label.getPreferredHeight();
        BHardwareScanFormatPalette palette = this.getFormatPalette();
        g.setFont(label.getFont());
        g.setBrush(label.getForeground());
        g.setPen(BPen.make((double)10.0));
        label.getBorder().paint(g, x, y, pw, ph);
        g.drawString(label.getText(), x + label.getPadding().left, y + ph - label.getPadding().bottom - label.getBorder().bottomWidth);
        g.setPen(BPen.make((double)label.getBorder().topWidth));
        double lineX = x + pw / 2.0;
        g.strokeLine(lineX, y, lineX, this.image.getHeight() + (double)palette.getCalloutProximity());
    }
}

