/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platHwScan.ui;

import com.tridium.platHwScan.BBaseBoard;
import com.tridium.platHwScan.BHardwareScanService;
import com.tridium.platHwScan.enums.BPortTypeEnum;
import com.tridium.platHwScan.optionCards.BOptionCard;
import com.tridium.platHwScan.optionCards.BOptionSlot;
import com.tridium.platHwScan.ports.BPort;
import com.tridium.platHwScan.ui.BCalloutLabel;
import com.tridium.platHwScan.ui.BHardwareScanFormatPalette;
import com.tridium.platHwScan.ui.BOptionCardWidget;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.gx.BPen;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BValueBinding;
import javax.baja.ui.BWidget;
import javax.baja.workbench.BWbShell;

@NiagaraType
public class BTitanOptionModuleWidget
extends BOptionCardWidget {
    @Generated
    public static final Type TYPE = Sys.loadType(BTitanOptionModuleWidget.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() {
        BWbShell shell = BWbShell.getWbShell((BWidget)this);
        if (shell == null) {
            return;
        }
        BValueBinding binding = new BValueBinding();
        binding.setOrd(BOrd.make((BOrd)shell.getActiveOrd(), (String)"service:platHwScan:HardwareScanService"));
        this.add(null, (BValue)binding);
    }

    public void doLayout(BWidget[] kids) {
        this.refTags = new Array(BCalloutLabel.class);
        this.image = BImage.NULL;
        BWbShell shell = BWbShell.getWbShell((BWidget)this);
        if (shell == null) {
            return;
        }
        int slotNo = this.getSlot();
        if (slotNo > 0) {
            BHardwareScanService scanService = (BHardwareScanService)BOrd.make((BOrd)shell.getActiveOrd(), (String)"service:platHwScan:HardwareScanService").get();
            scanService.lease(4);
            BHardwareScanFormatPalette palette = this.getFormatPalette();
            BBaseBoard baseBoard = scanService.getBaseBoardType();
            BOptionSlot slot = (BOptionSlot)baseBoard.get("optionSlot" + slotNo);
            if (slot != null && !slot.isEmpty()) {
                BOptionCard optionCard = (BOptionCard)slot.getContents();
                String imageString = optionCard.getSideViewImage();
                BPort[] ports = (BPort[])optionCard.getChildren(BPort.class);
                for (int i = 0; i < ports.length; ++i) {
                    if (!ports[i].getHasConnector()) continue;
                    BCalloutLabel label = new BCalloutLabel(slotNo + 9 + "-" + (i + 1));
                    label.setFont(palette.getBoldFont());
                    label.setForeground(palette.getReferenceColor());
                    label.setBorder(BBorder.make((double)palette.getBorderWidth(), (int)1, (BBrush)palette.getBorderColor()));
                    label.setPadding(palette.getCalloutPadding());
                    if (ports[i].getPortType().getOrdinal() == BPortTypeEnum.noPort.getOrdinal()) {
                        label.setShowPorts(false);
                    }
                    label.computePreferredSize();
                    this.refTags.add((Object)label);
                }
                this.image = this.makeImage(TextUtil.replace((String)imageString, (String)"{0}", (String)TextUtil.toFriendly((String)this.getPinsPosition().getTag())), baseBoard);
            }
        }
    }

    @Override
    protected void paintRefTags(Graphics g) {
        double labelX;
        double labelY;
        BCalloutLabel label;
        double w = this.getWidth();
        double h = this.getHeight();
        if (this.refTags.isEmpty()) {
            return;
        }
        int refCount = this.refTags.size();
        if (refCount >= 1 && (label = (BCalloutLabel)((Object)this.refTags.get(0))).getShowPorts()) {
            labelY = 1.0;
            labelX = w / 2.0 - ((BCalloutLabel)((Object)this.refTags.get(0))).getPreferredWidth() / 2.0 - 10.0;
            this.paintTag(g, label, labelX, labelY);
        }
        if (refCount >= 2 && (label = (BCalloutLabel)((Object)this.refTags.get(1))).getShowPorts()) {
            labelY = h - (double)((int)label.getPreferredHeight()) - 2.0;
            labelX = w / 2.0 - ((BCalloutLabel)((Object)this.refTags.get(0))).getPreferredWidth() / 2.0 - 10.0;
            this.paintTag(g, label, labelX, labelY);
        }
        this.paintMainTag(g, w, h);
    }

    @Override
    protected void paintTag(Graphics g, BCalloutLabel label, double x, double y) {
        double pw = label.getPreferredWidth();
        double ph = label.getPreferredHeight();
        g.setFont(label.getFont());
        g.setBrush(label.getForeground());
        g.setPen(BPen.make((double)10.0));
        label.getBorder().paint(g, x, y, pw, ph);
        g.drawString(label.getText(), x + label.getPadding().left, y + ph - label.getPadding().bottom - label.getBorder().bottomWidth);
        g.setPen(BPen.make((double)label.getBorder().topWidth));
        double lineX = x + pw / 2.0;
        if (y == 1.0) {
            g.strokeLine(lineX, y + ph, lineX, y + ph + 25.0);
        } else {
            g.strokeLine(lineX, y, lineX, y - 25.0);
        }
    }

    private void paintMainTag(Graphics g, double w, double h) {
        BHardwareScanFormatPalette palette = this.getFormatPalette();
        int slotNo = this.getSlot();
        BCalloutLabel label = new BCalloutLabel(slotNo + 9 + "");
        label.setFont(palette.getBoldFont());
        label.setForeground(palette.getReferenceColor());
        label.setBorder(BBorder.make((double)palette.getBorderWidth(), (int)1, (BBrush)palette.getBorderColor()));
        label.setPadding(palette.getCalloutPadding());
        label.computePreferredSize();
        g.setFont(label.getFont());
        g.setBrush(label.getForeground());
        g.setPen(BPen.make((double)10.0));
        double pw = label.getPreferredWidth();
        double ph = label.getPreferredHeight();
        double x = w / 2.0 - pw / 2.0;
        double y = h / 2.0 - ph / 2.0;
        label.getBorder().paint(g, x, y, pw, ph);
        g.drawString(label.getText(), x + label.getPadding().left, y + ph - label.getPadding().bottom - label.getBorder().bottomWidth);
    }
}

