/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx;

import com.tridium.hx.BHxContainerJsBuild;
import com.tridium.hx.BHxWebWidget;
import com.tridium.hx.util.BenchmarkCommand;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.web.Template;
import com.tridium.web.WebEnv;
import com.tridium.web.servlets.ViewAllOrdServlet;
import com.tridium.webeditors.ux.wb.profile.BServletViewWidget;
import java.io.StringWriter;
import java.io.Writer;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.data.BIDataValue;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.hx.BHxProfile;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.function.ConsumerCanThrowException;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BPermissions;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BModule;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.web.BWebProfileConfig;
import javax.baja.web.WebOp;
import javax.baja.web.js.BIWebResource;
import javax.baja.web.js.BJsBuild;
import javax.baja.web.js.JsInfo;
import javax.baja.webeditors.ux.BWebEditorsJsBuild;
import org.owasp.encoder.Encode;

@NiagaraType
@NiagaraSingleton
public class BHTML5HxProfile
extends BHxProfile {
    @Generated
    public static final BHTML5HxProfile INSTANCE = new BHTML5HxProfile();
    @Generated
    public static final Type TYPE = Sys.loadType(BHTML5HxProfile.class);
    private static final AgentFilter wbViewFilter = AgentFilter.is((TypeInfo)WebEnv.wbView);
    private static final String navTreeSideBarKey = "navTreeSideBar";
    private static final String enableHxWbViewsKey = "hxWbViews";
    private static final String enableViewSelectionKey = "viewSelection";
    private static final String navFileTreeKey = "navFileTree";
    private static final String hierarchiesTreeKey = "hierarchiesTree";
    private static final String searchSideBarKey = "searchSideBar";
    private static final List<String> sideBarConfigOptions = Arrays.asList("navTreeSideBar", "searchSideBar", "paletteSideBar");
    private static final Map<String, String> keyToClassName = new HashMap<String, String>();
    private static final List<String> treeConfigOptions;
    private static final List<String> configOptions;
    private static final BFacets yesNoFacets;
    private static final boolean dynamicLoading;
    private static final boolean HIDE_MEDIA_COMMAND;
    private static final JsInfo profileJsInfo;
    private static final JsInfo containerJsInfo;
    private static final BOrd splitPaneCss;
    private static final BOrd profileCss;
    private static final BOrd bajauxContainerCss;
    private static final BOrd coreThemeCss;
    private static final BOrd profileVm;
    private static final BPermissions searchPermissions;
    private static Command benchmark;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHTML5HxProfile() {
        benchmark = new Html5BenchmarkCommand();
        this.registerEvent(benchmark);
    }

    @Override
    public Command getBenchmarkCommand() {
        return benchmark;
    }

    @Override
    public void writeDocument(BHxView view, HxOp op) throws Exception {
        op.addHeadTag("<meta name='viewport' content='width=device-width initial-scale=1.0 target-densityDpi=medium-dpi'/>");
        super.writeDocument(view, op);
    }

    @Override
    public void doBody(BHxView view, HxOp op) throws Exception {
        boolean fullScreen;
        if (!op.isBindResources()) {
            op.addStyleSheet(bajauxContainerCss);
            op.addStyleSheet(hxContainerCss);
            op.addStyleSheet(coreThemeCss);
            op.addStyleSheet(splitPaneCss);
            op.addStyleSheet(profileCss);
        }
        BHxWebWidget.addUxThemeStyleSheet(op);
        BIFile fullScreenUtils = (BIFile)BOrd.make((String)"module://hx/rc/container/fullScreenUtils.js").get();
        op.addGlobal(BajaFileUtil.readString((BIFile)fullScreenUtils));
        op.addGlobal("window.fullScreenUtils.validate();");
        if ("true".equals(op.getViewParameter("previewMedia", "false"))) {
            op.addGlobal("window.name = 'fullScreen' + new Date().getTime();");
        }
        if (fullScreen = this.isFullScreen(view, op)) {
            op.addGlobal("require(['nmodule/webEditors/rc/wb/profile/fullScreen'],function(){});");
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"<div class='window-bg hx-fullscreen'>");
            super.doBody(view, op);
            out.w((Object)"</div>");
            return;
        }
        if (!(view instanceof BHxWebWidget)) {
            op.setAttribute("hxWebWidget", BServletViewWidget.INSTANCE);
        }
        String content = HxUtil.marshal((ConsumerCanThrowException<? super HxOp, Exception>)((ConsumerCanThrowException)sOp -> {
            BHxWebWidget.INSTANCE.write((HxOp)((Object)sOp));
            this.displayError((HxOp)((Object)sOp));
        }), op);
        Lexicon lex = Lexicon.make((BModule)BServletViewWidget.TYPE.getModule(), (Context)op);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("containerJs", containerJsInfo.getJsId());
        map.put("profileJs", profileJsInfo.getJsId());
        JSONArray dependencies = BIWebResource.resolve(Arrays.asList(new BJsBuild[]{BWebEditorsJsBuild.INSTANCE, BHxContainerJsBuild.INSTANCE})).toJSON();
        map.put("deps", dependencies.toString());
        map.put("content", content);
        map.put("bajaux", Boolean.toString(view instanceof BHxWebWidget));
        map.put("dynamicLoading", Boolean.toString(dynamicLoading));
        map.put("displayName", view.getPageTitle(op).replace("\\", "\\\\").replace("\"", "\\\""));
        map.put("ord", op.getOrdWithoutViewQuery().toString());
        map.put("stationName", Encode.forHtml((String)Sys.getStation().getStationName()));
        map.put("viewInfo", ViewAllOrdServlet.writeViewList((WebOp)op, (Writer)new StringWriter()).toString());
        map.put("loading", Encode.forJavaScriptAttribute((String)lex.getHtmlSafe("loading")));
        map.put("logoff", lex.getHtmlSafe("profileLogoff"));
        map.put("home", op.getWebEnv().getHomePage((WebOp)op).toString());
        BWebProfileConfig config = op.getProfileConfig();
        JSONObject profileConfig = BHTML5HxProfile.getProfileConfigOptions(config, (Context)op);
        map.put("sideBarConfigOptions", "[" + sideBarConfigOptions.stream().filter(arg_0 -> ((JSONObject)profileConfig).getBoolean(arg_0)).map(key -> String.format("{'key':'%s','displayName':'%s','className':'%s'}", key, lex.getHtmlSafe(key), keyToClassName.get(key))).collect(Collectors.joining(",")) + "]");
        map.put("isMediaCommandAvailable", Boolean.toString(!HIDE_MEDIA_COMMAND && profileConfig.getBoolean(enableViewSelectionKey)));
        map.put("configOptions", profileConfig.toString());
        map.put("viewSelectorElement", profileConfig.getBoolean(enableViewSelectionKey) ? "<div class=\"controls\"></div>" : "");
        op.addHeadTag("<script type='text/javascript'>\n  var require = typeof require === 'undefined' ? {} : require;\n  require.config = require.config || {};\n  require.config.baja = require.config.baja || {};\n  require.config.baja.start = require.config.baja.start || {};\n  require.config.baja.start.navFile = true;\n</script>");
        op.getWriter().write(Template.process(map, (BOrd)profileVm));
    }

    private static JSONObject getProfileConfigOptions(BWebProfileConfig config, Context cx) {
        boolean navTreeSideBarEnabled = BHTML5HxProfile.isEnabled(config, navTreeSideBarKey) && treeConfigOptions.stream().filter(key -> BHTML5HxProfile.isEnabled(config, key)).toArray().length > 0;
        JSONObject obj = new JSONObject();
        Function<String, Boolean> shouldBeEnabled = key -> {
            if (key.equals(navTreeSideBarKey)) {
                return navTreeSideBarEnabled;
            }
            if (!navTreeSideBarEnabled && treeConfigOptions.contains(key)) {
                return false;
            }
            if (key.equals(navFileTreeKey) && cx.getUser().getNavFile().isNull()) {
                return false;
            }
            if (key.equals(hierarchiesTreeKey) && !BHTML5HxProfile.isHierarchyAvailable(cx)) {
                return false;
            }
            if (key.equals(searchSideBarKey) && !BHTML5HxProfile.isSearchAvailable(cx)) {
                return false;
            }
            return BHTML5HxProfile.isEnabled(config, key);
        };
        configOptions.forEach(key -> obj.put(key, shouldBeEnabled.apply((String)key)));
        return obj;
    }

    private static boolean isSearchAvailable(Context cx) {
        return BHTML5HxProfile.isServiceAvailable("search:SearchService", searchPermissions, cx);
    }

    private static boolean isHierarchyAvailable(Context cx) {
        return BHTML5HxProfile.isServiceAvailable("hierarchy:HierarchyService", BPermissions.operatorRead, cx);
    }

    private static boolean isServiceAvailable(String serviceTypeSpec, BPermissions requiredPermissions, Context cx) {
        try {
            BComponent c = Sys.getService((Type)Sys.getType((String)serviceTypeSpec));
            return c.getPermissions(cx).has(requiredPermissions);
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    @Override
    public AgentList getViews(HxOp op) {
        AgentList list = super.getViews(op);
        list.remove("mobile:MobileFieldEditorView");
        list.remove("web:FileUploadView");
        BBoolean enableHxWbViews = (BBoolean)op.getProfileConfig().get(enableHxWbViewsKey);
        if (enableHxWbViews != null && !enableHxWbViews.getBoolean()) {
            list = list.filter(AgentFilter.not((AgentFilter)wbViewFilter));
        }
        int propertySheetIndex = list.indexOf("workbench:PropertySheet");
        int multiSheetIndex = list.indexOf("webEditors:MultiSheet");
        if (propertySheetIndex >= 0 && propertySheetIndex < multiSheetIndex) {
            list.swap(propertySheetIndex, multiSheetIndex);
        }
        return list;
    }

    @Override
    public String getAppName() {
        return "webShell";
    }

    private static boolean isEnabled(BWebProfileConfig config, String key) {
        BIBoolean val = (BIBoolean)config.get(key);
        return val == null ? ((BIBoolean)INSTANCE.getConfig(key)).getBoolean() : val.getBoolean();
    }

    @Override
    public String[] listConfig() {
        ArrayList<String> list = new ArrayList<String>();
        String[] configList = super.listConfig();
        if (configList != null) {
            Collections.addAll(list, configList);
        }
        list.addAll(configOptions);
        return list.toArray(new String[0]);
    }

    @Override
    public BValue getConfig(String key) {
        if (configOptions.contains(key)) {
            return BBoolean.TRUE;
        }
        return super.getConfig(key);
    }

    @Override
    public BFacets getConfigFacets(String key) {
        if (configOptions.contains(key)) {
            return yesNoFacets;
        }
        return super.getConfigFacets(key);
    }

    static {
        keyToClassName.put(navTreeSideBarKey, "icon-icons-x16-listView");
        keyToClassName.put(searchSideBarKey, "icon-icons-x16-magnifyingGlass");
        keyToClassName.put("paletteSideBar", "icon-icons-x16-openPalette");
        treeConfigOptions = Arrays.asList(navFileTreeKey, "configTree", "filesTree", "historiesTree", hierarchiesTreeKey);
        configOptions = new ArrayList<String>();
        configOptions.add(enableHxWbViewsKey);
        configOptions.addAll(sideBarConfigOptions);
        configOptions.addAll(treeConfigOptions);
        configOptions.add(enableViewSelectionKey);
        yesNoFacets = BFacets.make((String)"trueText", (BIDataValue)BString.make((String)"%lexicon(bajaui:dialog.yes)%"), (String)"falseText", (BIDataValue)BString.make((String)"%lexicon(bajaui:dialog.no)%"));
        dynamicLoading = "true".equals(AccessController.doPrivileged(() -> System.getProperty("niagara.profile.dynamicLoading", "true")));
        HIDE_MEDIA_COMMAND = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.profile.hideMediaCommand"));
        profileJsInfo = JsInfo.make((BOrd)BOrd.make((String)"module://webEditors/rc/wb/profile/profile.js"), (Type)BWebEditorsJsBuild.TYPE);
        containerJsInfo = JsInfo.make((BOrd)BOrd.make((String)"module://hx/rc/container/hxContainer.js"), (Type)BHxContainerJsBuild.TYPE);
        splitPaneCss = BOrd.make((String)"module://js/rc/jquery/split-pane/split-pane.css");
        profileCss = BOrd.make((String)"module://webEditors/rc/wb/profile/profile.css");
        bajauxContainerCss = BOrd.make((String)"module://bajaux/rc/container/container.css");
        coreThemeCss = BOrd.make((String)"module://web/rc/theme/theme.css");
        profileVm = BOrd.make((String)"module://webEditors/rc/wb/profile/profile.vm");
        searchPermissions = BPermissions.operatorRead.or(BPermissions.operatorInvoke);
    }

    private class Html5BenchmarkCommand
    extends BenchmarkCommand {
        private Html5BenchmarkCommand() {
        }

        @Override
        public String getInvokeCode(HxOp op) {
            return "fullScreenUtils.loadTime(\"" + this.getId() + "\");";
        }
    }
}

