/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx;

import com.tridium.hx.HxHyperlinkInfo;
import com.tridium.web.WebUtil;
import com.tridium.web.servlets.ViewAllOrdServlet;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.file.BDirectory;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.hx.px.MouseEventCommand;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.naming.ViewQuery;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavContainer;
import javax.baja.nav.BNavFileNode;
import javax.baja.nav.BNavFileSpace;
import javax.baja.nav.NavFileDecoder;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BSpace;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.util.LexiconModule;
import javax.servlet.http.HttpServletRequest;

@NiagaraType
@NiagaraSingleton
public class BHxPathBar
extends BHxView {
    @Generated
    public static final BHxPathBar INSTANCE = new BHxPathBar();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxPathBar.class);
    private BOrd stationSpace = BOrd.make((String)"station:|slot:/");
    private BOrd fileSpace = BOrd.make((String)"file:^");
    private BOrd historySpace = BOrd.make((String)"history:");
    protected PathMouseEvent pathMouseEvent = new PathMouseEvent(this);
    private static LexiconModule FOX_LEX = LexiconModule.make((String)"fox");

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxPathBar() {
        this.registerEvent(this.pathMouseEvent);
    }

    @Override
    public void write(HxOp op) throws Exception {
        boolean doLinks;
        boolean navOnly = op.getFacets().getb("restrictToNavFile", false);
        boolean doShowViewMenu = op.getFacets().getb("showViewMenu", true);
        HtmlWriter out = op.getHtmlWriter();
        out.println("<script type='text/javascript'>");
        out.println("function pathBarViewSelected(event)");
        out.println("{");
        out.println("  var select = (!event.target) ? window.event.srcElement : event.target;");
        out.println("  hx.hyperlink(select.options[select.selectedIndex].value);");
        out.println("}");
        out.println("</script>");
        Object root = null;
        root = !(op.get() instanceof BINavNode) ? Sys.getStation() : (BINavNode)op.get();
        BOrd nav = op.getUser().getNavFile();
        boolean bl = doLinks = !navOnly;
        if (!nav.isNull() && root.getNavOrd() != null) {
            try {
                BNavFileSpace space = NavFileDecoder.load((BOrd)nav);
                BINavNode target = (BINavNode)op.get();
                BNavFileNode node = null;
                if (op.getViewQuery() == null) {
                    node = space.lookup(target.getNavOrd().normalize());
                    if (node == null) {
                        AgentInfo defaultView = HxHyperlinkInfo.getViews(op).getDefault();
                        node = space.lookup(BOrd.make((String)(target.getNavOrd().normalize().toString() + "|view:" + defaultView.getDisplayName((Context)op))));
                    }
                } else {
                    node = space.lookup(BOrd.make((String)(target.getNavOrd().normalize().toString() + "|" + op.getViewQuery())));
                }
                if (node != null) {
                    root = node;
                    doLinks = true;
                }
            }
            catch (UnresolvedException ue) {
                throw new BajaRuntimeException("Account uses invalid nav file.", (Throwable)ue);
            }
        }
        ArrayList<BINavNode> path = this.getPath((BINavNode)root);
        out.print("<div class='hx-PathBar-border' oncontextmenu='return false;'>");
        out.print("<div id='hx-PathBar-path' class='hx-PathBar-path");
        out.println("'>");
        out.println("<table width='100%' style='cursor: default;' height='100%' cellspacing='0' cellpadding='0'><tr>");
        out.println("<td valign='middle' style='white-space:nowrap;'>");
        this.doDrawPath((BINavNode)root, path, nav, doLinks, op);
        out.println("</td>");
        out.println("<td align='right' valign='middle' style='white-space:nowrap;'>");
        out.println("<div id='hx-PathBar' class='hx-PathBar'>");
        this.doDrawUtil(path, doShowViewMenu, doLinks, op);
        out.println("</div>");
        out.println("</td>");
        out.println("</tr></table>");
        out.println("</div>");
        out.println("<div class='hx-PathBar-children' id='hx-PathBar-children'>");
        out.println("<table width='100%' height='100%' cellspacing='0' cellpadding='0'><tr>");
        out.println("<td valign='middle' style='white-space:nowrap; '>");
        BINavNode[] kids = root.getNavChildren();
        kids = BNavContainer.filter((BINavNode[])kids, (Context)op);
        if (doLinks && kids.length > 0 && root.hasNavChildren()) {
            this.doDrawChildren(kids, op);
        }
        out.println("</td></tr></table>");
        out.println("</div>");
        out.println("</div>");
        out.println("<script type='text/javascript'>");
        out.println("hx.fixHxPathBar();");
        out.println("</script>");
    }

    protected void doDrawChildren(BINavNode[] kids, HxOp op) {
        try {
            HtmlWriter out = op.getHtmlWriter();
            int size = kids.length > 20 ? 20 : kids.length;
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    out.println("&nbsp;&nbsp;");
                }
                this.doDrawNode(kids[i], true, op);
            }
            if (kids.length > 20) {
                out.print("&nbsp;&nbsp;...");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void doDrawUtil(ArrayList<BINavNode> path, boolean doShowViewMenu, boolean doLinks, HxOp op) {
        if (doLinks) {
            try {
                HtmlWriter out = op.getHtmlWriter();
                BINavNode station = null;
                BINavNode file = null;
                BINavNode history = null;
                try {
                    station = (BINavNode)this.stationSpace.get(op.get(), (Context)op);
                }
                catch (Exception e) {
                    station = null;
                }
                try {
                    station = (BINavNode)this.stationSpace.get(op.get(), (Context)op);
                }
                catch (Exception e) {
                    station = null;
                }
                try {
                    file = (BINavNode)this.fileSpace.get(op.get(), (Context)op);
                }
                catch (Exception e) {
                    file = null;
                }
                try {
                    history = (BINavNode)this.historySpace.get(op.get(), (Context)op);
                }
                catch (Exception e) {
                    history = null;
                }
                if (station != null) {
                    out.println("&nbsp;&nbsp;");
                    this.doDrawNode(station, true, op);
                }
                if (file != null) {
                    out.println("&nbsp;&nbsp;");
                    this.doDrawNode(file, true, op);
                }
                if (history != null) {
                    out.println("&nbsp;&nbsp;");
                    this.doDrawNode(history, true, op);
                }
                out.println("&nbsp;&nbsp;");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            String csrfTokenQs = HxUtil.getCsrfTokenQueryString();
            HtmlWriter out = op.getHtmlWriter();
            out.println("<a class='hx-PathBar' href='#' onclick='hx.hyperlink(\"/logout" + csrfTokenQs + "\");'>");
            HxUtil.makeImageJS(BImage.make((BOrd)BOrd.make((String)"module://icons/x16/clear.png")), "style='vertical-align: middle; border: 0px;'", "Logout", op);
            out.println("&nbsp;Logout</a>&nbsp;&nbsp;");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (doShowViewMenu) {
            this.doViewMenu(op);
        }
    }

    protected void doDrawPath(BINavNode root, ArrayList<BINavNode> path, BOrd nav, boolean doLinks, HxOp op) {
        try {
            HtmlWriter out = op.getHtmlWriter();
            if (!nav.isNull()) {
                BNavFileSpace space = NavFileDecoder.load((BOrd)nav);
                this.doDrawNode((BINavNode)space.getRootNode(), true, op);
                for (int i = 0; i < path.size(); ++i) {
                    BINavNode node = path.get(i);
                    if (node.equals(space.getRootNode())) continue;
                    out.println("&nbsp;&nbsp;");
                    this.doDrawNode(node, doLinks, op);
                }
            } else {
                for (int i = 0; i < path.size(); ++i) {
                    BINavNode node = path.get(i);
                    if (i > 0) {
                        out.println("&nbsp;&nbsp;");
                    }
                    this.doDrawNode(node, doLinks, op);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void doDrawNode(BINavNode node, boolean doLinks, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        BImage icon = BImage.make((BIcon)node.getNavIcon());
        String name = node.getNavDisplayName((Context)op);
        if (node instanceof BDirectory && this.fileSpace.equals((Object)((BDirectory)node).getOrdInSession())) {
            icon = BImage.make((String)"module://icons/x16/drive.png");
            name = FOX_LEX.getText("nav.fileSystem", (Context)op);
        }
        if (doLinks) {
            HxUtil.writeSafeAnchorStart(node.getNavOrd(), op);
            out.w((Object)(" oncontextmenu='" + this.pathMouseEvent.getInvokeCode(node, 501, op) + "'>"));
        } else {
            out.print("<span style='cursor: default;'>");
        }
        if (icon != null && icon.getOrdList().size() > 0) {
            HxUtil.makeImageJS(icon, "style='width: 16px; height: 16px;'", node.getNavDisplayName((Context)op), op);
        }
        out.print("&nbsp;");
        out.safe((Object)name);
        if (doLinks) {
            out.print("</a>");
        } else {
            out.print("</span>");
        }
    }

    protected void doViewMenu(HxOp op) {
        try {
            HtmlWriter out = op.getHtmlWriter();
            AgentList agents = HxUtil.getViewsForViewSelector(op);
            String defViewId = HxUtil.getDefaultView(op).getAgentId();
            ViewQuery viewQuery = op.getViewQuery();
            AgentInfo selectedAgent = null;
            if (viewQuery != null) {
                String viewId = viewQuery.getViewId();
                selectedAgent = BHxPathBar.getSelectedAgent(viewId, defViewId, agents);
            }
            out.println("<select onchange='pathBarViewSelected(event);'>");
            for (int i = 0; i < agents.size(); ++i) {
                AgentInfo agent = agents.get(i);
                String name = agent.getDisplayName((Context)op);
                String agentId = agent.getAgentId();
                out.print("<option");
                if (selectedAgent != null && agent.equals(selectedAgent)) {
                    out.print(" selected='selected'");
                }
                BOrd ord = BOrd.make((String)(op.getOrdWithoutViewQuery() + "|view:" + agentId)).relativizeToSession();
                out.w((Object)(" value='" + HxUtil.encodeOrdForHref(ord, op) + "'>")).safe((Object)name).w((Object)"</option>");
            }
            out.println("</select>");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static AgentInfo getSelectedAgent(String viewId, String defViewId, AgentList agents) {
        AgentInfo agent;
        int i;
        if (viewId == null) {
            return null;
        }
        for (i = 0; i < agents.size(); ++i) {
            agent = agents.get(i);
            String agentId = agent.getAgentId();
            if (!viewId.equals(agentId)) continue;
            return agent;
        }
        for (i = 0; i < agents.size(); ++i) {
            agent = agents.get(i);
            if (!ViewAllOrdServlet.isSelectedViewId((String)viewId, (AgentInfo)agent)) continue;
            return agent;
        }
        for (i = 0; i < agents.size(); ++i) {
            agent = agents.get(i);
            if (!ViewAllOrdServlet.isSelectedViewId((String)defViewId, (AgentInfo)agent)) continue;
            return agent;
        }
        return null;
    }

    protected ArrayList<BINavNode> getPath(BINavNode parent) {
        ArrayList<BINavNode> path = new ArrayList<BINavNode>();
        while (parent != null && this.isValidParent(parent)) {
            path.add(0, parent);
            try {
                parent = parent.getNavParent();
            }
            catch (AccessControlException ignore) {
                parent = null;
            }
        }
        return path;
    }

    protected boolean isValidParent(BINavNode node) {
        return !(node instanceof BSpace);
    }

    private class NavChildrenMenu
    extends Dialog {
        BINavNode node;

        public NavChildrenMenu(BINavNode node) {
            super((String)null, null);
            this.node = node;
        }

        @Override
        protected void writeContent(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            BINavNode[] kids = BNavContainer.filter((BINavNode[])this.node.getNavChildren(), (Context)op);
            for (int i = 0; i < kids.length; ++i) {
                BINavNode kid = kids[i];
                HxUtil.writeContextMenuListItem(kid, op);
            }
        }

        @Override
        public Command[] getCommands() {
            return new Command[0];
        }

        @Override
        protected String getTitle(HxOp op) {
            return this.node.getNavDisplayName((Context)op);
        }

        @Override
        public void open(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"var body = \"");
            this.write(op);
            out.w((Object)"\";");
            out.w((Object)"hx.doShowMenu(body);");
            if (this.onload.length() > 0) {
                out.w((Object)this.onload.toString());
            }
            String[] code = op.getOnload();
            for (int i = 0; i < code.length; ++i) {
                out.w((Object)code[i]);
            }
        }

        @Override
        public void write(HxOp op) throws Exception {
            this.writeContent(op);
        }
    }

    protected class PathMouseEvent
    extends MouseEventCommand {
        public PathMouseEvent(BHxView view) {
            super(view);
        }

        @Override
        public void handle(HxOp op) throws Exception {
            block11: {
                try {
                    BINavNode[] kids;
                    HtmlWriter out = op.getHtmlWriter();
                    BInputEvent event = this.getEvent(op);
                    if (!(event instanceof BMouseEvent) || event.getId() != 502) break block11;
                    BMouseEvent mouseEvent = (BMouseEvent)event;
                    BOrd navOrd = BOrd.make((String)op.getUnsafeFormValue("navOrd"));
                    if (mouseEvent.isButton1Down()) {
                        out.w((Object)"hx.hyperlink('").w((Object)WebUtil.toUri((OrdTarget)op, (HttpServletRequest)op.getRequest(), (BOrd)navOrd)).w((Object)"');");
                    }
                    BOrd navFileOrd = op.getUser().getNavFile();
                    BNavFileNode node = null;
                    if (!navFileOrd.isNull()) {
                        BNavFileSpace space = NavFileDecoder.load((BOrd)navFileOrd);
                        node = space.lookup(navOrd);
                    } else {
                        try {
                            BObject o = navOrd.get();
                            if (o instanceof BINavNode) {
                                node = (BINavNode)o;
                            }
                        }
                        catch (Exception o) {
                            // empty catch block
                        }
                    }
                    if (node != null && (kids = BNavContainer.filter((BINavNode[])node.getNavChildren(), (Context)op)).length > 0 && mouseEvent.isButton2Down()) {
                        try {
                            new NavChildrenMenu((BINavNode)node).open(op);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public String getInvokeCode(BINavNode node, int event, HxOp op) {
            String quote = "\"";
            StringBuilder buf = new StringBuilder();
            try {
                buf.append("hx.setFormValue(" + quote + op.scope("navOrd") + quote + ", " + quote + HxUtil.encodeURLForHref(node.getNavOrd().toString()) + quote + ");");
                buf.append(super.getInvokeCode(event, op));
            }
            catch (Exception e) {
                BHxView.log.log(Level.INFO, "HxPathBar.getInvokeCode error", e);
            }
            return buf.toString();
        }

        @Override
        protected BInputEvent getEvent(HxOp op) {
            if ((op = this.getRootHxOp(op)).getFormValue("button") == null) {
                return null;
            }
            int modifiers = 0;
            modifiers = "right".equals(op.getFormValue("button")) ? (modifiers |= 0x800) : (modifiers |= 0x400);
            if ("true".equals(op.getFormValue("shiftModifier"))) {
                modifiers |= 0x40;
            }
            if ("true".equals(op.getFormValue("altModifier"))) {
                modifiers |= 0x200;
            }
            if ("true".equals(op.getFormValue("ctrlModifier"))) {
                modifiers |= 0x80;
            }
            if ("true".equals(op.getFormValue("metaModifier"))) {
                modifiers |= 0x100;
            }
            int clickCount = 1;
            if (op.getFormValue("doubleClick") != null) {
                clickCount = 2;
            }
            double x = Double.parseDouble(op.getFormValue("x"));
            double y = Double.parseDouble(op.getFormValue("y"));
            return new BMouseEvent(502, null, modifiers, x, y, clickCount, false);
        }
    }
}

