/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx.fieldeditors;

import com.tridium.util.TimeFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.workbench.CannotSaveException;

@NiagaraType(agent={@AgentOn(types={"workbench:AbsTimeFE"})})
@NiagaraSingleton
public class BHxAbsTimeFE
extends BHxFieldEditor {
    @Generated
    public static final BHxAbsTimeFE INSTANCE = new BHxAbsTimeFE();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxAbsTimeFE.class);
    MonthConverter monthConverter = new MonthConverter();
    MonthTagConverter monthTagConverter = new MonthTagConverter();
    HourConverter hourConverter = new HourConverter();
    AmPmConverter ampmConverter = new AmPmConverter();
    SimplePadConverter padConverter = new SimplePadConverter();

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxAbsTimeFE() {
    }

    @Override
    public void write(HxOp op) throws Exception {
        BAbsTime abs = (BAbsTime)op.get();
        int[] pattern = TimeFormat.pattern((Context)op);
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<span style='white-space:nowrap;'>");
        BBoolean b = (BBoolean)op.getFacet("showMilliseconds");
        boolean showMillis = b != null ? b.getBoolean() : false;
        BTimeZone tz = (BTimeZone)op.getFacet("TimeZone");
        if (tz != null) {
            abs = BAbsTime.make((BAbsTime)abs, (BTimeZone)tz);
        }
        block13: for (int i = 0; i < pattern.length; ++i) {
            switch (pattern[i]) {
                case 1: 
                case 2: {
                    BAbsTime now = BAbsTime.now();
                    this.writeYearField("year", abs.getYear(), op);
                    continue block13;
                }
                case 3: 
                case 4: {
                    this.writeField("month", abs.getMonth().getOrdinal(), 0, 11, this.monthConverter, op);
                    continue block13;
                }
                case 5: {
                    this.writeField("month", abs.getMonth().getOrdinal(), 0, 11, this.monthTagConverter, op);
                    continue block13;
                }
                case 6: 
                case 7: {
                    this.writeField("day", abs.getDay(), 1, 31, this.padConverter, op);
                    continue block13;
                }
                case 8: 
                case 9: {
                    int h = abs.getHour();
                    if (h > 12) {
                        h -= 12;
                    }
                    if (h == 0) {
                        h = 12;
                    }
                    this.writeField("twelveHour", h - 1, 0, 11, this.hourConverter, op);
                    continue block13;
                }
                case 10: 
                case 11: {
                    this.writeField("hour", abs.getHour(), 0, 23, this.padConverter, op);
                    continue block13;
                }
                case 12: {
                    this.writeField("min", abs.getMinute(), 0, 59, this.padConverter, op);
                    continue block13;
                }
                case 13: {
                    this.writeField("ampm", abs.getHour() < 12 ? 0 : 1, 0, 1, this.ampmConverter, op);
                    continue block13;
                }
                case 14: {
                    this.writeField("sec", abs.getSecond(), 0, 59, this.padConverter, op);
                    if (!showMillis) continue block13;
                    String ms = "" + abs.getMillisecond();
                    while (ms.length() < 3) {
                        ms = "0" + ms;
                    }
                    out.w((Object)".");
                    out.w((Object)"<input ").attr("type", "text");
                    if (!op.canWrite()) {
                        out.w((Object)" readonly='readonly'");
                    }
                    out.w((Object)" ").attr("name", op.scope("millis"));
                    out.w((Object)" ").attr("size", "3");
                    out.w((Object)" ").attr("value", ms);
                    out.w((Object)"/>");
                    continue block13;
                }
                case 15: {
                    String s = abs.getTimeZoneShortName((Context)op);
                    if (s == null) {
                        s = "???";
                    }
                    out.w((Object)s);
                    continue block13;
                }
                case 16: 
                case 17: {
                    continue block13;
                }
                default: {
                    out.w((char)pattern[i]);
                }
            }
        }
        out.w((Object)"</span>");
    }

    @Override
    public void update(HxOp op) throws Exception {
        BAbsTime abs = (BAbsTime)op.get();
        int[] pattern = TimeFormat.pattern((Context)op);
        BBoolean b = (BBoolean)op.getFacet("showMilliseconds");
        boolean showMillis = b != null ? b.getBoolean() : false;
        BTimeZone tz = (BTimeZone)op.getFacet("TimeZone");
        if (tz != null) {
            abs = BAbsTime.make((BAbsTime)abs, (BTimeZone)tz);
        }
        block13: for (int i = 0; i < pattern.length; ++i) {
            switch (pattern[i]) {
                case 1: 
                case 2: {
                    BAbsTime now = BAbsTime.now();
                    this.updateField("year", abs.getYear(), 1969, now.getYear() + 7, null, op);
                    continue block13;
                }
                case 3: 
                case 4: {
                    this.updateField("month", abs.getMonth().getOrdinal(), 0, 11, this.monthConverter, op);
                    continue block13;
                }
                case 5: {
                    this.updateField("month", abs.getMonth().getOrdinal(), 0, 11, this.monthTagConverter, op);
                    continue block13;
                }
                case 6: 
                case 7: {
                    this.updateField("day", abs.getDay(), 1, 31, this.padConverter, op);
                    continue block13;
                }
                case 8: 
                case 9: {
                    int h = abs.getHour();
                    if (h > 12) {
                        h -= 12;
                    }
                    this.updateField("twelveHour", h - 1, 0, 11, this.hourConverter, op);
                    continue block13;
                }
                case 10: 
                case 11: {
                    this.updateField("hour", abs.getHour(), 0, 23, this.padConverter, op);
                    continue block13;
                }
                case 12: {
                    this.updateField("min", abs.getMinute(), 0, 59, this.padConverter, op);
                    continue block13;
                }
                case 13: {
                    this.updateField("ampm", abs.getHour() < 12 ? 0 : 1, 0, 1, this.ampmConverter, op);
                    continue block13;
                }
                case 14: {
                    this.updateField("sec", abs.getSecond(), 0, 59, this.padConverter, op);
                    if (!showMillis) continue block13;
                    String ms = "" + abs.getMillisecond();
                    while (ms.length() < 3) {
                        ms = "0" + ms;
                    }
                    continue block13;
                }
                case 15: {
                    String s = abs.getTimeZoneShortName((Context)op);
                    if (s != null) continue block13;
                    s = "???";
                    continue block13;
                }
                case 16: 
                case 17: {
                    continue block13;
                }
            }
        }
    }

    @Override
    public BObject save(HxOp op) throws Exception {
        BAbsTime abs = (BAbsTime)op.get();
        BTimeZone timeZone = abs.getTimeZone();
        Date targetDate = new Date(abs.getMillis());
        GregorianCalendar c = new GregorianCalendar((TimeZone)timeZone.tzSupport());
        c.setTime(targetDate);
        boolean twelveHour = false;
        boolean addPM = false;
        boolean addAM = false;
        int targetSeconds = -1;
        int targetMilliseconds = -1;
        String[] keys = op.getFormKeys();
        if (keys.length == 0) {
            return op.get();
        }
        for (int i = 0; i < keys.length; ++i) {
            int calendarHourOfDay;
            String f = keys[i];
            int value = Integer.parseInt(op.getFormValue(f));
            if (f.equals("twelveHour")) {
                twelveHour = true;
            }
            if (f.equals("year")) {
                if (value > 2100) {
                    throw new CannotSaveException("Invalid year: " + value + " > 2100");
                }
                c.set(1, value);
            }
            if (f.equals("month")) {
                c.set(2, value);
            }
            if (f.equals("day")) {
                c.set(5, value);
            }
            if (f.equals("hour") || f.equals("twelveHour")) {
                calendarHourOfDay = value;
                if (twelveHour) {
                    ++calendarHourOfDay;
                }
                if (twelveHour) {
                    if (addPM) {
                        if (calendarHourOfDay < 12) {
                            calendarHourOfDay += 12;
                        }
                    } else if (addAM && calendarHourOfDay == 12) {
                        calendarHourOfDay = 0;
                    }
                }
                c.set(11, calendarHourOfDay);
            }
            if (f.equals("min")) {
                c.set(12, value);
            }
            if (f.equals("sec")) {
                targetSeconds = value;
            }
            if (f.equals("millis")) {
                targetMilliseconds = value;
            }
            if (f.equals("ampm") && twelveHour) {
                calendarHourOfDay = c.get(11);
                if (value == 1) {
                    if (calendarHourOfDay >= 12) continue;
                    c.set(11, calendarHourOfDay + 12);
                    continue;
                }
                if (calendarHourOfDay != 12) continue;
                c.set(11, 0);
                continue;
            }
            if (!f.equals("ampm") || twelveHour) continue;
            if (value == 1) {
                addPM = true;
                continue;
            }
            addAM = true;
        }
        c.set(13, targetSeconds == -1 ? 0 : targetSeconds);
        c.set(14, targetMilliseconds == -1 ? 0 : targetMilliseconds);
        return BAbsTime.make((long)c.getTime().getTime(), (BTimeZone)timeZone);
    }

    private void writeField(String name, int curr, int min, int max, Converter c, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        boolean readonly = !op.canWrite();
        out.w((Object)"<select ").attr("name", op.scope(name));
        out.w((Object)" id='").w((Object)op.scope(name)).w((Object)"'");
        if (readonly) {
            out.w((Object)" disabled='disabled'");
        }
        out.w((Object)">");
        for (int i = min; i <= max; ++i) {
            out.w((Object)"<option value='").w(i).w((Object)"'");
            if (curr == i) {
                out.w((Object)" selected='selected'");
            }
            out.w((Object)" id='").w((Object)op.scope(name + "." + i)).w((Object)"'");
            out.w((Object)">");
            if (c == null) {
                out.safe((Object)i);
            } else {
                out.safe((Object)c.convert(i, (Context)op));
            }
            out.w((Object)"</option>");
        }
        out.w((Object)"</select>");
    }

    private void writeYearField(String name, int curr, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        boolean readonly = !op.canWrite();
        out.w((Object)"<input ").attr("name", op.scope(name));
        out.attr(" type", "text");
        out.attr(" size", "4");
        out.attr(" value", "" + curr);
        out.w((Object)" id='").w((Object)op.scope(name)).w((Object)"'");
        if (readonly) {
            out.w((Object)" readonly='readonly'");
        }
        out.w((Object)"/>");
    }

    private void updateField(String name, int curr, int min, int max, Converter c, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        boolean readonly = !op.canWrite();
        String quote = "\"";
        out.w((Object)"var field = document.getElementById(").w((Object)quote).w((Object)op.scope(name)).w((Object)quote).w((Object)");");
        out.w((Object)"if (field.setAttribute != null) {");
        if (readonly) {
            out.w((Object)"var value = document.getElementById(").w((Object)quote).w((Object)op.scope(name + "." + curr)).w((Object)quote).w((Object)");");
            out.w((Object)"if (value) {value.selected=true;}");
            out.w((Object)"if(field.type == ").w((Object)quote).w((Object)"text").w((Object)quote).w((Object)"){");
            out.w((Object)("field.value = " + curr + ";"));
            out.w((Object)"field.setAttribute(").w((Object)quote).w((Object)"readOnly").w((Object)quote).w((Object)",").w((Object)quote).w((Object)"readOnly").w((Object)quote).w((Object)"); ");
            out.w((Object)"}");
            out.w((Object)" else ");
            out.w((Object)"field.setAttribute(").w((Object)quote).w((Object)"disabled").w((Object)quote).w((Object)",").w((Object)quote).w((Object)"disabled").w((Object)quote).w((Object)"); }");
        } else {
            out.w((Object)"if(field.type == ").w((Object)quote).w((Object)"text").w((Object)quote).w((Object)")");
            out.w((Object)"field.removeAttribute(").w((Object)quote).w((Object)"readOnly").w((Object)quote).w((Object)"); ");
            out.w((Object)" else ");
            out.w((Object)"field.removeAttribute(").w((Object)quote).w((Object)"disabled").w((Object)quote).w((Object)"); }");
        }
    }

    class SimplePadConverter
    extends Converter {
        SimplePadConverter() {
        }

        @Override
        public String convert(int index, Context cx) {
            if (index < 10) {
                return "0" + Integer.toString(index);
            }
            return Integer.toString(index);
        }
    }

    class AmPmConverter
    extends Converter {
        AmPmConverter() {
        }

        @Override
        public String convert(int index, Context cx) {
            return index == 0 ? "AM" : "PM";
        }
    }

    class HourConverter
    extends Converter {
        HourConverter() {
        }

        @Override
        public String convert(int index, Context cx) {
            if (index < 9) {
                return "0" + Integer.toString(index + 1);
            }
            return Integer.toString(index + 1);
        }
    }

    class MonthTagConverter
    extends Converter {
        MonthTagConverter() {
        }

        @Override
        public String convert(int index, Context cx) {
            return BMonth.make((int)index).getShortDisplayTag(cx);
        }
    }

    class MonthConverter
    extends Converter {
        MonthConverter() {
        }

        @Override
        public String convert(int index, Context cx) {
            if (++index < 10) {
                return "0" + Integer.toString(index);
            }
            return Integer.toString(index);
        }
    }

    abstract class Converter {
        Converter() {
        }

        public abstract String convert(int var1, Context var2);
    }
}

