/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx.fieldeditors;

import java.io.IOException;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.workbench.CannotSaveException;

@NiagaraType(agent={@AgentOn(types={"workbench:RelTimeFE"})})
@NiagaraSingleton
public class BHxRelTimeFE
extends BHxFieldEditor {
    @Generated
    public static final BHxRelTimeFE INSTANCE = new BHxRelTimeFE();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxRelTimeFE.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxRelTimeFE() {
    }

    @Override
    public void write(HxOp op) throws Exception {
        BRelTime value = (BRelTime)op.get();
        HtmlWriter out = op.getHtmlWriter();
        boolean readonly = !op.canWrite();
        BBoolean z = (BBoolean)op.getFacet("showSeconds");
        boolean showSec = z == null ? true : z.getBoolean();
        z = (BBoolean)op.getFacet("showMilliseconds");
        boolean showMillis = z == null ? false : z.getBoolean();
        boolean showDay = op.getFacets().getb("showDay", false);
        int bigHourSize = showDay ? 2 : 5;
        boolean showHour = true;
        String range = null;
        boolean showSign = true;
        BRelTime minFacet = (BRelTime)op.getFacet("min");
        BRelTime maxFacet = (BRelTime)op.getFacet("max");
        long DAY = 86400000L;
        long HOUR = 3600000L;
        if (minFacet != null || maxFacet != null) {
            long a = minFacet == null ? Long.MIN_VALUE : minFacet.getMillis();
            long b = maxFacet == null ? Long.MAX_VALUE : maxFacet.getMillis();
            showSign = a < 0L && b > 0L;
            StringBuilder buf = new StringBuilder();
            buf.append(" [");
            buf.append(minFacet == null ? "-inf" : minFacet.toString());
            buf.append(" - ");
            buf.append(maxFacet == null ? "+inf" : maxFacet.toString());
            buf.append("]");
            range = buf.toString();
            if (Math.abs(a) < 3600000L && Math.abs(b) < 3600000L) {
                showHour = false;
            }
            if (Math.abs(a) < 86400000L && Math.abs(b) < 86400000L) {
                showDay = false;
            }
        }
        boolean neg = false;
        long t = value.getMillis();
        if (t < 0L) {
            neg = true;
            t = -t;
        }
        long MIN = 60000L;
        long SEC = 1000L;
        int day = (int)(t / 86400000L);
        int regHour = (int)(t % 86400000L / 3600000L);
        int bigHour = (int)(t / 3600000L);
        int min = (int)(t % 3600000L / 60000L);
        int sec = (int)(t % 3600000L % 60000L / 1000L);
        int millis = (int)(t % 3600000L % 60000L % 1000L);
        out.w((Object)"<span style='white-space:nowrap;'>");
        if (showSign) {
            out.w((Object)"<select ").attr("name", op.scope("sign"));
            out.w((Object)" ").attr("id", op.scope("sign"));
            if (readonly) {
                out.w((Object)" disabled='disabled'");
            }
            out.w((Object)">");
            out.w((Object)"<option ");
            out.attr("value", "negative");
            if (neg) {
                out.w((Object)" selected='selected'");
            }
            out.w((Object)">-</option>");
            out.w((Object)"<option ");
            out.attr("value", "positive");
            if (!neg) {
                out.w((Object)" selected='selected'");
            }
            out.w((Object)">+</option>");
            out.w((Object)"</select>");
        }
        if (showDay) {
            this.writeField("day", day, 3, op);
            out.w((Object)"&nbsp;d&nbsp;");
            this.writeField("bigHour", regHour, bigHourSize, op);
            out.w((Object)"&nbsp;h&nbsp;");
        } else if (showHour) {
            this.writeField("bigHour", bigHour, bigHourSize, op);
            out.w((Object)"&nbsp;h&nbsp;");
        }
        this.writeField("min", min, 2, op);
        if (showSec) {
            out.w((Object)"&nbsp;m&nbsp;");
            this.writeField("sec", sec, 2, op);
            if (showMillis) {
                out.w((Object)".");
                this.writeField("millis", millis, 3, op);
            }
            out.w((Object)"&nbsp;s");
        } else {
            out.w((Object)"&nbsp;m");
        }
        if (range != null) {
            out.safe((Object)range);
        }
        out.w((Object)"</span>");
    }

    @Override
    public void update(HxOp op) throws Exception {
        String quote = "\"";
        BRelTime value = (BRelTime)op.get();
        HtmlWriter out = op.getHtmlWriter();
        BBoolean z = (BBoolean)op.getFacet("showSeconds");
        boolean showSec = z == null ? true : z.getBoolean();
        z = (BBoolean)op.getFacet("showMilliseconds");
        boolean showMillis = z == null ? false : z.getBoolean();
        boolean showDay = op.getFacets().getb("showDay", false);
        int bigHourSize = showDay ? 2 : 5;
        boolean showHour = true;
        boolean showSign = true;
        BRelTime minFacet = (BRelTime)op.getFacet("min");
        BRelTime maxFacet = (BRelTime)op.getFacet("max");
        long DAY = 86400000L;
        long HOUR = 3600000L;
        if (minFacet != null || maxFacet != null) {
            long a = minFacet == null ? Long.MIN_VALUE : minFacet.getMillis();
            long b = maxFacet == null ? Long.MAX_VALUE : maxFacet.getMillis();
            boolean bl = showSign = a < 0L && b > 0L;
            if (Math.abs(a) < 3600000L && Math.abs(b) < 3600000L) {
                showHour = false;
            }
            if (Math.abs(a) < 86400000L && Math.abs(b) < 86400000L) {
                showDay = false;
            }
        }
        boolean neg = false;
        long t = value.getMillis();
        if (t < 0L) {
            neg = true;
            t = -t;
        }
        long MIN = 60000L;
        long SEC = 1000L;
        int day = (int)(t / 86400000L);
        int regHour = (int)(t % 86400000L / 3600000L);
        int bigHour = (int)(t / 3600000L);
        int min = (int)(t % 3600000L / 60000L);
        int sec = (int)(t % 3600000L % 60000L / 1000L);
        int millis = (int)(t % 3600000L % 60000L % 1000L);
        if (showSign) {
            this.setReadonly(op.scope("sign"), !op.canWrite(), op);
        }
        if (showDay) {
            this.setReadonly(op.scope("day"), !op.canWrite(), op);
        }
        if (showHour) {
            this.setReadonly(op.scope("bigHour"), !op.canWrite(), op);
        }
        this.setReadonly(op.scope("min"), !op.canWrite(), op);
        if (showSec) {
            this.setReadonly(op.scope("sec"), !op.canWrite(), op);
            if (showMillis) {
                this.setReadonly(op.scope("millis"), !op.canWrite(), op);
            }
        }
        if (!op.canWrite()) {
            if (showSign) {
                if (neg) {
                    out.w((Object)"document.getElementById(").w((Object)quote).w((Object)op.scope("sign")).w((Object)quote).w((Object)").value=").w((Object)quote).w((Object)"-").w((Object)quote).w((Object)";");
                } else {
                    out.w((Object)"document.getElementById(").w((Object)quote).w((Object)op.scope("sign")).w((Object)quote).w((Object)").value=").w((Object)quote).w((Object)"+").w((Object)quote).w((Object)";");
                }
            }
            if (showDay) {
                out.w((Object)"document.getElementById(").w((Object)quote).w((Object)op.scope("day")).w((Object)quote).w((Object)").value=").w((Object)quote).w((Object)"").w((Object)this.pad(day, 3)).w((Object)"").w((Object)quote).w((Object)";");
                out.w((Object)"document.getElementById(").w((Object)quote).w((Object)op.scope("bigHour")).w((Object)quote).w((Object)").value=").w((Object)quote).w((Object)"").w((Object)this.pad(regHour, bigHourSize)).w((Object)"").w((Object)quote).w((Object)";");
            } else if (showHour) {
                out.w((Object)"document.getElementById(").w((Object)quote).w((Object)op.scope("bigHour")).w((Object)quote).w((Object)").value=").w((Object)quote).w((Object)"").w((Object)this.pad(bigHour, bigHourSize)).w((Object)"").w((Object)quote).w((Object)";");
            }
            out.w((Object)"document.getElementById(").w((Object)quote).w((Object)op.scope("min")).w((Object)quote).w((Object)").value=").w((Object)quote).w((Object)"").w((Object)this.pad(min, 2)).w((Object)"").w((Object)quote).w((Object)";");
            if (showSec) {
                out.w((Object)"document.getElementById(").w((Object)quote).w((Object)op.scope("sec")).w((Object)quote).w((Object)").value=").w((Object)quote).w((Object)"").w((Object)this.pad(sec, 2)).w((Object)"").w((Object)quote).w((Object)";");
                if (showMillis) {
                    out.w((Object)"document.getElementById(").w((Object)quote).w((Object)op.scope("millis")).w((Object)quote).w((Object)").value=").w((Object)quote).w((Object)"").w((Object)this.pad(millis, 3)).w((Object)"").w((Object)quote).w((Object)";");
                }
            }
        }
    }

    private void setReadonly(String path, boolean readonly, HxOp op) throws IOException {
        HtmlWriter out = op.getHtmlWriter();
        String quote = "\"";
        out.w((Object)"var field; field = document.getElementById(").w((Object)quote).w((Object)path).w((Object)quote).w((Object)");");
        out.w((Object)"if (field != null && field.setAttribute != null) {");
        if (readonly) {
            out.w((Object)"if(field.type == ").w((Object)quote).w((Object)"text").w((Object)quote).w((Object)")");
            out.w((Object)"field.setAttribute(").w((Object)quote).w((Object)"readOnly").w((Object)quote).w((Object)",").w((Object)quote).w((Object)"readOnly").w((Object)quote).w((Object)"); ");
            out.w((Object)" else ");
            out.w((Object)"field.setAttribute(").w((Object)quote).w((Object)"disabled").w((Object)quote).w((Object)",").w((Object)quote).w((Object)"disabled").w((Object)quote).w((Object)");");
        } else {
            out.w((Object)"if(field.type == ").w((Object)quote).w((Object)"text").w((Object)quote).w((Object)")");
            out.w((Object)"field.removeAttribute(").w((Object)quote).w((Object)"readOnly").w((Object)quote).w((Object)"); ");
            out.w((Object)" else ");
            out.w((Object)"field.removeAttribute(").w((Object)quote).w((Object)"disabled").w((Object)quote).w((Object)");");
        }
        out.w((Object)"}");
    }

    @Override
    public BObject save(HxOp op) throws Exception {
        BRelTime old = (BRelTime)op.get();
        if (!op.canWrite()) {
            return old;
        }
        boolean sign = old.getMillis() >= 0L;
        String v = op.getFormValue("sign");
        String s = op.getFormValue("sec");
        String m = op.getFormValue("millis");
        String h = op.getFormValue("bigHour");
        String d = op.getFormValue("day");
        int day = 0;
        int bigHour = 0;
        long t = 0L;
        if (v != null) {
            sign = v.equals("positive");
        }
        if (h != null) {
            bigHour = Integer.parseInt(h);
        }
        if (d != null) {
            day = Integer.parseInt(d);
        }
        int min = Integer.parseInt(op.getFormValue("min"));
        int sec = s == null ? 0 : Integer.parseInt(s);
        int millis = m == null ? 0 : Integer.parseInt(m);
        t += (long)day * 86400000L;
        t += (long)bigHour * 3600000L;
        t += (long)min * 60000L;
        t += (long)sec * 1000L;
        t += (long)millis;
        if (!sign) {
            t = -t;
        }
        BRelTime minf = (BRelTime)op.getFacet("min");
        BRelTime maxf = (BRelTime)op.getFacet("max");
        if (minf != null && t < minf.getMillis()) {
            throw new CannotSaveException(BRelTime.make((long)t) + " < " + minf);
        }
        if (maxf != null && t > maxf.getMillis()) {
            throw new CannotSaveException(BRelTime.make((long)t) + " > " + maxf);
        }
        return BRelTime.make((long)t);
    }

    private void writeField(String name, int value, int size, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        boolean readonly = !op.canWrite();
        out.w((Object)"<input ").attr("name", op.scope(name)).w((Object)" ").attr("id", op.scope(name));
        if (readonly) {
            out.write(" readOnly='readOnly'");
        }
        out.w((Object)" ").attr("type", "text");
        out.w((Object)" ").attr("size", Integer.toString(size));
        out.w((Object)" ").attr("value", this.pad(value, size));
        out.w((Object)"/>");
    }

    private String pad(int value, int size) {
        String s = Integer.toString(value);
        while (s.length() < size) {
            s = "0" + s;
        }
        return s;
    }
}

