/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx.gx;

import com.tridium.hx.gx.HtmlAbstractPainter;
import com.tridium.hx.gx.UxShapeUtil;
import java.util.ArrayList;
import java.util.List;
import javax.baja.gx.BBrush;
import javax.baja.gx.BPen;
import javax.baja.gx.Point;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;

public class HtmlSvgPainter
extends HtmlAbstractPainter {
    private final HtmlWriter out;
    private final boolean fill;
    private final UxShapeUtil.RotateInfo rotateInfo;
    private boolean closed = false;

    public HtmlSvgPainter(HtmlWriter out, boolean fill, UxShapeUtil.RotateInfo rotateInfo) {
        this.out = out;
        this.fill = fill;
        this.rotateInfo = rotateInfo;
    }

    public void arcTo(double x, double y, double rx, double ry, double angleDegrees, boolean largeArcFlag, boolean sweepFlag) {
        this.out.w((Object)("s.p+='A" + rx + ' ' + ry + ' ' + angleDegrees + ' ' + HtmlSvgPainter.flag(largeArcFlag) + ' ' + HtmlSvgPainter.flag(sweepFlag) + ' ' + x + ' ' + y + "';"));
    }

    private static char flag(boolean flag) {
        return flag ? (char)'1' : '0';
    }

    public void beginPath() {
    }

    public void bezierCurveTo(double x, double y, double x1, double y1, double x2, double y2) {
        this.out.w((Object)("s.p+='C" + x1 + ' ' + y1 + ' ' + x2 + ' ' + y2 + ' ' + x + ' ' + y + "';"));
    }

    public void closePath() {
        this.out.w((Object)"s.p+='Z';");
        this.closed = true;
    }

    public void finish() {
        if (this.getLastPoint() != null || this.closed) {
            this.out.w((Object)"var elem = s.g.append('path')");
            this.out.w((Object)".attr('d', s.p)");
            this.addStyle(this.rotateInfo);
            this.out.w((Object)";");
            this.out.w((Object)"s.p='';");
        }
    }

    public void lineTo(double x, double y) {
        this.out.w((Object)("s.p+='L" + x + " " + y + "'; "));
    }

    public void moveTo(double x, double y) {
        this.out.w((Object)("s.p+='M" + x + " " + y + "'; "));
    }

    public void quadraticCurveTo(double x, double y, double x1, double y1) {
        this.out.w((Object)("s.p+='Q" + x1 + ' ' + y1 + ' ' + x + ' ' + y + "';"));
    }

    @Override
    public void ellipse(double centerX, double centerY, double rx, double ry, double angleDegrees) {
        this.push();
        this.rotate(angleDegrees);
        this.out.w((Object)"var elem = s.g.append('ellipse')");
        this.out.w((Object)(".attr('cx', '" + centerX + "')"));
        this.out.w((Object)(".attr('cy', '" + centerY + "')"));
        this.out.w((Object)(".attr('rx', '" + rx + "')"));
        this.out.w((Object)(".attr('ry', '" + ry + "')"));
        this.addStyle();
        this.out.w((Object)";");
        this.pop();
    }

    public void line(double x1, double y1, double x2, double y2, BPen pen, BBrush brush) {
        boolean crisp;
        BBrush.Paint paint = brush.getPaint();
        boolean isGradient = paint instanceof BBrush.Gradient;
        boolean horizontal = y1 == y2;
        boolean vertical = x1 == x2;
        boolean flat = horizontal || vertical;
        boolean simplePen = pen.getDash().length == 0 && pen.getCap() != 103;
        boolean bl = crisp = flat && simplePen && !isGradient;
        if (this.rotateInfo != null) {
            List<Point> points = this.rotateInfo.getRotatedPoints();
            x1 = points.get(0).x();
            y1 = points.get(0).y();
            x2 = points.get(1).x();
            y2 = points.get(1).y();
        }
        this.out.w((Object)"var elem = s.g.append('line')");
        this.out.w((Object)(".attr('x1', '" + x1 + "')"));
        this.out.w((Object)(".attr('y1', '" + y1 + "')"));
        this.out.w((Object)(".attr('x2', '" + x2 + "')"));
        this.out.w((Object)(".attr('y2', '" + y2 + "')"));
        if (crisp) {
            this.out.w((Object)".classed('hxpx-crisp', true)");
        }
        this.addStyle(this.rotateInfo);
        this.out.w((Object)";");
    }

    public void rect(double x, double y, double width, double height, BBrush brush) {
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(new Point(x, y));
        points.add(new Point(x, y + height));
        points.add(new Point(x + width, y + height));
        points.add(new Point(x + width, y));
        if (this.rotateInfo != null) {
            points = this.rotateInfo.getRotatedPoints();
        }
        this.out.w((Object)"var elem = s.g.append('polygon')");
        this.out.w((Object)(".attr('points', '" + UxShapeUtil.pointsToString(points) + "')"));
        this.addStyle(this.rotateInfo);
        this.out.w((Object)";");
    }

    public void text(String str, double x, double y, double tx, double ty, double fontAscent) {
        this.out.w((Object)"s.g.append('text')");
        this.out.w((Object)(".attr('x', " + x + ')'));
        this.out.w((Object)(".attr('y', " + y + ')'));
        this.out.w((Object)".style('font', s.font)");
        this.addStyle(true);
        this.out.w((Object)(".text(\"" + HxUtil.escapeJsStringLiteral(str) + "\");"));
    }

    private void addStyle() {
        this.addStyle(this.fill, null);
    }

    private void addStyle(UxShapeUtil.RotateInfo rotateInfo) {
        this.addStyle(this.fill, rotateInfo);
    }

    private void addStyle(boolean fill) {
        this.addStyle(fill, null);
    }

    private void addStyle(boolean fill, UxShapeUtil.RotateInfo rotateInfo) {
        if (rotateInfo == null) {
            this.out.w((Object)(".each(function(){ px.styleSvg(this, s, " + fill + "); })"));
        } else {
            this.out.w((Object)(".each(function(){ px.styleSvg(this, s, " + fill + ", '" + rotateInfo.getGroupTransform() + "'); })"));
        }
    }

    @Override
    public void push() {
        this.out.w((Object)"var c = JSON.parse(JSON.stringify(s));");
        this.out.w((Object)"c.g = s.g;");
        this.out.w((Object)"s.g = s.g.append('g');");
        this.out.w((Object)"q.push(c);");
    }

    @Override
    public void pop() {
        this.out.w((Object)"s = q.pop();");
    }

    @Override
    public void rotate(double angleDegrees) {
        if (angleDegrees == 0.0) {
            return;
        }
        this.out.w((Object)"s.g = s.g.append('g')");
        this.out.w((Object)(".attr('transform', 'rotate(" + angleDegrees + ")');"));
    }

    @Override
    public void scale(double scaleX, double scaleY) {
        if (scaleX == 1.0 && scaleY == 1.0) {
            return;
        }
        this.out.w((Object)"s.g = s.g.append('g')");
        this.out.w((Object)(".attr('transform', 'scale(" + scaleX + ',' + scaleY + ")');"));
    }

    @Override
    public void translate(double x, double y) {
        if (x == 0.0 && y == 0.0) {
            return;
        }
        this.out.w((Object)"s.g = s.g.append('g')");
        this.out.w((Object)(".attr('transform', 'translate(" + x + ',' + y + ")');"));
    }
}

