/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx.px.ux;

import com.tridium.hx.px.ux.UxLabelUtil;
import javax.baja.gx.BBrush;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.hx.PropertiesCollection;
import javax.baja.io.HtmlWriter;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.enums.BHalign;

public final class UxRadioButtonUtil {
    private UxRadioButtonUtil() {
    }

    public static void write(String inputType, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<span ").attr("id", op.scope("toggleButton-col")).attr(" class", "-t-ToggleButton-col").w((Object)">");
        out.w((Object)"<input ").attr("id", op.scope("value")).attr(" class", "-t-ToggleButton-input").attr(" type", inputType).w((Object)"/>");
        out.w((Object)"<span ").attr("id", op.scope("labelRoot")).w((Object)">");
        UxLabelUtil.write(op);
        out.w((Object)"</span>");
        out.w((Object)"</input>");
        out.w((Object)"</span>");
    }

    public static void update(int width, int height, boolean enabled, String uxClassName, HxOp op) throws Exception {
        PropertiesCollection.Properties properties = new PropertiesCollection.Properties();
        PropertiesCollection.Styles rootStyle = new PropertiesCollection.Styles();
        PropertiesCollection.Properties spanProperties = new PropertiesCollection.Properties();
        PropertiesCollection.Styles spanStyle = new PropertiesCollection.Styles();
        PropertiesCollection.Properties inputProperties = new PropertiesCollection.Properties();
        BToggleButton button = (BToggleButton)op.get();
        String buttonTag = button.getButtonStyle().getTag();
        properties.append("className", "ux-Button-buttonStyle-" + buttonTag);
        properties.append("className", uxClassName);
        properties.append("className", "ux-ToggleButton");
        spanProperties.append("className", "-t-ToggleButton-col");
        BHalign halign = button.getHalign();
        if (halign.getTag() != "left") {
            spanProperties.append("className", "-t-ToggleButton-col-stretch");
        }
        if (!enabled) {
            properties.append("className", "bajaux-disabled");
        }
        inputProperties.add("disabled", enabled ? "" : "disabled");
        inputProperties.add("checked", button.isSelected() ? "checked" : "");
        boolean nullBackground = "hyperlink".equals(buttonTag) || "none".equals(buttonTag);
        BBrush background = button.getBackground();
        if (nullBackground) {
            background = BBrush.NULL;
        }
        HxUtil.makeBackground(background, null, rootStyle, op);
        properties.write(op);
        rootStyle.write(op);
        inputProperties.write(op.scope("value"), op);
        spanProperties.write(op.scope("toggleButton-col"), op);
        ((PropertiesCollection)spanStyle).write(op.scope("toggleButton-col"), op);
        UxLabelUtil.update(width, height, op.scope("labelRoot"), false, op);
    }
}

