/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx.util;

import com.tridium.nre.diagnostics.DiagnosticUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.hx.Command;
import javax.baja.hx.HxOp;

public class BenchmarkCommand
extends Command {
    public static final Logger LOAD_TIME_LOG = Logger.getLogger("diagnostics.hx.loadTime");

    public BenchmarkCommand() {
        super(null);
    }

    @Override
    public String getInvokeCode(HxOp op) {
        StringBuilder b = new StringBuilder();
        b.append("hx.loadTime(\"").append(this.getId()).append("\");");
        return b.toString();
    }

    @Override
    public void handle(HxOp op) throws Exception {
        String loadTime = op.getFormValue("loadTime");
        if (LOAD_TIME_LOG.isLoggable(Level.FINER)) {
            LOAD_TIME_LOG.finer(loadTime + "ms " + op.getOrd());
        }
        DiagnosticUtil.completeDuration((long)(Long.parseLong(loadTime) * 1000000L), (String)"hx.loadTime", (Object)("" + op.getOrd()));
    }

    public static boolean isActive() {
        return LOAD_TIME_LOG.isLoggable(Level.FINE);
    }
}

