/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.hx;

import com.tridium.hx.HxHyperlinkInfo;
import com.tridium.web.WebProcessException;
import com.tridium.web.WebUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.hx.BHxProfile;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.session.INiagaraSuperSession;
import javax.baja.session.SessionUtil;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BServletView;
import javax.baja.web.WebOp;
import javax.baja.web.hx.BIHxProfile;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.EofException;
import org.owasp.encoder.Encode;

@NiagaraType
public abstract class BHxView
extends BServletView {
    @Generated
    public static final Type TYPE = Sys.loadType(BHxView.class);
    private int eventCounter = 0;
    protected HashMap<String, Event> events = new HashMap();
    private static final String UTF_8 = StandardCharsets.UTF_8.name();
    public static final Logger log = Logger.getLogger("hx");

    @Generated
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(WebOp c) throws Exception {
        BHxProfile profile = (BHxProfile)c.getProfileConfig((Context)BIHxProfile.PREFER_HX_FACETS).make();
        HxOp op = profile.createOp(c);
        op.setProfile(profile);
        try {
            op.getResponse().setHeader("transfer-encoding", "chunked");
            op.getResponse().setHeader("Cache-Control", "no-cache, no-store");
            BHxView view = HxHyperlinkInfo.getView(this, op);
            profile.writeDocument(view, op);
        }
        catch (WebProcessException wpe) {
            log.log(Level.SEVERE, "Unable to process request.", wpe);
            WebUtil.sendSafeErrorToUser((HttpServletResponse)c.getResponse(), (int)wpe.code, (Throwable)wpe, (Context)op);
        }
        catch (Exception err) {
            log.log(Level.SEVERE, "Unable to process request.", err);
            op.sendError(err);
        }
        finally {
            profile.destroyOp(op);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(WebOp c) throws Exception {
        block18: {
            String self = WebUtil.getRedirect((HttpServletRequest)c.getRequest(), (String)c.getRequest().getRequestURI());
            String query = c.getRequest().getQueryString();
            if (query != null) {
                self = self + "?" + query;
            }
            BHxProfile profile = (BHxProfile)c.getProfileConfig((Context)BIHxProfile.PREFER_HX_FACETS).make();
            HxOp op = profile.createOp(c);
            op.setProfile(profile);
            boolean processException = false;
            try {
                String header;
                INiagaraSuperSession session = SessionUtil.getCurrentNiagaraSuperSession();
                String csrfToken = op.getFormValue("csrfToken");
                if (csrfToken == null && (header = op.getRequest().getHeader("x-niagara-csrfToken")) != null) {
                    csrfToken = HxUtil.decode(header);
                }
                session.verifyCsrfToken(csrfToken);
                BHxView view = HxHyperlinkInfo.getView(this, op);
                if (op.isFormPost()) {
                    profile.saveDocument(view, op);
                    String url = op.getRedirect();
                    if (url == null) {
                        url = self;
                    }
                    op.getResponse().sendRedirect(url);
                    break block18;
                }
                if (op.isUpdate()) {
                    PrintWriter out = c.getResponse().getWriter();
                    profile.updateDocument(view, op);
                    String content = op.getContent().toString();
                    op.getResponse().setContentType("text/javascript");
                    op.getResponse().setContentLength(content.getBytes(UTF_8).length);
                    out.print(content);
                    break block18;
                }
                boolean processResult = false;
                try {
                    processResult = profile.processDocument(view, op);
                }
                catch (Exception e) {
                    if (e instanceof EofException && e.getCause() instanceof IOException && ("Broken pipe".equals(e.getCause().getMessage()) || "An existing connection was forcibly closed by the remote host".equals(e.getCause().getMessage()))) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.WARNING, "Unable to process request. Client disconnected.", e);
                        } else {
                            log.log(Level.WARNING, "Unable to process request. Client disconnected.");
                        }
                        processResult = true;
                    }
                    processException = true;
                    if (!op.getResponse().isCommitted()) {
                        op.getResponse().reset();
                        PrintWriter out = op.getResponse().getWriter();
                        out.print("window.location.reload(true);");
                    }
                    throw e;
                }
                if (!processResult) {
                    StringBuilder error = new StringBuilder();
                    error.append(op.getRequest().getHeader("x-niagara-hx-path"));
                    error.append(".").append(op.getRequest().getHeader("x-niagara-hx-eventId"));
                    WebUtil.sendSafeErrorToUser((HttpServletResponse)op.getResponse(), (int)404, (String)error.toString());
                }
            }
            catch (Exception err) {
                profile.setError(err, op);
                log.log(Level.SEVERE, "Unable to process request.", err);
                if (!processException) {
                    op.getResponse().sendRedirect(self);
                }
            }
            finally {
                op.deleteTempFiles();
                profile.destroyOp(op);
            }
        }
    }

    public String getPageTitle(HxOp op) throws Exception {
        if (op.get() instanceof BINavNode) {
            return Encode.forHtml((String)((BINavNode)op.get()).getNavDisplayName((Context)op));
        }
        return "";
    }

    public void write(HxOp op) throws Exception {
    }

    public void update(HxOp op) throws Exception {
    }

    public boolean process(HxOp op) throws Exception {
        String contentType = op.getRequest().getContentType();
        if (contentType.startsWith("application/x-niagara-hx-event")) {
            String path = op.getRequest().getHeader("x-niagara-hx-path");
            if (path.equals("*")) {
                path = "";
            }
            if (path.equals(op.getPath())) {
                String eventId = op.getRequest().getHeader("x-niagara-hx-eventId");
                Event event = null;
                if (path.length() == 0) {
                    event = op.getProfile().events.get(eventId);
                }
                if (event == null) {
                    event = this.events.get(eventId);
                }
                if (event != null) {
                    op.decodeFormValues();
                    event.handle(op);
                    byte[] bytes = op.getContent().toString().getBytes(UTF_8);
                    op.getResponse().setContentLength(bytes.length);
                    op.getResponse().getOutputStream().write(bytes, 0, bytes.length);
                    return true;
                }
            }
        }
        return false;
    }

    public BObject save(HxOp op) throws Exception {
        return op.get();
    }

    public void registerEvent(Event event) {
        this.registerEvent(event, "event" + this.eventCounter++);
    }

    public boolean isEventRegistered(Event event) {
        return this.events.containsValue(event);
    }

    public void registerEvent(Event event, String id) {
        event.setId(id);
        this.events.put(event.getId(), event);
    }
}

