/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.hx.table.view;

import com.tridium.web.WebUtil;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.hx.table.TableRenderer;
import javax.baja.hx.table.view.TableViewModel;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.servlet.http.HttpServletRequest;

public class TableViewRenderer
extends TableRenderer {
    @Override
    public void writeHeader(int col, HxOp op) throws Exception {
        if (col == 0) {
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"<td class='tableHeader' style='padding:2px;'>");
            out.w((Object)"<input type='checkbox' onclick='tableView.selectAll(event);'/>");
            out.w((Object)"</td>");
        }
        super.writeHeader(col, op);
    }

    @Override
    public void writeGroup(int group, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<td");
        out.attr(" colspan", this.getModel().getColumnCount() + 1);
        out.attr(" class", "tableGroup").w((Object)">");
        out.safe((Object)this.getModel().getGroupName(group, op));
        out.w((Object)"</td>");
    }

    @Override
    public void writeCell(int group, int row, int col, HxOp op) throws Exception {
        TableViewModel model = (TableViewModel)this.getModel();
        if (col == 0) {
            Object val = model.getValueAt(group, row, col, op);
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"<td class='tableCell tableVgrid tableHgrid'");
            out.w((Object)" style='margin:0; padding:2px;'>");
            out.w((Object)"<input type='checkbox' name='").w((Object)op.scope("_r" + row));
            out.w((Object)"' value='").w((Object)model.toRowId(group, row, op)).w((Object)"'/>");
            out.w((Object)"</td>");
        }
        super.writeCell(group, row, col, op);
    }

    @Override
    public void writeCellValue(Object value, int group, int row, int col, HxOp op) throws Exception {
        TableViewModel model = (TableViewModel)this.getModel();
        String text = String.valueOf(value);
        BOrd ord = model.getOrd(group, row, col, op);
        HtmlWriter out = op.getHtmlWriter();
        if (!ord.isNull()) {
            out.w((Object)"<a href='").w((Object)HxUtil.encodeURLForHref(WebUtil.toUri((OrdTarget)op, (HttpServletRequest)op.getRequest(), (BOrd)ord))).w((Object)"'>");
        }
        if (text != null && text.length() == 0) {
            out.w((Object)"&nbsp;");
        } else {
            out.safe((Object)text);
        }
        if (!ord.isNull()) {
            out.w((Object)"</a>");
        }
    }
}

