/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.hx.tree;

import java.util.ArrayList;
import javax.baja.gx.BImage;
import javax.baja.hx.tree.TreeModel;
import javax.baja.naming.BOrd;
import javax.baja.sys.Context;

public abstract class TreeNode {
    private TreeModel model;
    private TreeNode parent;

    public TreeNode(TreeModel model, TreeNode parent) {
        this.model = model;
        this.parent = parent;
    }

    public TreeNode(TreeModel model) {
        this.model = model;
    }

    public TreeNode(TreeNode parent) {
        this.parent = parent;
    }

    public abstract String getText(Context var1);

    public abstract BImage getIcon();

    public abstract BOrd getHyperlink();

    public abstract int getChildCount();

    public abstract TreeNode getChild(int var1);

    public boolean isLeaf() {
        return !this.hasChildren();
    }

    public boolean hasChildren() {
        return this.getChildCount() != 0;
    }

    public int getChildIndex(TreeNode child) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            if (this.getChild(i) != child) continue;
            return i;
        }
        return -1;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean isDescendantOf(TreeNode ancestor) {
        TreeNode parent;
        for (parent = this.getParent(); parent != null && parent != ancestor; parent = parent.getParent()) {
        }
        return parent == ancestor;
    }

    public TreeNode[] getPathFromRoot() {
        ArrayList<TreeNode> temp = new ArrayList<TreeNode>(4);
        temp.add(this);
        for (TreeNode parent = this.getParent(); parent != null; parent = parent.getParent()) {
            temp.add(parent);
        }
        int count = temp.size();
        TreeNode[] path = new TreeNode[count];
        for (int i = 0; i < count; ++i) {
            path[i] = (TreeNode)temp.get(count - i - 1);
        }
        return path;
    }
}

