/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListRenderer;

@NiagaraType
public class BListDropDownDisplay
extends BWidget {
    @Generated
    public static final Type TYPE = Sys.loadType(BListDropDownDisplay.class);
    private ListRenderer.Item item = new ListRenderer.Item();
    boolean isFocusTraversable = true;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BList getList() {
        BListDropDown parent = (BListDropDown)this.getParent();
        if (parent != null) {
            return parent.getList();
        }
        return null;
    }

    public void openDropDown() {
        BListDropDown parent = (BListDropDown)this.getParent();
        if (parent != null) {
            parent.openDropDown();
        }
    }

    @Override
    public void computePreferredSize() {
        BList list = this.getList();
        if (list == null) {
            return;
        }
        list.computePreferredSize();
        this.setPreferredSize(list.getPreferredWidth() + 2.0, list.getRenderer().getItemHeight() - 2.0);
    }

    @Override
    public void doLayout(BWidget[] kids) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        BListDropDown parent = (BListDropDown)this.getParent();
        BList list = this.getList();
        if (list == null) {
            return;
        }
        double w = this.getWidth();
        double h = this.getHeight();
        if (parent.isEnabled() && parent.getDropDownEnabled()) {
            Theme.dropDown().paintBackground(g, this);
        } else {
            g.setBrush(Theme.dropDown().getControlBackground(this));
            g.fillRect(0.0, 0.0, w, h);
        }
        g.push();
        try {
            g.translate(-2.0, 0.0);
            if (parent.isDropDownOpen()) {
                if (this.item.value != null) {
                    list.getRenderer().paintItem(g, this.item);
                }
            } else {
                int index = list.getSelectedIndex();
                if (index != -1 && list.getItemCount() > 0) {
                    this.item.index = index;
                    this.item.icon = list.getModel().getItemIcon(index);
                    this.item.value = list.getModel().getItem(index);
                    this.item.width = w - 2.0;
                    this.item.height = h;
                    list.getRenderer().paintItem(g, this.item);
                }
            }
        }
        finally {
            g.pop();
        }
    }

    @Override
    public String getStyleSelector() {
        return "drop-down";
    }

    @Override
    public boolean isFocusTraversable() {
        return this.isFocusTraversable;
    }

    public void setFocusTraversable(boolean isFocusTraversable) {
        this.isFocusTraversable = isFocusTraversable;
    }

    @Override
    public void mousePressed(BMouseEvent event) {
        this.requestFocus();
        this.repaint();
        this.openDropDown();
    }

    @Override
    public void keyPressed(BKeyEvent event) {
        if (event.getModifiersEx() != 0 && event.getModifiersEx() != 64) {
            return;
        }
        BListDropDown parent = (BListDropDown)this.getParent();
        if (event.getKeyCode() == 10) {
            parent.fireActionPerformed(new BWidgetEvent(2, parent));
        } else if (event.getKeyCode() == 40) {
            event.consume();
            parent.openDropDown();
        } else {
            int key = event.getKeyCode();
            if (48 <= key && key <= 57 || 65 <= key && key <= 90) {
                parent.openDropDown();
                parent.getList().keyPressed(event);
            }
        }
    }
}

