/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui;

import com.tridium.gx.util.ColorUtil;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BEllipseGeom;
import javax.baja.gx.BGeom;
import javax.baja.gx.BPathGeom;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.gx.IPathGeom;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLayout;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BCanvasPane;
import javax.baja.ui.px.BPxInclude;
import javax.baja.ui.shape.BEllipse;
import javax.baja.ui.shape.BPath;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="fill", type="BColor", defaultValue="BColor.NULL"), @NiagaraProperty(name="rotation", type="int", defaultValue="0"), @NiagaraProperty(name="flip", type="boolean", defaultValue="false"), @NiagaraProperty(name="mirror", type="boolean", defaultValue="false")})
public class BNPxInclude
extends BPxInclude {
    @Generated
    public static final Property fill = BNPxInclude.newProperty((int)0, (BValue)BColor.NULL, null);
    @Generated
    public static final Property rotation = BNPxInclude.newProperty((int)0, (int)0, null);
    @Generated
    public static final Property flip = BNPxInclude.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property mirror = BNPxInclude.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNPxInclude.class);
    BColor lastFill;
    boolean lastFlip;
    boolean lastMirror;
    int lastRotation;
    boolean firstTime = true;

    @Generated
    public BColor getFill() {
        return (BColor)this.get(fill);
    }

    @Generated
    public void setFill(BColor v) {
        this.set(fill, (BValue)v, null);
    }

    @Generated
    public int getRotation() {
        return this.getInt(rotation);
    }

    @Generated
    public void setRotation(int v) {
        this.setInt(rotation, v, null);
    }

    @Generated
    public boolean getFlip() {
        return this.getBoolean(flip);
    }

    @Generated
    public void setFlip(boolean v) {
        this.setBoolean(flip, v, null);
    }

    @Generated
    public boolean getMirror() {
        return this.getBoolean(mirror);
    }

    @Generated
    public void setMirror(boolean v) {
        this.setBoolean(mirror, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void computePreferredSize() {
        super.computePreferredSize();
        if (!this.isLoaded()) {
            return;
        }
        int r = this.getNormalizedRotation();
        if (r == 90 || r == 270) {
            this.setPreferredSize(this.getPreferredHeight(), this.getPreferredWidth());
        }
    }

    @Override
    public void doLayout(BWidget[] kids) {
        if (!this.isLoaded()) {
            super.doLayout(kids);
            return;
        }
        if (this.getRootWidget() == null) {
            return;
        }
        if (this.lastFill != this.getFill()) {
            this.colorize();
        }
        if (this.lastFlip != this.getFlip()) {
            this.flip();
        }
        if (this.lastMirror != this.getMirror()) {
            this.mirror();
        }
        if (this.lastRotation != this.getRotation()) {
            this.rotate();
        }
        super.doLayout(kids);
        int r = this.getRotation();
        if (r == 90 || r == 270) {
            this.getRootWidget().setBounds(0.0, 0.0, this.getHeight(), this.getWidth());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        if (this.firstTime) {
            this.firstTime = false;
            this.relayout();
            return;
        }
        g.push();
        try {
            int r = this.getNormalizedRotation();
            double w = this.getWidth();
            double h = this.getHeight();
            if (r != 0) {
                switch (r) {
                    case 90: {
                        g.translate(w, 0.0);
                        break;
                    }
                    case 180: {
                        g.translate(w, h);
                        break;
                    }
                    case 270: {
                        g.translate(0.0, h);
                        break;
                    }
                    default: {
                        r = 0;
                    }
                }
                g.transform(BTransform.makeRotate((double)r));
            }
            super.paint(g);
        }
        finally {
            g.pop();
        }
    }

    private int getNormalizedRotation() {
        int r = this.getRotation();
        if (r < 0) {
            r = 360 + r;
        }
        if (r > 360) {
            r -= 360;
        }
        return r;
    }

    public void colorize() {
        BWidget root = this.getRootWidget();
        if (root != null) {
            if (this.getFill().isNull()) {
                if (this.lastFill != null) {
                    this.reload();
                }
            } else {
                this.colorize(root);
            }
            this.lastFill = this.getFill();
        }
    }

    private void colorize(BWidget w) {
        if (!w.getType().is(BCanvasPane.TYPE)) {
            SlotCursor c = w.getProperties();
            while (c.next()) {
                Property p = c.property();
                Type pt = p.getType();
                if (pt.is(BBrush.TYPE)) {
                    w.set(p, (BValue)this.toFill((BBrush)w.get(p)));
                    continue;
                }
                if (!pt.is(BColor.TYPE)) continue;
                w.set(p, (BValue)this.toFill((BColor)w.get(p)));
            }
        }
        BWidget[] kids = w.getChildWidgets();
        for (int i = 0; i < kids.length; ++i) {
            this.colorize(kids[i]);
        }
    }

    private BBrush toFill(BBrush b) {
        BColor c = b.getPaint() instanceof BBrush.Solid ? ((BBrush.Solid)b.getPaint()).getColor() : BColor.make((String)"#888");
        return this.toFill(c).toBrush();
    }

    private BColor toFill(BColor c) {
        if (c.isNull()) {
            return c;
        }
        double[] fhsb = ColorUtil.toHsb((BColor)this.getFill());
        double[] thsb = ColorUtil.toHsb((BColor)c);
        thsb[0] = fhsb[0];
        thsb[1] = fhsb[1];
        return ColorUtil.toRgb((double[])thsb);
    }

    private void flip() {
        BWidget root = this.getRootWidget();
        if (root != null && root instanceof BCanvasPane) {
            BCanvasPane c = (BCanvasPane)root;
            this.flip(root, c.getViewSize().height);
            this.lastFlip = this.getFlip();
        }
    }

    private void flip(BWidget w, double h) {
        if (w instanceof BPath) {
            BPath p = (BPath)w;
            BPathGeom g = (BPathGeom)p.getShapeGeom();
            IPathGeom.Segment[] s = g.segments();
            for (int i = 0; i < s.length; ++i) {
                double y;
                double x;
                IPathGeom.Segment seg = s[i];
                if (seg instanceof IPathGeom.MoveTo) {
                    if (!seg.isAbsolute()) {
                        throw new RuntimeException("rel MoveTo not supported");
                    }
                    x = ((IPathGeom.MoveTo)seg).getX();
                    y = ((IPathGeom.MoveTo)seg).getY();
                    s[i] = new IPathGeom.MoveTo(true, x, h - y);
                    continue;
                }
                if (seg instanceof IPathGeom.LineTo) {
                    if (seg.isAbsolute()) {
                        throw new RuntimeException("abs LineTo not supported");
                    }
                    x = ((IPathGeom.LineTo)seg).getX();
                    y = ((IPathGeom.LineTo)seg).getY();
                    s[i] = new IPathGeom.LineTo(false, x, -y);
                    continue;
                }
                if (seg instanceof IPathGeom.ClosePath) continue;
                throw new RuntimeException("not supported: " + seg);
            }
            p.setShapeGeom((BGeom)BPathGeom.make((IPathGeom.Segment[])s));
        } else if (w instanceof BEllipse) {
            BEllipse e = (BEllipse)w;
            BEllipseGeom g = e.getGeom();
            double ex = g.x();
            double ey = g.y();
            double ew = g.width();
            double eh = g.height();
            e.setGeom(BEllipseGeom.make((double)ex, (double)(h - ey - eh), (double)ew, (double)eh));
        } else {
            BWidget[] kids = w.getChildWidgets();
            for (int i = 0; i < kids.length; ++i) {
                this.flip(kids[i], h);
            }
        }
    }

    private void mirror() {
        BWidget root = this.getRootWidget();
        if (root != null && root instanceof BCanvasPane) {
            BCanvasPane c = (BCanvasPane)root;
            this.mirror(root, c.getViewSize().width);
            this.lastMirror = this.getMirror();
        }
    }

    private void mirror(BWidget w, double width) {
        if (w instanceof BPath) {
            BPath p = (BPath)w;
            BPathGeom g = (BPathGeom)p.getShapeGeom();
            IPathGeom.Segment[] s = g.segments();
            for (int i = 0; i < s.length; ++i) {
                double y;
                double x;
                IPathGeom.Segment seg = s[i];
                if (seg instanceof IPathGeom.MoveTo) {
                    if (!seg.isAbsolute()) {
                        throw new RuntimeException("rel MoveTo not supported");
                    }
                    x = ((IPathGeom.MoveTo)seg).getX();
                    y = ((IPathGeom.MoveTo)seg).getY();
                    s[i] = new IPathGeom.MoveTo(true, width - x, y);
                    continue;
                }
                if (seg instanceof IPathGeom.LineTo) {
                    if (seg.isAbsolute()) {
                        throw new RuntimeException("abs LineTo not supported");
                    }
                    x = ((IPathGeom.LineTo)seg).getX();
                    y = ((IPathGeom.LineTo)seg).getY();
                    s[i] = new IPathGeom.LineTo(false, -x, y);
                    continue;
                }
                if (seg instanceof IPathGeom.ClosePath) continue;
                throw new RuntimeException("not supported: " + seg);
            }
            p.setShapeGeom((BGeom)BPathGeom.make((IPathGeom.Segment[])s));
        } else if (w instanceof BEllipse) {
            BEllipse e = (BEllipse)w;
            BEllipseGeom g = e.getGeom();
            double ex = g.x();
            double ey = g.y();
            double ew = g.width();
            double eh = g.height();
            e.setGeom(BEllipseGeom.make((double)(width - ex - ew), (double)ey, (double)ew, (double)eh));
        } else {
            BWidget[] kids = w.getChildWidgets();
            for (int i = 0; i < kids.length; ++i) {
                this.mirror(kids[i], width);
            }
        }
    }

    private void rotate() {
        int last = this.lastRotation;
        int r = this.getRotation();
        double x = this.getX();
        double y = this.getY();
        double w = this.getWidth();
        double h = this.getHeight();
        if (!((last != 0 && last != 180 || r != 90 && r != 270) && (last != 90 && last != 270 || r != 0 && r != 180))) {
            this.setLayout(BLayout.makeAbs(x, y, h, w));
            this.lastRotation = r;
        }
    }
}

