/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui;

import com.tridium.gx.GxEnv;
import com.tridium.gx.GxEnvListener;
import com.tridium.sys.Nre;
import com.tridium.ui.UiSpy;
import java.security.AccessController;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.Spy;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetApplication;
import javax.baja.ui.BWidgetShell;

@NiagaraType
public abstract class BNiagaraWidgetApplication
extends BWidgetApplication
implements GxEnvListener {
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraWidgetApplication.class);
    static long lastInputTicks = Clock.ticks();
    static boolean needGc = true;
    public static Logger inputMonitorLog = Logger.getLogger("inputMonitor");
    public static long animateDelay = AccessController.doPrivileged(() -> Long.getLong("bajaui.animateDelay", 100L));
    public static boolean runGc = AccessController.doPrivileged(() -> System.getProperty("bajaui.runGc", "true")).equals("true");

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BNiagaraWidgetApplication() {
        GxEnv.get().setGxEnvListener((GxEnvListener)this);
    }

    public boolean useAntiAlias() {
        return false;
    }

    void animate() {
        BWidgetShell[] shells = this.getShells();
        for (int i = 0; i < shells.length; ++i) {
            try {
                shells[i].animate();
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    void inactivityCheck() {
        long inactivity = Clock.ticks() - lastInputTicks;
        if (inactivity > 60000L && needGc && runGc) {
            inputMonitorLog.info("System.gc()");
            System.gc();
            needGc = false;
        }
        this.checkInputActivity(inactivity);
    }

    public static void inputActivity() {
        lastInputTicks = Clock.ticks();
        needGc = true;
    }

    public void checkInputActivity(long inactivity) {
    }

    public void repaintAll() {
        BWidgetShell[] shells = this.getShells();
        for (int i = 0; i < shells.length; ++i) {
            shells[i].repaint();
        }
    }

    static {
        Spy.ROOT.add("userInterface", (Spy)new UiSpy());
        new AnimateThread().start();
    }

    static class AnimateThread
    extends Thread {
        AnimateThread() {
            super(Nre.mainThreadGroup, "Ui:AnimateThread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            BNiagaraWidgetApplication app = (BNiagaraWidgetApplication)BWidget.getApplication();
            int count = 0;
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(animateDelay);
                        ++count;
                        if (app == null) continue;
                        app.animate();
                        if (count % 100 != 0) continue;
                        app.inactivityCheck();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

