/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui;

import com.tridium.ui.theme.Theme;
import com.tridium.ui.util.LayoutUtil;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.BPathGeom;
import javax.baja.gx.BPen;
import javax.baja.gx.BSize;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.RectGeom;
import javax.baja.gx.Size;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BRoundedDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="yesButton", type="BButton", defaultValue="new BButton(\"_yes\")"), @NiagaraProperty(name="noButton", type="BButton", defaultValue="new BButton(\"_no\")"), @NiagaraProperty(name="okButton", type="BButton", defaultValue="new BButton(\"_ok\")"), @NiagaraProperty(name="cancelButton", type="BButton", defaultValue="new BButton(\"_cancel\")")})
@NiagaraAction(name="buttonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()")
public class BRoundedPopup
extends BRoundedDialog {
    @Generated
    public static final Property yesButton = BRoundedPopup.newProperty((int)0, (BValue)new BButton("_yes"), null);
    @Generated
    public static final Property noButton = BRoundedPopup.newProperty((int)0, (BValue)new BButton("_no"), null);
    @Generated
    public static final Property okButton = BRoundedPopup.newProperty((int)0, (BValue)new BButton("_ok"), null);
    @Generated
    public static final Property cancelButton = BRoundedPopup.newProperty((int)0, (BValue)new BButton("_cancel"), null);
    @Generated
    public static final Action buttonPressed = BRoundedPopup.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BRoundedPopup.class);
    private int buttons;
    private BImage icon;
    private RectGeom iconRect = new RectGeom();
    private RectGeom contentRect = new RectGeom();
    private RectGeom buttonsRect = new RectGeom();
    private RectGeom titleRect = new RectGeom();
    private Size buttonDim = new Size();
    private int result;
    private BWidget title;

    @Generated
    public BButton getYesButton() {
        return (BButton)this.get(yesButton);
    }

    @Generated
    public void setYesButton(BButton v) {
        this.set(yesButton, (BValue)v, null);
    }

    @Generated
    public BButton getNoButton() {
        return (BButton)this.get(noButton);
    }

    @Generated
    public void setNoButton(BButton v) {
        this.set(noButton, (BValue)v, null);
    }

    @Generated
    public BButton getOkButton() {
        return (BButton)this.get(okButton);
    }

    @Generated
    public void setOkButton(BButton v) {
        this.set(okButton, (BValue)v, null);
    }

    @Generated
    public BButton getCancelButton() {
        return (BButton)this.get(cancelButton);
    }

    @Generated
    public void setCancelButton(BButton v) {
        this.set(cancelButton, (BValue)v, null);
    }

    @Generated
    public void buttonPressed(BWidgetEvent parameter) {
        this.invoke(buttonPressed, (BValue)parameter, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BRoundedPopup() {
        throw new IllegalStateException();
    }

    public BRoundedPopup(BWidget owner, BWidget content, BWidget title, int buttons) {
        this(owner, content, title, 10.0f, 10.0f, buttons);
    }

    public BRoundedPopup(BWidget owner, BWidget content, String title, float arcWidth, float arcHeight, int buttons) {
        super(owner, title, true, content, arcWidth, arcHeight);
        this.buttons = buttons;
        this.setContent(new BNullWidget());
        BLabel lbl = new BLabel(title);
        lbl.setFont(Theme.label().getLargeBoldFont());
        lbl.setForeground(Theme.toolPane().getForeground(this, false));
        BBrush brush = BBrush.makeSolid((BColor)BColor.black);
        BBorderPane border = new BBorderPane((BWidget)lbl, BBorder.make(1.0, 1, brush, 0.0, 0, brush, 1.0, 1, brush, 0.0, 0, brush));
        border.setPadding(BInsets.make((double)3.0, (double)0.0, (double)2.0, (double)0.0));
        border.setFill(Theme.toolPane().getBackground(this, false));
        BEdgePane pane = new BEdgePane();
        pane.setCenter(new BBorderPane(content, 10.0, 5.0, 0.0, 5.0));
        pane.setTop(border);
        this.setContent(pane);
        this.linkTo(border, (Slot)BWidget.mouseEvent, (Slot)handleMouseEvent);
        this.init();
    }

    public BRoundedPopup(BWidget owner, BWidget content, BWidget title, float arcWidth, float arcHeight, int buttons) {
        super(owner, title.getName(), true, content, arcWidth, arcHeight);
        this.buttons = buttons;
        this.title = title;
        if (null != title) {
            BEdgePane pane = new BEdgePane();
            pane.setCenter(new BBorderPane(content, 10.0, 5.0, 0.0, 5.0));
            pane.setTop(title);
            this.setContent(pane);
        }
        this.init();
    }

    private void init() {
        this.linkTo("linkA", this.getOkButton(), (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.linkTo("linkB", this.getCancelButton(), (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.linkTo("linkC", this.getYesButton(), (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.linkTo("linkD", this.getNoButton(), (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        UiLexicon lex = UiLexicon.bajaui();
        if ((this.buttons & 4) != 0) {
            this.getYesButton().setText(lex.getText("dialog.yes"));
        } else {
            this.getYesButton().setVisible(false);
        }
        if ((this.buttons & 8) != 0) {
            this.getNoButton().setText(lex.getText("dialog.no"));
        } else {
            this.getNoButton().setVisible(false);
        }
        if ((this.buttons & 1) != 0) {
            this.getOkButton().setText(lex.getText("dialog.ok"));
        } else {
            this.getOkButton().setVisible(false);
        }
        if ((this.buttons & 2) != 0) {
            this.getCancelButton().setText(lex.getText("dialog.cancel"));
        } else {
            this.getCancelButton().setVisible(false);
        }
        if ((this.buttons & 1) != 0) {
            this.setDefaultButton(this.getOkButton());
        } else if ((this.buttons & 4) != 0) {
            this.setDefaultButton(this.getYesButton());
        }
    }

    @Override
    public void computePreferredSize() {
        this.computeIconPrefSize();
        this.computeTitlePrefSize();
        this.computeContentPrefSize();
        this.computeButtonsPrefSize();
        double iw = this.iconRect.width;
        double ih = this.iconRect.height;
        double th = this.titleRect.height;
        double cw = this.contentRect.width;
        double ch = this.contentRect.height;
        double bw = this.buttonsRect.width;
        double bh = this.buttonsRect.height;
        double w = Math.max(iw + cw, bw);
        double h = Math.max(ih, ch) + bh + th;
        this.setPreferredSize(w, h);
    }

    @Override
    public void doLayout(BWidget[] kids) {
        this.computePreferredSize();
        double w = this.getWidth();
        double h = this.getHeight();
        this.layoutButtons(w, h);
        this.layoutContentAndIcon(w, h);
    }

    private void computeIconPrefSize() {
        if (this.icon == null) {
            this.iconRect.height = 0.0;
            this.iconRect.width = 0.0;
        } else {
            this.iconRect.width = this.icon.getWidth() + 8.0;
            this.iconRect.height = this.icon.getHeight() + 8.0;
        }
    }

    private void computeTitlePrefSize() {
        if (this.title == null) {
            this.titleRect.height = 0.0;
            this.titleRect.width = 0.0;
        } else {
            this.titleRect.height = this.title.getPreferredHeight();
            this.titleRect.width = this.getWidth();
        }
    }

    private void computeContentPrefSize() {
        BSize size = LayoutUtil.getPreferredSizeForDialogContent(this.getContent());
        this.contentRect.width = size.width();
        this.contentRect.height = size.height();
    }

    private void computeButtonsPrefSize() {
        BButton b;
        double bh = 0.0;
        double bw = 0.0;
        int count = 0;
        if ((this.buttons & 4) != 0) {
            b = this.getYesButton();
            b.computePreferredSize();
            bw = Math.max(bw, b.getPreferredWidth());
            bh = Math.max(bh, b.getPreferredHeight());
            ++count;
        }
        if ((this.buttons & 8) != 0) {
            b = this.getNoButton();
            b.computePreferredSize();
            bw = Math.max(bw, b.getPreferredWidth());
            bh = Math.max(bh, b.getPreferredHeight());
            ++count;
        }
        if ((this.buttons & 1) != 0) {
            b = this.getOkButton();
            b.computePreferredSize();
            bw = Math.max(bw, b.getPreferredWidth());
            bh = Math.max(bh, b.getPreferredHeight());
            ++count;
        }
        if ((this.buttons & 2) != 0) {
            b = this.getCancelButton();
            b.computePreferredSize();
            bw = Math.max(bw, b.getPreferredWidth());
            bh = Math.max(bh, b.getPreferredHeight());
            ++count;
        }
        this.buttonDim.width = bw;
        this.buttonDim.height = bh;
        this.buttonsRect.width = bw * (double)count + (double)(4 * (count - 1)) + 8.0;
        this.buttonsRect.height = bh + 8.0;
    }

    private void layoutButtons(double w, double h) {
        double bx = this.buttonsRect.x = (w - this.buttonsRect.width) / 2.0 + 4.0;
        double by = this.buttonsRect.y = h - this.buttonDim.height - 4.0;
        double bw = this.buttonDim.width;
        double bh = this.buttonDim.height;
        if ((this.buttons & 4) != 0) {
            this.getYesButton().setBounds(bx, by, bw, bh);
            bx += bw + 4.0;
        } else {
            this.getYesButton().setBounds(0.0, 0.0, 0.0, 0.0);
        }
        if ((this.buttons & 8) != 0) {
            this.getNoButton().setBounds(bx, by, bw, bh);
            bx += bw + 4.0;
        } else {
            this.getNoButton().setBounds(0.0, 0.0, 0.0, 0.0);
        }
        if ((this.buttons & 1) != 0) {
            this.getOkButton().setBounds(bx, by, bw, bh);
            bx += bw + 4.0;
        } else {
            this.getOkButton().setBounds(0.0, 0.0, 0.0, 0.0);
        }
        if ((this.buttons & 2) != 0) {
            this.getCancelButton().setBounds(bx, by, bw, bh);
            bx += bw + 4.0;
        } else {
            this.getCancelButton().setBounds(0.0, 0.0, 0.0, 0.0);
        }
    }

    private void layoutContentAndIcon(double w, double h) {
        double aw;
        BWidget top;
        double ah = this.buttonsRect.y - 8.0;
        if (this.icon == null) {
            this.iconRect.y = 0.0;
            this.iconRect.x = 0.0;
        } else {
            this.iconRect.x = 4.0;
            this.iconRect.y = (ah - this.iconRect.height) / 2.0 + 4.0;
        }
        double contentMargin = this.titleRect.height;
        BWidget content = this.getContent();
        if (content instanceof BEdgePane && (top = ((BEdgePane)content).getTop()) instanceof BWizardHeader) {
            contentMargin = 0.0;
        }
        double cx = this.iconRect.x + this.iconRect.width + contentMargin;
        double cy = contentMargin;
        double cw = aw = w - cx - contentMargin;
        double ch = ah;
        this.contentRect.x = cx;
        this.contentRect.y = cy;
        this.contentRect.width = cw;
        this.contentRect.height = ch;
        this.getContent().setBounds(cx, cy, cw, ch);
    }

    @Override
    public void paint(Graphics g) {
        this.paintChildren(g);
        if (this.icon != null) {
            g.drawImage(this.icon, this.iconRect.x, this.iconRect.y);
        }
        double w = this.getWidth();
        double h = this.getHeight();
        int rw = (int)(this.arcWidth / 2.0f);
        int rh = (int)(this.arcHeight / 2.0f);
        g.setPen(BPen.make((double)1.0));
        g.setBrush(BColor.black);
        g.strokeLine(0.0, (double)rw, 0.0, h - (double)rw);
        g.strokeLine((double)rw, 0.0, w - (double)rw, 0.0);
        g.strokeLine(w - 1.0, (double)rh, w - 1.0, h - (double)rh);
        g.strokeLine((double)rw, h - 1.0, w - (double)rw, h - 1.0);
        IPathGeom.Segment[] segs = new IPathGeom.Segment[]{new IPathGeom.MoveTo(true, 0.0, (double)(rh - 1)), new IPathGeom.ArcTo(true, (double)this.arcWidth, (double)this.arcHeight, 0.0, false, false, (double)rw, 0.0), new IPathGeom.MoveTo(true, w - (double)rw, 0.0), new IPathGeom.ArcTo(true, (double)this.arcWidth, (double)this.arcHeight, 0.0, false, false, w - 1.0, (double)rh), new IPathGeom.MoveTo(true, w - 1.0, h - (double)rh - 1.0), new IPathGeom.ArcTo(true, (double)this.arcWidth, (double)this.arcHeight, 0.0, false, false, w - (double)rw, h - 1.0), new IPathGeom.MoveTo(true, (double)(rw - 1), h - 1.0), new IPathGeom.ArcTo(true, (double)this.arcWidth, (double)this.arcHeight, 0.0, false, false, 0.0, h - (double)rh - 1.0)};
        g.stroke((IGeom)BPathGeom.make((IPathGeom.Segment[])segs));
    }

    public int getResult() {
        return this.result;
    }

    public void close(int result) {
        this.result = result;
        this.close();
    }

    @Override
    public void open() {
        super.open();
    }

    public void doButtonPressed(BWidgetEvent event) {
        BWidget src = event.getWidget();
        if (src == this.getOkButton()) {
            this.close(1);
        }
        if (src == this.getCancelButton()) {
            this.close(2);
        }
        if (src == this.getYesButton()) {
            this.close(4);
        }
        if (src == this.getNoButton()) {
            this.close(8);
        }
    }

    @Override
    public void windowClosing(BWindowEvent event) {
        this.result = (this.buttons & 2) != 0 ? 2 : ((this.buttons & 1) != 0 ? 1 : ((this.buttons & 8) != 0 ? 8 : ((this.buttons & 4) != 0 ? 4 : 2)));
        this.close();
    }
}

