/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui;

import com.tridium.agent.BILoadablePxView;
import com.tridium.fox.util.FoxRpcUtil;
import com.tridium.sys.spy.CacheSpy;
import com.tridium.ui.BPxCacheShell;
import com.tridium.ui.Binder;
import java.io.ByteArrayInputStream;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.BAbstractPxView;
import javax.baja.agent.BDynamicPxView;
import javax.baja.agent.BPxView;
import javax.baja.file.BDataFile;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.util.SortUtil;
import javax.baja.security.PermissionException;
import javax.baja.space.BComponentSpace;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.ui.BBinding;
import javax.baja.ui.BWidget;
import javax.baja.ui.px.PxDecoder;
import javax.baja.user.BUser;

public final class PxCache {
    private static final BUser dummyUser = new BUser();
    private static HashMap<Key, Item> cache = new HashMap();
    private static Logger log = Logger.getLogger("px.cache");
    private static int MAX_CACHE_SIZE;

    private PxCache() {
    }

    public static synchronized Item get(OrdTarget op, BAbstractPxView pxView) throws Exception {
        return PxCache.get(op, pxView != null ? pxView.getName() : "", pxView);
    }

    public static synchronized Item get(OrdTarget op, String viewName, BAbstractPxView pxView) throws Exception {
        Key key;
        Item item;
        BObject target = op.get();
        BOrd pxFileOrd = BOrd.NULL;
        String uid = "";
        if (target instanceof BDataFile) {
            pxFileOrd = op.getOrd();
        } else {
            if (pxView == null) {
                throw new IllegalArgumentException("pxView cannot be null when using " + target.getType());
            }
            if (pxView instanceof BPxView) {
                pxFileOrd = ((BPxView)pxView).getPxFile();
            } else if (pxView instanceof BDynamicPxView) {
                uid = ((BDynamicPxView)pxView).getUniqueId(op);
            } else {
                throw new IllegalArgumentException("Don't know how to handle " + pxView.getType());
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(op.getOrd() + " [" + target.getType() + "] px=" + pxFileOrd + " type=" + (pxView == null ? "null" : pxView.getType()));
        }
        if ((item = cache.get(key = new Key(target, pxFileOrd, uid, (Context)op))) != null) {
            if (item.hasFileBeenModified() || pxView instanceof BILoadablePxView && ((BILoadablePxView)pxView).isPxViewModified(item.fileTime)) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("  cache out of date");
                }
                cache.remove(key);
            } else {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("  cached");
                }
                item.shell.setActiveOrdTarget(op);
                item.shell.setActiveViewId(viewName);
                PxCache.bindAll(target, item.shell, (Context)op);
                item.lastUsedTicks = Clock.ticks();
                return item;
            }
        }
        int max = PxCache.getMaxCacheSize();
        while (cache.size() > max - 1) {
            PxCache.removeLeastRecentlyUsed();
        }
        BasicContext cx = new BasicContext(op.getUser(), op.getLanguage());
        BIFile file = null;
        if (log.isLoggable(Level.FINE)) {
            log.fine("  load");
        }
        BWidget widget = null;
        if (!pxFileOrd.isNull()) {
            file = (BIFile)pxFileOrd.get(target);
            widget = new PxDecoder(file, (Context)cx).decodeDocument();
        } else {
            String xml;
            BComponent comp = op.getComponent();
            if (pxView != null && viewName != null && pxView instanceof BDynamicPxView && Sys.getStation() == null && comp != null && comp.isMounted()) {
                try {
                    xml = (BString)FoxRpcUtil.doRpcProperty((BComponent)comp, (Property)comp.getProperty(viewName), (String)"generateXml", (Object[])new Object[0]).orElseThrow(() -> new BajaRuntimeException("RPC call to generateXml failed"));
                    ByteArrayInputStream in = new ByteArrayInputStream(xml.toString().getBytes());
                    widget = new PxDecoder(comp.getNavOrd(), in, (Context)op).decodeDocument();
                }
                catch (Throwable xml2) {
                    // empty catch block
                }
            }
            if (widget == null && pxView instanceof BDynamicPxView) {
                xml = ((BDynamicPxView)pxView).generateXml((Object)target, (Context)op);
                widget = new PxDecoder(op.getOrd(), new ByteArrayInputStream(xml.getBytes("UTF8")), (Context)cx).decodeDocument();
            }
        }
        if (widget == null) {
            throw new IllegalStateException("Cannot decode Widget from PxCache");
        }
        BPxCacheShell shell = new BPxCacheShell();
        shell.setContent(widget);
        shell.setActiveOrdTarget(op);
        shell.setActiveViewId(viewName);
        BComponentSpace space = PxCache.load(target, shell, (Context)op);
        item = new Item(key, file, space);
        item.lastUsedTicks = Clock.ticks();
        cache.put(key, item);
        return item;
    }

    private static int getMaxCacheSize() {
        return MAX_CACHE_SIZE;
    }

    public static void trimAll() {
        cache.clear();
        log.info("Entire cache cleared");
    }

    private static void removeLeastRecentlyUsed() {
        Iterator<Item> it = cache.values().iterator();
        Item lru = null;
        while (it.hasNext()) {
            Item item = it.next();
            if (lru != null && item.lastUsedTicks >= lru.lastUsedTicks) continue;
            lru = item;
        }
        if (lru != null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("  remove LRU " + lru.key);
            }
            cache.remove(lru.key);
        }
    }

    private static BComponentSpace load(BObject target, BWidget widget, Context cx) throws Exception {
        PxCache.bindAll(target, widget, cx);
        BComponentSpace space = new BComponentSpace("foo", null, BOrd.make((String)"foo:"));
        space.setRootComponent((BComponent)widget);
        return space;
    }

    private static void bindAll(BObject target, BComponent comp, Context cx) {
        SlotCursor cursor = comp.getProperties();
        while (cursor.nextComponent()) {
            BComponent kid = (BComponent)cursor.get();
            if (kid instanceof BBinding) {
                PxCache.bind(target, (BBinding)kid, cx);
                continue;
            }
            PxCache.bindAll(target, kid, cx);
        }
    }

    private static void bind(BObject base, BBinding binding, Context cx) {
        block5: {
            BOrd ord = binding.getOrd();
            try {
                OrdTarget target = ord.resolve(base, cx);
                if (!target.canRead()) {
                    throw new PermissionException();
                }
                Binder.updateBinding(binding, target);
            }
            catch (PermissionException e) {
                if (ord != null && !ord.isNull()) {
                    Binder.log.warning("no read permission: " + ord);
                }
            }
            catch (Exception e) {
                if (ord == null || ord.isNull()) break block5;
                Binder.log.warning("unresolved: " + ord);
            }
        }
    }

    static {
        Spy.ROOT.add("pxCache", (Spy)new PxCacheSpy());
        MAX_CACHE_SIZE = AccessController.doPrivileged(() -> Integer.getInteger("niagara.ui.pxCache.max", 10));
    }

    public static final class Item {
        private long lastUsedTicks;
        private final Key key;
        private final BIFile file;
        private final BAbsTime fileTime;
        public final BComponentSpace space;
        public final BPxCacheShell shell;
        public final HashMap<Key, Item> cache = new HashMap();

        private Item(Key key, BIFile file, BComponentSpace space) {
            this.key = key;
            this.file = file;
            this.fileTime = file == null ? BAbsTime.now() : file.getLastModified();
            this.space = space;
            this.shell = (BPxCacheShell)space.getRootComponent();
        }

        private boolean hasFileBeenModified() {
            if (this.file == null) {
                return false;
            }
            BIFile x = (BIFile)this.file.getNavOrd().get();
            return !x.getLastModified().equals((Object)this.fileTime);
        }
    }

    private static class Key {
        private BObject target;
        private BOrd pxFileOrd;
        private String uid;
        private BUser user;
        private String lang;
        private int hashCode;

        private Key(BObject target, BOrd pxFileOrd, String uid, Context cx) {
            this.target = target;
            this.pxFileOrd = pxFileOrd;
            this.uid = uid;
            if (cx != null) {
                this.user = cx.getUser();
                this.lang = cx.getLanguage();
            }
            if (this.lang == null) {
                this.lang = Sys.getLanguage();
            }
            if (this.user == null) {
                this.user = dummyUser;
            }
            this.hashCode = target.hashCode() ^ pxFileOrd.hashCode() ^ uid.hashCode() ^ this.lang.hashCode() ^ this.user.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key key = (Key)obj;
            return this.target.equals((Object)key.target) && this.pxFileOrd.equals((Object)key.pxFileOrd) && this.uid.equals(key.uid) && this.lang.equals(key.lang) && this.user == key.user;
        }

        public String toString() {
            return this.targetToString() + " " + this.pxFileOrd + " " + this.uid;
        }

        private String targetToString() {
            if (this.target.isComponent()) {
                return this.target.asComponent().toPathString();
            }
            return this.target.toDebugString();
        }
    }

    private static class PxCacheSpy
    extends CacheSpy {
        PxCacheSpy() {
            super("Px Cache", "/pxCache");
        }

        public void clearCache() {
            PxCache.trimAll();
        }

        public void write(SpyWriter out) throws Exception {
            super.write(out);
            Object[] items = cache.values().toArray(new Item[0]);
            long now = Clock.ticks();
            Object[] ages = new Long[items.length];
            for (int i = 0; i < ages.length; ++i) {
                ages[i] = now - ((Item)items[i]).lastUsedTicks;
            }
            SortUtil.sort((Object[])ages, (Object[])items);
            out.startTable(true);
            out.trTitle((Object)("PxCache [max=" + PxCache.getMaxCacheSize() + "]"), 4);
            out.w((Object)"<tr>").th((Object)"Target").th((Object)"PxFile").th((Object)"UID").th((Object)"Age").w((Object)"</tr>\n");
            for (Object item : items) {
                String age = BRelTime.toString((long)(now - ((Item)item).lastUsedTicks));
                out.tr((Object)((Item)item).key.targetToString(), (Object)((Item)item).key.pxFileOrd, (Object)((Item)item).key.uid, (Object)age);
            }
            out.endTable();
        }
    }
}

