/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.awt;

import com.tridium.ui.awt.AwtUiEnv;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.baja.space.Mark;

public class MarkTransferable
implements Transferable {
    public static final DataFlavor markFlavor = MarkTransferable.createFlavor();
    static DataFlavor[] flavors = new DataFlavor[]{markFlavor, DataFlavor.stringFlavor};
    String string;
    Mark mark;

    public static MarkTransferable make(Mark mark) {
        return new MarkTransferable(mark);
    }

    MarkTransferable(Mark mark) {
        this.mark = mark;
        this.string = mark.toStringFormat();
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws IOException, UnsupportedFlavorException {
        if (flavor.equals(markFlavor)) {
            return this.mark;
        }
        if (flavor.equals(DataFlavor.stringFlavor) || flavor.getMimeType().startsWith("text")) {
            return this.string;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])flavors.clone();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        DataFlavor[] flavors = this.getTransferDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavor.equals(flavors[i])) continue;
            return true;
        }
        return false;
    }

    static DataFlavor createFlavor() {
        try {
            return ((AwtUiEnv)AwtUiEnv.get()).makeMarkDataFlavor();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }
}

