/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.awt;

import com.tridium.ui.UiEnv;
import com.tridium.ui.awt.MarkTransferable;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.security.AccessController;
import javax.baja.space.Mark;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.transfer.UnsupportedFormatException;

public class TransferManager {
    public static final ClipboardManager defaultClipboardManager = new ClipboardManager(Toolkit.getDefaultToolkit().getSystemClipboard());
    static final String emptyString = "!_empty_*&^";
    static final StringSelection empty = AccessController.doPrivileged(() -> new StringSelection(emptyString));

    public static Transferable toAwt(TransferEnvelope e) {
        if (e == null) {
            return empty;
        }
        TransferFormat[] formats = e.getFormats();
        if (formats[0].equals(TransferFormat.string)) {
            String data = (String)e.getData(TransferFormat.string);
            return new StringSelection(data);
        }
        if (formats[0].equals(TransferFormat.mark)) {
            Mark mark = (Mark)e.getData(TransferFormat.mark);
            return MarkTransferable.make(mark);
        }
        throw new IllegalStateException("Unknown transfer envelope");
    }

    public static TransferEnvelope fromAwt(Transferable t) {
        if (t == null) {
            return null;
        }
        try {
            if (t.isDataFlavorSupported(MarkTransferable.markFlavor)) {
                Mark mark = (Mark)t.getTransferData(MarkTransferable.markFlavor);
                return TransferEnvelope.make(mark);
            }
            String string = (String)t.getTransferData(DataFlavor.stringFlavor);
            if (string.equals(emptyString)) {
                return null;
            }
            return TransferEnvelope.make(string);
        }
        catch (Exception e) {
            throw new UnsupportedFormatException(e);
        }
    }

    public static class ClipboardManager
    implements UiEnv.ClipboardManager {
        Clipboard awtClipboard;

        public ClipboardManager(Clipboard awtClipboard) {
            this.awtClipboard = awtClipboard;
        }

        @Override
        public TransferEnvelope getContents() {
            Transferable t = AccessController.doPrivileged(() -> this.awtClipboard.getContents(null));
            TransferEnvelope e = TransferManager.fromAwt(t);
            return e;
        }

        @Override
        public void setContents(TransferEnvelope e) {
            Transferable t = TransferManager.toAwt(e);
            this.awtClipboard.setContents(t, null);
        }
    }
}

