/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.awt.se;

import com.tridium.ui.NiagaraWbShell;
import com.tridium.ui.ShellPeer;
import com.tridium.ui.awt.AwtShellManager;
import com.tridium.ui.awt.se.AwtSeDragOperation;
import com.tridium.ui.awt.se.InputMethodManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.im.InputMethodRequests;
import java.io.File;
import java.util.List;
import javax.baja.file.BFileSystem;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComplex;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.DragRenderer;
import javax.baja.ui.transfer.TransferContext;

public class AwtSeShellManager
extends AwtShellManager
implements DropTargetListener {
    private DropTarget dropTarget;
    public final InputMethodManager methodManager;

    public AwtSeShellManager(BWidget shell, ShellPeer peer) {
        super(shell, peer);
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
        this.enableInputMethods(true);
        this.enableEvents(133180L);
        this.dropTarget = new DropTarget(this, 3, this);
        this.methodManager = new InputMethodManager(this);
    }

    @Override
    public void processMouseWheelEvent(MouseWheelEvent event) {
        this.wheel(event);
        super.processMouseWheelEvent(event);
    }

    void wheel(MouseWheelEvent src) {
        BComplex p;
        BWidget target = this.mouseManager.over();
        if (target == null) {
            return;
        }
        BMouseEvent event = this.mouseManager.fire(507, src, target);
        while (!event.isConsumed() && (p = target.getParent()) instanceof BWidget) {
            target = (BWidget)p;
            try {
                target.fireMouseEvent(event);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void startDragOperation(BTransferWidget source, BMouseEvent event, TransferContext context, DragRenderer dragRenderer) {
        dragOperation = new AwtSeDragOperation(this, source, event, context, dragRenderer);
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
        if (event.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            event.acceptDrag(1);
        } else {
            event.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent event) {
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        try {
            if (event.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                event.acceptDrop(1);
                Transferable data = event.getTransferable();
                List list = (List)data.getTransferData(DataFlavor.javaFileListFlavor);
                File file = (File)list.get(0);
                if (this.shell instanceof NiagaraWbShell) {
                    BOrd ord = BFileSystem.INSTANCE.localFileToOrd(file);
                    ((NiagaraWbShell)((Object)this.shell)).hyperlink(ord);
                }
            } else {
                event.rejectDrop();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        event.dropComplete(true);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent event) {
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        return this.methodManager;
    }

    @Override
    public void processInputMethodEvent(InputMethodEvent event) {
        this.methodManager.process(event);
        super.processInputMethodEvent(event);
    }
}

