/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.file;

import com.tridium.ui.file.PreviewRenderer;
import com.tridium.ui.theme.Theme;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BWidget;

public class TextPreviewRenderer
extends PreviewRenderer {
    String[] text;
    RectGeom textBounds = new RectGeom();
    double th;
    Point nameLoc = new Point();
    Point sizeLoc = new Point();
    Point timeLoc = new Point();
    String name = "";
    String size = "";
    String time = "";

    public TextPreviewRenderer(BWidget parent) {
        super(parent);
    }

    @Override
    public void doPaint(Graphics g) {
        g.setBrush(BColor.black);
        g.setFont(Theme.widget().getBoldText());
        g.drawString(this.name, this.nameLoc.x, this.nameLoc.y);
        g.setFont(Theme.widget().getTextFont());
        g.drawString(this.size, this.sizeLoc.x, this.sizeLoc.y);
        g.drawString(this.time, this.timeLoc.x, this.timeLoc.y);
        g.setBrush(BColor.gray);
        double x = this.textBounds.x;
        double y = this.textBounds.y;
        for (int i = 0; i < this.text.length; ++i) {
            if (this.text[i] != null) {
                g.drawString(this.text[i], x, y);
            }
            y += this.th;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doPrepare(double width, double height) throws Exception {
        try (BufferedReader in = null;){
            long sz = this.file.getSize();
            this.size = sz < 1024L ? String.valueOf(sz) + " bytes" : String.valueOf(sz / 1024L) + " KB";
            this.name = this.file.getNavDisplayName(null);
            this.time = String.valueOf(this.file.getLastModified());
            BFont font = Theme.widget().getTextFont();
            BFont bold = Theme.widget().getBoldText();
            this.th = font.getHeight();
            double ta = font.getAscent();
            double td = font.getDescent();
            double nw = bold.width(this.name);
            double sw = font.width(this.size);
            double tw = font.width(this.time);
            in = new BufferedReader(new InputStreamReader(this.file.getInputStream()));
            int numlines = (int)((height - this.th * 3.0) / this.th);
            this.text = new String[numlines];
            for (int i = 0; i < numlines; ++i) {
                this.text[i] = in.readLine();
            }
            this.textBounds.set(0.0, ta, width, (double)numlines * this.th);
            this.nameLoc.set((width - nw) / 2.0, height - this.th * 2.0 - td - 1.0);
            this.sizeLoc.set((width - sw) / 2.0, height - this.th - td - 1.0);
            this.timeLoc.set((width - tw) / 2.0, height - td - 1.0);
        }
    }
}

