/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.fx;

import com.tridium.ui.fx.BFxWidget;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.effect.DropShadow;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.CornerRadii;
import javafx.scene.shape.Rectangle;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.TransferContext;
import javax.swing.SwingUtilities;

@NiagaraType
public class BFxContentPane
extends BFxWidget {
    @Generated
    public static final Type TYPE = Sys.loadType(BFxContentPane.class);
    private BorderPane innerPane = new BorderPane();
    private BorderPane outerPane = new BorderPane();
    private BBorderPane content;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BFxContentPane(BWidget content) {
        this.content = new BBorderPane(content, BBorder.none, BInsets.DEFAULT);
        this.add("content", (BValue)this.content);
    }

    public BFxContentPane(BWidget content, String id) {
        this(content);
        this.setId(id);
    }

    public BFxContentPane(BWidget content, BInsets padding, String id) {
        this(content, id);
        this.content.setPadding(padding);
    }

    public void setPadding(BInsets padding) {
        this.content.setPadding(padding);
    }

    public void setId(String id) {
        this.innerPane.setId(id + "-foreground");
        this.outerPane.setId(id + "-background");
    }

    @Override
    public Node createNode() {
        this.innerPane.boundsInLocalProperty().addListener((value, oldBounds, newBounds) -> SwingUtilities.invokeLater(() -> this.relayout()));
        this.innerPane.setCenter((Node)new Rectangle(0.0, 0.0, 0.0, 0.0));
        this.outerPane.setCenter((Node)this.innerPane);
        return this.outerPane;
    }

    @Override
    protected void fxInitialized() {
        super.fxInitialized();
        SwingUtilities.invokeLater(() -> this.relayout());
    }

    @Override
    public int doDragOver(TransferContext cx) {
        BTransferWidget widget = this.getTransferWidget(this.content);
        return widget == null ? 0 : widget.dragOver(cx);
    }

    @Override
    public void dragEnter(TransferContext cx) {
        BTransferWidget widget = this.getTransferWidget(this.content);
        if (widget != null) {
            widget.dragEnter(cx);
        }
    }

    @Override
    public void dragExit(TransferContext cx) {
        BTransferWidget widget = this.getTransferWidget(this.content);
        if (widget != null) {
            widget.dragExit(cx);
        }
    }

    private BTransferWidget getTransferWidget(BWidget root) {
        BWidget child;
        if (root instanceof BTransferWidget) {
            return (BTransferWidget)root;
        }
        BWidget[] children = root.getChildWidgets();
        BTransferWidget w = null;
        BWidget[] bWidgetArray = children;
        int n = bWidgetArray.length;
        for (int i = 0; i < n && (w = this.getTransferWidget(child = bWidgetArray[i])) == null; ++i) {
        }
        return w;
    }

    @Override
    public void doLayout(BWidget[] children) {
        super.doLayout(children);
        if (this.content == null) {
            return;
        }
        Bounds bounds = this.innerPane.localToScene(this.innerPane.getBoundsInLocal());
        Insets insets = this.insets();
        CornerRadii radii = this.radii();
        DropShadow shadow = this.innerPane.getEffect() != null && this.innerPane.getEffect() instanceof DropShadow ? (DropShadow)this.innerPane.getEffect() : null;
        double shadowRadius = shadow != null ? shadow.getRadius() : 0.0;
        double shadowWidth = shadow != null ? shadow.getWidth() : 0.0;
        double shadowHeight = shadow != null ? shadow.getHeight() : 0.0;
        double adjustedBoundsWidth = bounds.getWidth() - insets.getLeft() - insets.getRight() - shadowWidth;
        double adjustedBoundsHeight = bounds.getHeight() - insets.getTop() - insets.getBottom() - shadowHeight;
        double tlr = radii.getTopLeftHorizontalRadius();
        double tlmpx = this.midx(tlr);
        double tlmpy = this.midy(tlr);
        double trr = radii.getTopRightHorizontalRadius();
        double trmpx = this.midx(trr);
        double trmpy = this.midy(trr);
        double blr = radii.getBottomRightHorizontalRadius();
        double blmpx = this.midx(blr);
        double blmpy = this.midy(blr);
        double brr = radii.getBottomLeftHorizontalRadius();
        double brmpx = this.midx(brr);
        double brmpy = this.midy(brr);
        double originX = bounds.getMinX() + insets.getLeft() + shadowRadius;
        double originY = bounds.getMinY() + insets.getTop() + shadowRadius;
        double tlx = originX + tlr - tlmpx;
        double tly = originY + tlr - tlmpy;
        double trx = originX + adjustedBoundsWidth - trr + trmpx;
        double _try = originY + trr - trmpy + insets.getTop() + shadowRadius;
        double blx = originX + blr - blmpx;
        double bly = originY + adjustedBoundsHeight - blr + blmpy;
        double brx = originX + adjustedBoundsWidth - brr + brmpx;
        double bry = originY + adjustedBoundsHeight - brr + brmpy;
        double widgetWidth = Math.min(trx - tlx, brx - blx);
        double widgetHeight = Math.min(bly - tly, bry - _try);
        this.content.setBounds(originX, originY, adjustedBoundsWidth, adjustedBoundsHeight);
    }

    private Insets insets() {
        Background bg = this.innerPane.getBackground();
        return bg != null ? ((BackgroundFill)bg.getFills().get(0)).getInsets() : new Insets(0.0, 0.0, 0.0, 0.0);
    }

    private CornerRadii radii() {
        Background bg = this.innerPane.getBackground();
        return bg != null ? ((BackgroundFill)bg.getFills().get(0)).getRadii() : new CornerRadii(0.0);
    }

    private double midx(double r) {
        return this.midpoint(r, 0.0, r);
    }

    private double midy(double r) {
        return this.midpoint(r, r, 0.0);
    }

    private double midpoint(double r, double a, double b) {
        double val1 = Math.sqrt((r + a) * (r + b));
        double val2 = Math.sqrt((r - a) * (r - b));
        return (val1 + val2) / 2.0;
    }
}

