/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.fx;

import com.tridium.gx.awt.ImageManager;
import com.tridium.sys.Nre;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.security.AccessController;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.EventType;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javax.baja.gx.BImage;
import javax.baja.sys.BIcon;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;

public final class FxUtil {
    private static final int MIN_VERSION_LEVEL = 40;
    private static final String JAVA_VERSION = AccessController.doPrivileged(() -> System.getProperty("java.version"));

    public static ImageView getImage(BImage image) {
        ImageView view = new ImageView();
        if (image == null || image.equals((Object)BImage.NULL) || image.getOrdList().size() == 0 || image.getOrdList().get(0).isNull()) {
            return view;
        }
        Image awtImage = ImageManager.fetchImageData((BImage)image).getImage();
        BufferedImage bufferedImage = new BufferedImage(awtImage.getWidth(null), awtImage.getHeight(null), 2);
        bufferedImage.getGraphics().drawImage(awtImage, 0, 0, null);
        view.setImage((javafx.scene.image.Image)SwingFXUtils.toFXImage((BufferedImage)bufferedImage, null));
        bufferedImage.getGraphics().dispose();
        return view;
    }

    public static ImageView getImage(String name) {
        return FxUtil.getImage(BImage.make((BIcon)BIcon.std((String)(name + ".png"))));
    }

    public static CommandEvent makeKeyEvent(BWidget source, KeyEvent event) {
        BKeyEvent keyEvent = new BKeyEvent(event.getID(), source, event.getModifiersEx(), event.getKeyCode(), event.getKeyChar());
        return new CommandEvent(keyEvent);
    }

    public static CommandEvent makeCommandEvent(BWidget source, MouseEvent event) {
        BMouseEvent mouseEvent = new BMouseEvent(FxUtil.idForEvent(event), source, FxUtil.modifiersForEvent(event), event.getX(), event.getY(), event.getClickCount(), event.isPopupTrigger());
        return new CommandEvent(mouseEvent);
    }

    private static int idForEvent(MouseEvent event) {
        EventType eventType = event.getEventType();
        if (eventType.equals(MouseEvent.MOUSE_CLICKED)) {
            return 510;
        }
        if (eventType.equals(MouseEvent.MOUSE_DRAGGED)) {
            return 506;
        }
        if (eventType.equals(MouseEvent.MOUSE_ENTERED)) {
            return 504;
        }
        if (eventType.equals(MouseEvent.MOUSE_EXITED)) {
            return 505;
        }
        if (eventType.equals(MouseEvent.MOUSE_MOVED)) {
            return 503;
        }
        if (eventType.equals(MouseEvent.MOUSE_PRESSED)) {
            return 501;
        }
        if (eventType.equals(MouseEvent.MOUSE_RELEASED)) {
            return 502;
        }
        return 0;
    }

    private static int modifiersForEvent(MouseEvent event) {
        int modifiers = 0;
        modifiers |= event.isAltDown() ? 512 : 0;
        modifiers |= event.isPrimaryButtonDown() ? 1024 : 0;
        modifiers |= event.isSecondaryButtonDown() ? 2048 : 0;
        modifiers |= event.isMiddleButtonDown() ? 4096 : 0;
        modifiers |= event.isControlDown() ? 128 : 0;
        modifiers |= event.isMetaDown() ? 256 : 0;
        return modifiers |= event.isShiftDown() ? 64 : 0;
    }

    public static boolean isMinVersionLevel() {
        if (!JAVA_VERSION.startsWith("1.8")) {
            return false;
        }
        int index = JAVA_VERSION.indexOf("_");
        if (index != -1) {
            String versionLevel = JAVA_VERSION.substring(index + 1);
            if ((index = versionLevel.indexOf("-")) != -1) {
                versionLevel = versionLevel.substring(0, index);
            }
            try {
                return Integer.parseInt(versionLevel) >= 40;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static boolean toolbarFixRequired() {
        return Nre.bootEnv.isRemote() || FxUtil.isMinVersionLevel();
    }
}

