/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.fx.menu;

import com.tridium.ui.fx.BFxWidget;
import com.tridium.ui.fx.FxUtil;
import com.tridium.ui.fx.menu.FxMenuFactory;
import java.awt.AWTEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.layout.BorderPane;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.menu.BIMenu;
import javax.baja.ui.menu.BIMenuBar;
import javax.baja.ui.menu.BIMenuItem;

@NiagaraType
public final class BFxMenuBar
extends BFxWidget
implements BIMenuBar {
    @Generated
    public static final Type TYPE = Sys.loadType(BFxMenuBar.class);
    private BorderPane fxMenuForegroundContainer = new BorderPane();
    private BorderPane fxMenuBackgroundContainer = new BorderPane();
    private MenuBar fxMenuBar = new MenuBar();
    private Map<Property, Menu> menus = new HashMap<Property, Menu>();
    private Map<BIMenuItem, MenuItem> menuItemsToFxMenuItems = new HashMap<BIMenuItem, MenuItem>();
    private Node fxQuickSearch;
    volatile KeyEvent lastKeyEvent;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public Parent createNode() {
        this.fxMenuForegroundContainer.setCenter((Node)this.fxMenuBar);
        if (this.fxQuickSearch != null) {
            this.fxMenuForegroundContainer.setRight(this.fxQuickSearch);
        }
        this.fxMenuBackgroundContainer.setCenter((Node)this.fxMenuForegroundContainer);
        return this.fxMenuBackgroundContainer;
    }

    @Override
    protected void fxInitialized() {
        final JFXPanel panel = this.getJfxPanel();
        if (!FxUtil.isMinVersionLevel()) {
            final WeakReference<MenuBar> fxMenuBarRef = new WeakReference<MenuBar>(this.fxMenuBar);
            panel.addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    BFxWidget.postfx(() -> {
                        MenuBar menuBar = (MenuBar)fxMenuBarRef.get();
                        if (menuBar != null) {
                            menuBar.getMenus().forEach(Menu::hide);
                        }
                    });
                }
            });
        }
        panel.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                BFxMenuBar.this.lastKeyEvent = e;
            }

            @Override
            public void keyReleased(KeyEvent e) {
                BFxMenuBar.this.lastKeyEvent = null;
            }
        });
        panel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1 && !panel.hasFocus()) {
                    BWidget.invokeLater(() -> panel.dispatchEvent((AWTEvent)e));
                }
            }
        });
    }

    @Override
    public void setId(String id) {
        this.fxMenuBar.setId(id);
        this.fxMenuForegroundContainer.setId(id + "-foreground-container");
        this.fxMenuBackgroundContainer.setId(id + "-background-container");
    }

    @Override
    public void removeAllMenus() {
        this.removeAll();
    }

    @Override
    public BIMenu[] getMenus() {
        return (BIMenu[])this.getChildren(BIMenu.class);
    }

    @Override
    public void addMenu(String menuName, BIMenu menu) {
        this.add(menuName, (BValue)menu.asWidget());
    }

    @Override
    public void setMenu(String menuName, BIMenu menu) {
        this.set(menuName, (BValue)menu.asWidget());
    }

    @Override
    public BIMenu getMenu(String menuName) {
        return (BIMenu)this.get(menuName);
    }

    @Override
    public BIMenu removeMenu(String menuName) {
        BIMenu menuToRemove = this.getMenu(menuName);
        if (menuToRemove != null) {
            this.remove(menuName);
        }
        return menuToRemove;
    }

    @Override
    public void removeMenu(BIMenu menu) {
        this.removeMenu(menu.getName());
    }

    @Override
    public void addQuickSearch(BWidget quickSearch) {
        if (quickSearch instanceof BFxWidget) {
            BFxMenuBar.postfx(() -> {
                this.fxQuickSearch = ((BFxWidget)quickSearch).createNode();
                Node existingQuickSearch = this.fxMenuForegroundContainer.getRight();
                if (existingQuickSearch != this.fxQuickSearch) {
                    this.fxMenuForegroundContainer.setRight(this.fxQuickSearch);
                }
            });
        }
    }

    @Override
    public void removeQuickSearch() {
        BFxMenuBar.postfx(() -> {
            if (this.fxMenuForegroundContainer.getRight() != null) {
                this.fxMenuForegroundContainer.setRight(null);
            }
        });
    }

    @Override
    public BWidget asWidget() {
        return this;
    }

    public void started() throws Exception {
        BWidgetShell shell = this.getShell();
        if (shell != null) {
            shell.setMenuBar(this);
        }
    }

    public void stopped() throws Exception {
        BWidgetShell shell = this.getShell();
        if (shell != null) {
            shell.setMenuBar(null);
        }
        this.menus.values().forEach(this::clearMenu);
        this.menus.clear();
        this.menuItemsToFxMenuItems.values().forEach(this::clearMenuItem);
        this.menuItemsToFxMenuItems.clear();
    }

    @Override
    public void changed(Property property, Context context) {
        super.changed(property, context);
        BValue value = this.get(property);
        if (value instanceof BIMenu) {
            BFxMenuBar.postfx(() -> this.menuReplaced(property, (BIMenu)value));
        }
    }

    public final void added(Property property, Context context) {
        BValue value = this.get(property);
        if (value instanceof BIMenu) {
            BFxMenuBar.postfx(() -> this.menuAdded(property, (BIMenu)value));
        }
    }

    public final void removed(Property property, BValue oldValue, Context context) {
        if (oldValue instanceof BIMenu) {
            BFxMenuBar.postfx(() -> this.menuRemoved(property, (BIMenu)oldValue));
        }
    }

    private void menuAdded(Property prop, BIMenu menu) {
        Subscriber.make(event -> {
            if (event.getId() == 2 && event.getValue() instanceof BIMenuItem) {
                BFxMenuBar.postfx(() -> this.menuItemRemoved((BIMenu)event.getSourceComponent(), (BIMenuItem)event.getValue()));
            }
        }).subscribe((BComponent)menu.asWidget());
        Menu fxMenu = FxMenuFactory.makeFor(menu);
        this.mapMenuItems(menu, fxMenu);
        this.menus.put(prop, fxMenu);
        this.fxMenuBar.getMenus().add((Object)fxMenu);
    }

    private void menuReplaced(Property prop, BIMenu newMenu) {
        Menu newFxMenu = FxMenuFactory.makeFor(newMenu);
        Menu oldFxMenu = this.menus.get(prop);
        this.menus.replace(prop, oldFxMenu, newFxMenu);
        ObservableList fxMenus = this.fxMenuBar.getMenus();
        int index = fxMenus.indexOf(oldFxMenu);
        fxMenus.remove(index);
        fxMenus.add(index, newFxMenu);
        this.mapMenuItems(newMenu, newFxMenu);
        this.clearMenu(oldFxMenu);
    }

    private void menuRemoved(Property prop, BIMenu menu) {
        Menu fxMenu = this.menus.remove(prop);
        this.unmapMenuItems(menu);
        this.deregisterSubscribers(menu);
        this.fxMenuBar.getMenus().removeAll((Object[])new Menu[]{fxMenu});
        this.clearMenu(fxMenu);
    }

    private void menuItemRemoved(BIMenu menu, BIMenuItem menuItem) {
        Menu fxMenu;
        if (menu == null || menuItem == null || menuItem.getText() == null) {
            return;
        }
        if (menu.isDynamic()) {
            return;
        }
        Arrays.stream(menuItem.asWidget().getSubscribers()).forEach(s -> s.unsubscribe((BComponent)menuItem.asWidget()));
        MenuItem fxMenuItem = this.menuItemsToFxMenuItems.remove(menuItem);
        if (fxMenuItem != null && fxMenuItem.getParentMenu() != null) {
            fxMenu = fxMenuItem.getParentMenu();
            fxMenu.getItems().removeAll((Object[])new MenuItem[]{fxMenuItem});
            this.clearMenuItem(fxMenuItem);
        } else {
            FilteredList matchingMenu;
            Property prop = menu.asWidget().getPropertyInParent();
            fxMenu = this.menus.get(prop);
            if (fxMenu == null && !(matchingMenu = this.fxMenuBar.getMenus().filtered(m -> m != null && m.getText().equals(menu.getText()))).isEmpty()) {
                fxMenu = (Menu)matchingMenu.get(0);
            }
            if (fxMenu == null) {
                return;
            }
            ObservableList menuItems = fxMenu.getItems();
            if (menuItems == null || menuItems.isEmpty()) {
                return;
            }
            FilteredList matchingMenuItems = menuItems.filtered(mi -> mi != null && mi.getText() != null && mi.getText().equals(menuItem.getText()));
            matchingMenuItems.forEach(this::clearMenuItem);
            menuItems.removeAll((Collection)matchingMenuItems);
        }
        this.removeConsecutiveSeparators(fxMenu);
    }

    private void mapMenuItems(BIMenu menu, Menu fxMenu) {
        MenuItem[] fxMenuitems = new MenuItem[menu.getItemCount()];
        int index = 0;
        for (MenuItem fxMenuItem : fxMenu.getItems()) {
            if (fxMenuItem instanceof SeparatorMenuItem) continue;
            if (index == fxMenuitems.length) break;
            fxMenuitems[index++] = fxMenuItem;
        }
        BIMenuItem[] menuItems = menu.getMenuItems();
        for (index = 0; index < menuItems.length; ++index) {
            this.menuItemsToFxMenuItems.put(menuItems[index], fxMenuitems[index]);
        }
    }

    private void removeConsecutiveSeparators(Menu menu) {
        ObservableList items = menu.getItems();
        Iterator it = items.iterator();
        while (it.hasNext()) {
            MenuItem item = (MenuItem)it.next();
            if (!(item instanceof SeparatorMenuItem)) continue;
            while (it.hasNext() && it.next() instanceof SeparatorMenuItem) {
                it.remove();
            }
        }
        if (!items.isEmpty()) {
            int size;
            if (items.get(0) instanceof SeparatorMenuItem) {
                items.remove(0);
            }
            if (items.get((size = items.size()) - 1) instanceof SeparatorMenuItem) {
                items.remove(size - 1);
            }
        }
    }

    private void clearMenu(Menu menu) {
        menu.setOnAction(null);
        menu.setOnMenuValidation(null);
    }

    private void clearMenuItem(MenuItem menuItem) {
        menuItem.setOnAction(null);
    }

    private void unmapMenuItems(BIMenu menu) {
        Arrays.stream(menu.getMenuItems()).map(this.menuItemsToFxMenuItems::remove).filter(Objects::nonNull).forEach(item -> this.clearMenuItem((MenuItem)item));
    }

    private void deregisterSubscribers(BIMenu menu) {
        Arrays.stream(menu.getMenuItems()).forEach(item -> Arrays.stream(item.asWidget().getSubscribers()).forEach(s -> s.unsubscribe((BComponent)item.asWidget())));
        Arrays.stream(menu.asWidget().getSubscribers()).forEach(s -> s.unsubscribe((BComponent)menu.asWidget()));
    }
}

