/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.table;

import com.tridium.ui.table.BPagedTable;
import com.tridium.ui.table.PagedTableModel;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="updateState", flags=4), @NiagaraAction(name="navigate", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()", flags=4)})
public class BPageNavigator
extends BWidget {
    @Generated
    public static final Action updateState = BPageNavigator.newAction((int)4, null);
    @Generated
    public static final Action navigate = BPageNavigator.newAction((int)4, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BPageNavigator.class);
    private static final Lexicon lex = UiLexicon.bajaui();
    protected BPagedTable table;
    private BBorderPane border;
    private FirstPageCommand firstPageCmd;
    private PrevPageCommand prevPageCmd;
    private NextPageCommand nextPageCmd;
    private LastPageCommand lastPageCmd;
    private BTextField currentPage;
    private BLabel totalPages;
    private BLabel rowInfo;

    @Generated
    public void updateState() {
        this.invoke(updateState, null, null);
    }

    @Generated
    public void navigate(BWidgetEvent parameter) {
        this.invoke(navigate, (BValue)parameter, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPageNavigator() {
        throw new IllegalStateException();
    }

    public BPageNavigator(BPagedTable table) {
        this.table = table;
        this.buildNavigator();
        this.linkTo(table, (Slot)BPagedTable.pageChanged, (Slot)updateState);
        this.linkTo(this.currentPage, (Slot)BTextField.actionPerformed, (Slot)navigate);
        this.linkTo(this.currentPage, (Slot)BTextField.cancelled, (Slot)updateState);
    }

    protected void buildNavigator() {
        this.border = new BBorderPane();
        BEdgePane edges = new BEdgePane();
        BFlowPane flow = new BFlowPane();
        flow.setAlign(BHalign.fill);
        this.firstPageCmd = new FirstPageCommand(this, this.table);
        flow.add("firstPage", (BValue)new BButton(this.firstPageCmd));
        this.prevPageCmd = new PrevPageCommand(this, this.table);
        flow.add("prevPage", (BValue)new BButton(this.prevPageCmd));
        this.currentPage = new BTextField("1", 4);
        flow.add("currentPage", (BValue)this.currentPage);
        this.totalPages = new BLabel(" / ?");
        flow.add("totalPages", (BValue)this.totalPages);
        this.nextPageCmd = new NextPageCommand(this, this.table);
        flow.add("nextPage", (BValue)new BButton(this.nextPageCmd));
        this.lastPageCmd = new LastPageCommand(this, this.table);
        flow.add("lastPage", (BValue)new BButton(this.lastPageCmd));
        this.rowInfo = new BLabel("");
        edges.setRight(this.rowInfo);
        edges.setCenter(flow);
        this.border.setContent(edges);
        this.add("pageNav", (BValue)this.border);
    }

    public void doNavigate(BWidgetEvent event) {
        try {
            this.table.gotoPage(BInteger.make((String)this.currentPage.getText()));
        }
        catch (Exception x) {
            this.updateState();
        }
    }

    public void doUpdateState() {
        PagedTableModel model = (PagedTableModel)this.table.getModel();
        int curPage = model.getCurrentPage();
        int lastPage = model.getPageCount();
        this.firstPageCmd.setEnabled(curPage != 1);
        this.prevPageCmd.setEnabled(curPage != 1);
        this.nextPageCmd.setEnabled(curPage != lastPage);
        this.lastPageCmd.setEnabled(curPage != lastPage);
        this.currentPage.setText(Integer.toString(curPage));
        this.totalPages.setText(" / " + Integer.toString(lastPage));
        int[] range = model.getRowRange();
        this.rowInfo.setText("Rows " + range[0] + " through " + range[1]);
        if (curPage > lastPage) {
            this.table.lastPage();
        }
    }

    @Override
    public void computePreferredSize() {
        this.border.computePreferredSize();
        this.setPreferredSize(this.border.getPreferredWidth(), this.border.getPreferredHeight());
    }

    @Override
    public void doLayout(BWidget[] kids) {
        this.border.setBounds(0.0, 0.0, this.getWidth(), this.getHeight());
        this.updateState();
    }

    @Override
    public void paint(Graphics g) {
        this.paintChildren(g);
    }

    private class LastPageCommand
    extends Command {
        private BPagedTable table;

        public LastPageCommand(BWidget owner, BPagedTable table) {
            super(owner, lex, "pageNav.lastPage");
            this.table = table;
        }

        @Override
        public CommandArtifact doInvoke() {
            this.table.lastPage();
            return null;
        }
    }

    private class NextPageCommand
    extends Command {
        private BPagedTable table;

        public NextPageCommand(BWidget owner, BPagedTable table) {
            super(owner, lex, "pageNav.nextPage");
            this.table = table;
        }

        @Override
        public CommandArtifact doInvoke() {
            this.table.nextPage();
            return null;
        }
    }

    private class PrevPageCommand
    extends Command {
        private BPagedTable table;

        public PrevPageCommand(BWidget owner, BPagedTable table) {
            super(owner, lex, "pageNav.prevPage");
            this.table = table;
        }

        @Override
        public CommandArtifact doInvoke() {
            this.table.previousPage();
            return null;
        }
    }

    private class FirstPageCommand
    extends Command {
        private BPagedTable table;

        public FirstPageCommand(BWidget owner, BPagedTable table) {
            super(owner, lex, "pageNav.firstPage");
            this.table = table;
        }

        @Override
        public CommandArtifact doInvoke() {
            this.table.firstPage();
            return null;
        }
    }
}

