/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.curium;

import com.tridium.ui.theme.TextFieldTheme;
import com.tridium.ui.theme.curium.CuriumTextEditorTheme;
import com.tridium.ui.theme.curium.CuriumThemeUtils;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import javax.baja.gx.BBrush;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.ui.BWidget;
import javax.baja.ui.style.IStylable;

public class CuriumTextFieldTheme
extends CuriumTextEditorTheme
implements TextFieldTheme {
    static BInsets insets = null;

    @Override
    public BInsets getInsets() {
        if (insets == null) {
            insets = CuriumThemeUtils.calcTextBoxInsets();
        }
        return insets;
    }

    @Override
    public void paintBorder(Graphics g, BWidget widget, double w, double h) {
        boolean enabled;
        boolean bl = enabled = widget.isEnabled() && widget.getParentWidget().isEnabled();
        if (enabled) {
            g.setBrush(this.getControlForeground());
        } else {
            g.setBrush(this.getControlShadow());
        }
        g.strokeRect(1.0, 1.0, w - 3.0, h - 3.0);
        if (enabled) {
            g.setBrush(this.getControlShadow());
        } else {
            g.setBrush(this.getControlAuxiliary());
        }
        g.strokeLine(0.0, 0.0, w - 1.0, 0.0);
        g.strokeLine(0.0, 0.0, 0.0, h - 1.0);
        g.setBrush(this.getControlHighlight());
        g.strokeLine(w - 1.0, 1.0, w - 1.0, h - 1.0);
        g.strokeLine(1.0, h - 1.0, w - 1.0, h - 1.0);
    }

    @Override
    public BBrush getControlForeground(IStylable widget) {
        return StyleUtils.hasStyle(widget, "readonly") ? super.getControlForeground(widget) : this.getWindowForeground(widget);
    }

    @Override
    public BBrush getControlBackground(IStylable widget) {
        return StyleUtils.hasStyle(widget, "readonly") ? super.getControlBackground(widget) : this.getWindowBackground(widget);
    }
}

