/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.curium;

import com.tridium.ui.theme.TreeTableTheme;
import com.tridium.ui.theme.curium.CuriumTableTheme;
import com.tridium.ui.theme.curium.CuriumTreeTheme;
import javax.baja.gx.BBrush;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;

public class CuriumTreeTableTheme
extends CuriumTableTheme
implements TreeTableTheme {
    static final double EXPANDER_WIDTH = 25.0;
    static final double EXPANDER_HEIGHT = 25.0;
    static final double INDENT = 31.0;

    @Override
    public BBrush getGroupBackground() {
        return CuriumTableTheme.gridBrush;
    }

    @Override
    public double getIndent(int depth) {
        return 3.0 + 31.0 * (double)depth;
    }

    @Override
    public double getExpanderWidth() {
        return 25.0;
    }

    @Override
    public double getExpanderHeight() {
        return 25.0;
    }

    @Override
    public void paintExpander(Graphics g, double x, double y, boolean selected, int state, boolean group) {
        BBrush origBrush = g.getBrush();
        if (selected) {
            g.setBrush(this.getSelectionForeground());
        } else if (group) {
            g.setBrush(CuriumTreeTheme.expanderBrush);
        } else {
            g.setBrush(CuriumTreeTheme.connectingBrush);
        }
        g.strokeLine(x, y, x + 25.0 - 1.0, y);
        g.strokeLine(x, y, x, y + 25.0 - 1.0);
        g.strokeLine(x + 25.0 - 1.0, y, x + 25.0 - 1.0, y + 25.0 - 1.0);
        g.strokeLine(x, y + 25.0 - 1.0, x + 25.0 - 1.0, y + 25.0 - 1.0);
        g.setBrush(selected ? this.getSelectionForeground() : CuriumTreeTheme.expanderBrush);
        if (state != 0) {
            g.strokeLine(x + 2.0, y + 4.0, x + 6.0, y + 4.0);
        }
        if (state == 1) {
            g.strokeLine(x + 4.0, y + 2.0, x + 4.0, y + 6.0);
        }
        g.setBrush(origBrush);
    }

    public void paintGroupBackground(Graphics g, RectGeom bounds) {
        g.setBrush(this.getControlBackground());
        g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
    }
}

