/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom;

import com.tridium.ui.theme.MenuTheme;
import com.tridium.ui.theme.custom.CustomWidgetTheme;
import com.tridium.ui.theme.custom.nss.NSS;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.ui.BMenu;

public class CustomMenuTheme
extends CustomWidgetTheme
implements MenuTheme {
    private BInsets insets;

    public CustomMenuTheme() {
        NSS nss = CustomMenuTheme.getNSS();
        NSS menu = nss.selectNode("menu");
        this.regFallbackValue(menu, "insets", "padding", "3");
    }

    @Override
    String getNSSSelector() {
        return "menu";
    }

    @Override
    public BInsets getInsets() {
        return this.insets;
    }

    public void setInsets(BInsets insets) {
        this.insets = insets;
    }

    @Override
    public void paintBackground(Graphics g, BMenu m) {
        g.setBrush(this.getControlForeground(m));
        g.strokeRect(0.0, 0.0, m.getWidth() - 1.0, m.getHeight() - 1.0);
        g.setBrush(this.getControlBackground(m));
        g.fillRect(1.0, 1.0, m.getWidth() - 2.0, m.getHeight() - 2.0);
        g.setBrush(this.getControlHighlight(m));
        g.strokeLine(1.0, 1.0, m.getWidth() - 3.0, 1.0);
        g.strokeLine(1.0, 1.0, 1.0, m.getHeight() - 3.0);
        g.setBrush(this.getControlShadow(m));
        g.strokeLine(m.getWidth() - 2.0, 1.0, m.getWidth() - 2.0, m.getHeight() - 2.0);
        g.strokeLine(1.0, m.getHeight() - 2.0, m.getWidth() - 2.0, m.getHeight() - 2.0);
    }

    @Override
    public float getFrameOpacity() {
        String opacity = (String)CustomMenuTheme.getNSS().select("menu opacity");
        if (opacity != null) {
            return Float.parseFloat(opacity);
        }
        return 1.0f;
    }
}

