/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom;

import com.tridium.ui.theme.TreeTableTheme;
import com.tridium.ui.theme.custom.CustomTableTheme;
import com.tridium.ui.theme.custom.nss.NSS;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;

public class CustomTreeTableTheme
extends CustomTableTheme
implements TreeTableTheme {
    private BBrush expanderBrush = BColor.black.toBrush();
    private BBrush connectingBrush = BColor.make((int)192, (int)192, (int)192).toBrush();
    private double expanderWidth = 17.0;
    private double expanderHeight = 17.0;
    private double indent = this.expanderWidth + 6.0;

    public CustomTreeTableTheme() {
        NSS nss = CustomTreeTableTheme.getNSS();
        NSS treeTable = nss.selectNode("table tree-table");
        NSS expander = treeTable.selectNode("expander");
        this.regFallbackValue(expander, "expanderBrush", "color", "#000");
        this.regFallbackValue(expander, "expanderWidth", "width", "9");
        this.regFallbackValue(expander, "expanderHeight", "height", "9");
        this.regFallbackValue(treeTable, "connectingBrush", "connector-color", "#ccc");
    }

    @Override
    String getNSSSelector() {
        return "table tree-table";
    }

    @Override
    public BBrush getGroupBackground() {
        return this.getGridBrush();
    }

    public BBrush getConnectingBrush() {
        return this.connectingBrush;
    }

    public void setConnectingBrush(BBrush cb) {
        this.connectingBrush = cb;
    }

    public BBrush getExpanderBrush() {
        return this.expanderBrush;
    }

    public void setExpanderBrush(BBrush eb) {
        this.expanderBrush = eb;
    }

    @Override
    public double getIndent(int depth) {
        return 3.0 + this.indent * (double)depth;
    }

    @Override
    public double getExpanderHeight() {
        return this.expanderHeight;
    }

    public void setExpanderHeight(double eh) {
        this.expanderHeight = eh;
    }

    @Override
    public double getExpanderWidth() {
        return this.expanderWidth;
    }

    public void setExpanderWidth(double ew) {
        this.expanderWidth = ew;
    }

    @Override
    public void paintExpander(Graphics g, double x, double y, boolean selected, int state, boolean group) {
        BBrush origBrush = g.getBrush();
        if (selected) {
            g.setBrush(this.getSelectionForeground());
        } else if (group) {
            g.setBrush(this.expanderBrush);
        } else {
            g.setBrush(this.connectingBrush);
        }
        g.strokeLine(x, y, x + this.expanderWidth - 1.0, y);
        g.strokeLine(x, y, x, y + this.expanderHeight - 1.0);
        g.strokeLine(x + this.expanderWidth - 1.0, y, x + this.expanderWidth - 1.0, y + this.expanderHeight - 1.0);
        g.strokeLine(x, y + this.expanderHeight - 1.0, x + this.expanderWidth - 1.0, y + this.expanderHeight - 1.0);
        g.setBrush(selected ? this.getSelectionForeground() : this.expanderBrush);
        if (state != 0) {
            g.strokeLine(x + 2.0, y + 4.0, x + 6.0, y + 4.0);
        }
        if (state == 1) {
            g.strokeLine(x + 4.0, y + 2.0, x + 4.0, y + 6.0);
        }
        g.setBrush(origBrush);
    }

    public void paintGroupBackground(Graphics g, RectGeom bounds) {
        g.setBrush(this.getControlBackground());
        g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
    }
}

