/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom;

import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.TreeTheme;
import com.tridium.ui.theme.custom.CustomWidgetTheme;
import com.tridium.ui.theme.custom.nss.NSS;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.RectGeom;
import javax.baja.sys.BIcon;
import javax.baja.ui.BWidget;

public class CustomTreeTheme
extends CustomWidgetTheme
implements TreeTheme {
    private double expanderWidth;
    private double expanderHeight;
    private BInsets insets;

    public CustomTreeTheme() {
        NSS nss = CustomTreeTheme.getNSS();
        NSS tree = nss.selectNode("tree");
        this.regFallbackValue(tree, "insets", "padding", "2 4");
        NSS expander = tree.selectNode("expander");
        this.regFallbackValue(expander, "expanderWidth", "width", "9");
        this.regFallbackValue(expander, "expanderHeight", "height", "9");
    }

    @Override
    String getNSSSelector() {
        return "tree";
    }

    @Override
    public BFont getFont(BWidget tree) {
        return this.getTextFont(tree);
    }

    @Override
    public BBrush getForeground(BWidget tree) {
        return this.getTextBrush(tree);
    }

    @Override
    public BBrush getBackground(BWidget tree) {
        return this.getControlBackground(tree);
    }

    @Override
    public BBrush getConnectingBrush(BWidget tree) {
        BBrush brush = (BBrush)this.select(tree, "connector-color");
        if (brush == null) {
            return this.getWindowForeground(tree);
        }
        return brush;
    }

    public BBrush getExpanderBrush(BWidget tree) {
        return (BBrush)this.select(tree, "expander color");
    }

    @Override
    public BInsets getInsets() {
        return this.insets;
    }

    public void setInsets(BInsets insets) {
        this.insets = insets;
    }

    @Override
    public BInsets getInsets(BWidget widget) {
        return (BInsets)this.select(widget, "padding");
    }

    @Override
    public double getExpanderHeight() {
        return this.expanderHeight;
    }

    public void setExpanderHeight(double eh) {
        this.expanderHeight = eh;
    }

    @Override
    public double getExpanderWidth() {
        return this.expanderWidth;
    }

    public void setExpanderWidth(double ew) {
        this.expanderWidth = ew;
    }

    @Override
    public boolean inExpander(double expX, double expY, double x, double y) {
        return x >= expX && x <= expX + this.expanderWidth && y >= expY && y <= expY + this.expanderHeight;
    }

    @Override
    public void paintExpander(Graphics g, BWidget tree, double x, double y, boolean expanded) {
        BImage expander = BImage.make((BIcon)BIcon.std((String)(expanded ? "navTreeDownArrow.png" : "navTreeSideArrow.png")));
        g.drawImage(expander, x, y);
    }

    @Override
    public void paintExpander(Graphics g, BWidget tree, double x, double y, boolean isExpandable, boolean isExpanded) {
        this.paintExpander(g, tree, x, y, isExpanded);
    }

    @Override
    public void paintFocus(Graphics g, RectGeom bounds) {
        g.setBrush(Theme.tree().getSelectionBackground());
        g.fill((IGeom)bounds);
    }
}

