/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom.nss;

import com.tridium.ui.theme.custom.CustomWidgetTheme;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;

public class NSSUtils {
    static final Logger logger = Logger.getLogger("com.tridium.ui.theme.custom.nss");
    private static boolean increaseFontSize;

    public static void setIncreaseFontSize(boolean increaseFontSize) {
        NSSUtils.increaseFontSize = increaseFontSize;
    }

    public static boolean setThemeProperty(CustomWidgetTheme theme, String propertyName, Object value) {
        Method[] methods = theme.getClass().getMethods();
        Method targetMethod = null;
        for (int i = 0; i < methods.length; ++i) {
            String prop;
            Method method = methods[i];
            if (!method.getName().startsWith("set") || !NSSUtils.decapitalize(prop = method.getName().substring(3)).equals(propertyName) || method.getParameterTypes().length != 1) continue;
            targetMethod = method;
            break;
        }
        if (targetMethod != null && targetMethod.getParameterTypes().length == 1) {
            Class<?> targetClass = targetMethod.getParameterTypes()[0];
            Object result = NSSUtils.makeResult(targetClass, theme, value);
            if (result != null) {
                try {
                    targetMethod.invoke((Object)theme, result);
                    return true;
                }
                catch (Exception e) {
                    logger.severe("Error invoking theme set method. \nTarget class " + theme.getClass().getName() + "\nTarget method " + targetMethod.getName() + "\nParameter " + result);
                    e.printStackTrace();
                }
            }
        } else {
            logger.severe(propertyName + " does not have a valid setter on " + theme.getClass().getName());
        }
        return false;
    }

    private static String decapitalize(String name) {
        if (name == null) {
            return null;
        }
        if (name.length() == 0 || name.length() > 1 && Character.isUpperCase(name.charAt(1))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private static Object makeResult(Class<?> clazz, CustomWidgetTheme theme, Object value) {
        if (!(value instanceof String)) {
            return value;
        }
        String s = (String)value;
        if (clazz == BFont.class) {
            return NSSUtils.makeFont(s);
        }
        if (clazz == BBrush.class) {
            return NSSUtils.makeBrush(s);
        }
        if (clazz == BInsets.class) {
            return NSSUtils.makeInsets(s);
        }
        if (clazz == BImage.class) {
            return NSSUtils.makeImage(s);
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return NSSUtils.makeInteger(s);
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return NSSUtils.makeDouble(s);
        }
        if (clazz == String.class) {
            return s;
        }
        return value;
    }

    private static BFont makeFont(String value) {
        if ("none".equals(value)) {
            return BFont.NULL;
        }
        BFont f = BFont.make((String)value);
        return increaseFontSize ? BFont.make((String)f.getName(), (double)(f.getSize() + 4.0), (int)f.getStyle()) : f;
    }

    private static BBrush makeBrush(String value) {
        return "none".equals(value) ? BColor.transparent.toBrush() : BBrush.make((String)value);
    }

    private static BInsets makeInsets(String value) {
        return "none".equals(value) ? BInsets.make((String)"0") : BInsets.make((String)value);
    }

    private static BImage makeImage(String value) {
        return "none".equals(value) ? BImage.DEFAULT : BImage.make((String)value);
    }

    private static Integer makeInteger(String value) {
        return Integer.valueOf(value);
    }

    private static Double makeDouble(String value) {
        return Double.valueOf(value);
    }

    public static Object makeValueByTag(String tagName, Object value) {
        if (!(value instanceof String)) {
            return value;
        }
        String s = (String)value;
        if (tagName.endsWith("color") || tagName.endsWith("outline") || tagName.endsWith("shadow") || tagName.endsWith("highlight")) {
            return NSSUtils.makeBrush(s);
        }
        if (tagName.endsWith("font")) {
            double w2;
            double w1;
            BFont font = NSSUtils.makeFont(s);
            if (tagName.startsWith("fixed") && (w1 = font.width(".")) != (w2 = font.width("m"))) {
                logger.warning(tagName + " was not a fixed-width font. Reverting to monospaced.");
                font = BFont.make((String)"monospaced", (double)font.getSize(), (int)font.getStyle());
            }
            return font;
        }
        if (tagName.endsWith("padding")) {
            return NSSUtils.makeInsets(s);
        }
        if (tagName.endsWith("image")) {
            return NSSUtils.makeImage(s);
        }
        if (tagName.endsWith("width") || tagName.endsWith("height") || tagName.endsWith("radius")) {
            return NSSUtils.makeDouble(s);
        }
        return value;
    }
}

