/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom.nss.selector;

import com.tridium.ui.theme.custom.nss.NSS;
import com.tridium.ui.theme.custom.nss.NSSException;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import com.tridium.ui.theme.custom.nss.selector.NSSPath;
import java.util.ArrayList;
import java.util.List;
import javax.baja.ui.style.IStylable;

public class NSSSelector {
    private List<String> styleClasses;
    private String styleId;
    private String tag;
    private Object result;
    private int foundBy = -1;
    private NSSPath path;
    private static final int BY_ID = 2;
    private static final int BY_CLASS = 1;
    private static final int BY_TAG = 0;

    public NSSSelector(String selectorString) {
        this.path = new NSSPath(selectorString);
        this.styleClasses = this.getStyleClassList(this.path);
        this.styleId = this.getStyleId(this.path);
        this.tag = this.path.getName();
    }

    public NSSSelector(IStylable widget, String widgetSelector, String propertySelector) {
        this((widgetSelector == null ? "" : widgetSelector) + " " + propertySelector);
        this.styleClasses = this.getStyleClassList(widget);
        this.styleClasses.addAll(this.getStyleClassList(this.path));
        this.styleId = widget.getStyleId();
        this.tag = this.path.getName();
    }

    public Object select(NSS nss) {
        Object result = this.selectForward(nss, this.path);
        if (result == null) {
            result = this.selectBackward(nss, this.path.getName());
        }
        return result;
    }

    private Object selectBackward(NSS nss, String tag) {
        Object result = null;
        while (result == null && nss != null) {
            result = this.doSelectWithClassAndId(nss, tag);
            nss = nss.getParent();
        }
        return result;
    }

    private Object selectForward(NSS nss, NSSPath path) {
        if (nss == null) {
            return this.result;
        }
        Object curr = this.doSelectWithClassAndId(nss, this.tag);
        if (curr != null) {
            this.result = curr;
        }
        if (path.size() == 0) {
            return this.result;
        }
        Object o = nss.get(path.getHead());
        if (o instanceof NSS) {
            path = path.removeHead();
            return this.selectForward((NSS)o, path);
        }
        return this.result;
    }

    public NSS selectNode(NSS nss) {
        Object value = this.select(nss);
        if (value instanceof NSS) {
            return (NSS)value;
        }
        return nss;
    }

    public Object selectProperty(NSS nss) {
        Object o = this.select(nss);
        return this.convertToProperty(o);
    }

    private Object convertToProperty(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof NSS) {
            throw new NSSException("NSS selector '" + this.path + "' references an NSS node, not a property.");
        }
        return obj;
    }

    private Object doSelectStrict(NSS nss, NSSPath path) {
        Object o = this.doSelectWithClassAndId(nss, path.getHead());
        if (path.size() == 0) {
            return o;
        }
        if (o instanceof NSS) {
            path = path.removeHead();
            return this.doSelectStrict((NSS)o, path);
        }
        return null;
    }

    public Object selectStrict(NSS nss) {
        return this.doSelectStrict(nss, this.path);
    }

    private List<String> getStyleClassList(IStylable widget) {
        List<String> styleClasses = StyleUtils.toStyleClassList(widget.getStyleClasses());
        styleClasses.addAll(StyleUtils.getAutoClasses(widget));
        return styleClasses;
    }

    private List<String> getStyleClassList(NSSPath path) {
        ArrayList<String> styleClasses = new ArrayList<String>();
        for (int i = 0; i < path.size(); ++i) {
            String tag = path.get(i);
            if (tag.charAt(0) != '.') continue;
            styleClasses.add(tag.substring(1));
        }
        return styleClasses;
    }

    private String getStyleId(NSSPath path) {
        for (int i = 0; i < path.size(); ++i) {
            String tag = path.get(i);
            if (tag.charAt(0) != '#') continue;
            return tag.substring(1);
        }
        return null;
    }

    private Object doSelectWithClassAndId(NSS node, String tag) {
        return this.getFromNode(node, tag, true);
    }

    private Object getFromNode(NSS node, String tagName, boolean useSpecificity) {
        Object result = null;
        NSS idNode = this.getIdNode(node);
        if (idNode != null) {
            result = idNode.get(tagName);
            this.foundBy = 2;
        }
        if (!(result != null || this.foundBy >= 2 && useSpecificity)) {
            List<NSS> classNodes = this.getClassNodes(node);
            for (int i = 0; i < classNodes.size() && result == null; ++i) {
                Object o = this.getFromNode(classNodes.get(i), tagName, false);
                if (o == null) continue;
                result = o;
                this.foundBy = 1;
            }
        }
        if (!(result != null || this.foundBy >= 1 && useSpecificity)) {
            result = node.get(tagName);
            this.foundBy = 0;
        }
        return result;
    }

    private NSS getIdNode(NSS node) {
        Object o;
        if (this.styleId != null && (o = node.get("#" + this.styleId)) instanceof NSS) {
            return (NSS)o;
        }
        return null;
    }

    private List<NSS> getClassNodes(NSS node) {
        ArrayList<NSS> classNodes = new ArrayList<NSS>();
        for (int i = 0; i < this.styleClasses.size(); ++i) {
            Object o = node.get("." + this.styleClasses.get(i));
            if (!(o instanceof NSS)) continue;
            classNodes.add((NSS)o);
        }
        return classNodes;
    }
}

