/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.palladium;

import com.tridium.ui.theme.CheckBoxTheme;
import com.tridium.ui.theme.palladium.PalladiumToggleButtonTheme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.IInsets;
import javax.baja.gx.IPoint;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BToggleButton;

public class PalladiumCheckBoxTheme
extends PalladiumToggleButtonTheme
implements CheckBoxTheme {
    static final int CB_SIZE = 13;
    static BInsets padding = BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)18.0);

    @Override
    public IInsets getPadding(BAbstractButton b) {
        return padding;
    }

    @Override
    public BFont getTextFont() {
        return this.getPlainText();
    }

    @Override
    public IPoint getLabelOffset(BAbstractButton button) {
        return noOffset;
    }

    @Override
    public int getCheckBoxSize() {
        return 13;
    }

    @Override
    public void paintBackground(Graphics g, BAbstractButton b) {
        boolean mouseOver = b.isMouseOver();
        boolean pressed = b.isPressed();
        boolean enabled = b.getEnabled();
        boolean selected = ((BToggleButton)b).isSelected();
        BBrush bg = b.getBackground();
        if (!bg.isNull()) {
            g.setBrush(bg);
            g.fillRect(0.0, 0.0, b.getWidth(), b.getHeight());
        }
        double x = 0.0;
        double y = b.getHeight() / 2.0 - 6.0;
        double w = 12.0;
        double h = 12.0;
        g.setBrush(this.getControlBackground());
        g.fillRect(x, y, w, h);
        if (enabled) {
            g.setBrush(this.getControlForeground());
        } else {
            g.setBrush(this.getControlShadow());
        }
        g.strokeRect(x, y, w, h);
        if (pressed && mouseOver) {
            g.setBrush(this.getControlShadow());
        } else {
            g.setBrush(this.getControlHighlight());
        }
        g.strokeLine(x + 1.0, y + 1.0, x + w - 2.0, y + 1.0);
        g.strokeLine(x + 1.0, y + 1.0, x + 1.0, y + h - 2.0);
        if (enabled) {
            g.setBrush(this.getControlShadow());
        } else {
            g.setBrush(this.getControlAuxiliary());
        }
        g.strokeLine(x + w - 1.0, y + 1.0, x + w - 1.0, y + h - 1.0);
        g.strokeLine(x + 1.0, y + h - 1.0, x + w - 1.0, y + h - 1.0);
        if (selected) {
            x = w / 2.0 - 4.0;
            y = b.getHeight() / 2.0;
            if (enabled) {
                g.setBrush(this.getControlForeground());
            } else {
                g.setBrush(this.getControlShadow());
            }
            g.strokeLine(x, y, x + 1.0, y - 1.0);
            g.strokeLine(x + 1.0, y + 1.0, x + 6.0, y - 4.0);
            g.strokeLine(x + 2.0, y + 2.0, x + 7.0, y - 3.0);
            g.strokeLine(x + 1.0, y, x + 2.0, y + 1.0);
            g.strokeLine(x + 2.0, y + 1.0, x + 6.0, y - 3.0);
            g.setBrush(this.getControlAuxiliary());
            g.strokeLine(x + 3.0, y + 2.0, x + 7.0, y - 2.0);
            g.strokeLine(x + 3.0, y + 3.0, x + 8.0, y - 2.0);
        }
        if (b.hasFocus() && b.isFocusTraversable() && b.getText() != null && b.getText().length() > 0) {
            x = PalladiumCheckBoxTheme.padding.left - 2.0;
            y = PalladiumCheckBoxTheme.padding.top;
            w = b.getWidth() - (x + PalladiumCheckBoxTheme.padding.right);
            h = b.getHeight() - (y + PalladiumCheckBoxTheme.padding.bottom);
            this.paintFocus(g, new RectGeom(x, y, w, h));
        }
    }
}

