/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.ui.BOptionDialog;
import com.tridium.ui.DialogPeer;
import com.tridium.ui.ShellPeer;
import com.tridium.ui.UiEnv;
import com.tridium.util.ThrowableUtil;
import java.util.function.Consumer;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Localizable;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWindow;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;

@NiagaraType
public class BDialog
extends BWindow {
    @Generated
    public static final Type TYPE = Sys.loadType(BDialog.class);
    public static final int OK = 1;
    public static final int CANCEL = 2;
    public static final int YES = 4;
    public static final int NO = 8;
    public static final int YES_NO = 12;
    public static final int OK_CANCEL = 3;
    public static final BImage QUESTION_ICON = BImage.make((String)"module://icons/x32/question.png");
    public static final BImage INFO_ICON = BImage.make((String)"module://icons/x32/info.png");
    public static final BImage WARNING_ICON = BImage.make((String)"module://icons/x32/warning.png");
    public static final BImage ERROR_ICON = BImage.make((String)"module://icons/x32/error.png");
    public static final String TITLE_CONFIRM = UiLexicon.bajaui().getText("dialog.confirm");
    public static final String TITLE_MESSAGE = UiLexicon.bajaui().getText("dialog.message");
    public static final String TITLE_INFO = UiLexicon.bajaui().getText("dialog.info");
    public static final String TITLE_WARNING = UiLexicon.bajaui().getText("dialog.warning");
    public static final String TITLE_ERROR = UiLexicon.bajaui().getText("dialog.error");
    private static final BIcon icon = BIcon.std((String)"widgets/dialog.png");
    private BWidget owner;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public static int confirm(BWidget parent, String title, Object message) {
        return BDialog.open(parent, title, message, 12, QUESTION_ICON, (String)null);
    }

    public static int confirm(BWidget parent, Object message) {
        return BDialog.open(parent, TITLE_CONFIRM, message, 12, QUESTION_ICON, (String)null);
    }

    public static int confirm(BWidget parent, String title, Object message, int buttons) {
        return BDialog.open(parent, title, message, buttons, QUESTION_ICON, (String)null);
    }

    public static int message(BWidget parent, String title, Object message) {
        return BDialog.open(parent, title, message, 1, null, (String)null);
    }

    public static int message(BWidget parent, Object message) {
        return BDialog.open(parent, TITLE_MESSAGE, message, 1, null, (String)null);
    }

    public static int info(BWidget parent, String title, Object message) {
        return BDialog.open(parent, title, message, 1, INFO_ICON, (String)null);
    }

    public static int info(BWidget parent, Object message) {
        return BDialog.open(parent, TITLE_INFO, message, 1, INFO_ICON, (String)null);
    }

    public static int warning(BWidget parent, String title, Object message) {
        return BDialog.open(parent, title, message, 1, WARNING_ICON, (String)null);
    }

    public static int warning(BWidget parent, String title, Object message, String details) {
        return BDialog.open(parent, title, message, 1, WARNING_ICON, details);
    }

    public static int warning(BWidget parent, String title, Object message, Throwable details) {
        return BDialog.open(parent, title, message, 1, WARNING_ICON, details);
    }

    public static int error(BWidget parent, Object message) {
        return BDialog.open(parent, TITLE_ERROR, message, 1, ERROR_ICON, (String)null);
    }

    public static int error(BWidget parent, String title, Object message) {
        return BDialog.open(parent, title, message, 1, ERROR_ICON, (String)null);
    }

    public static int error(BWidget parent, String title, Object message, String details) {
        return BDialog.open(parent, title, message, 1, ERROR_ICON, details);
    }

    public static int error(BWidget parent, String title, Object message, Throwable details) {
        return BDialog.open(parent, title, message, 1, ERROR_ICON, details);
    }

    public static String prompt(BWidget parent, String title, String value, int fieldLength) {
        BTextField field = new BTextField(value, fieldLength);
        int result = BDialog.open(parent, title, field, 3, QUESTION_ICON);
        if (result == 2) {
            return null;
        }
        return field.getText();
    }

    public static int open(BWidget parent, String title, Object content, int buttons) {
        return BDialog.open(parent, title, content, buttons, null, (String)null);
    }

    public static int open(BWidget parent, String title, Object content, int buttons, BImage icon) {
        return BDialog.open(parent, title, content, buttons, icon, (String)null);
    }

    public static int open(BWidget parent, String title, Object content, int buttons, BImage icon, Throwable details) {
        String strDetails = null;
        if (details != null) {
            strDetails = ThrowableUtil.dumpToString((Throwable)details);
            Localizable localizable = ThrowableUtil.toLocalizable((Throwable)details);
            if (localizable != null) {
                String detailSummary = localizable.toString(null);
                if (content instanceof String) {
                    content = new BLabel((String)content, BHalign.left);
                }
                if (content instanceof BLabel) {
                    BGridPane pane = new BGridPane(1);
                    pane.setHalign(BHalign.left);
                    pane.add(null, (BValue)((BWidget)content));
                    if (detailSummary != null) {
                        String currentText;
                        String string = currentText = ((BLabel)content).getText() == null ? BLabel.text.getDefaultValue().toString() : ((BLabel)content).getText();
                        if (!currentText.contains(detailSummary)) {
                            pane.add(null, (BValue)new BLabel(detailSummary, BHalign.left));
                        }
                    }
                    content = pane;
                }
            }
        }
        try {
            return BDialog.open(parent, title, content, buttons, icon, strDetails);
        }
        catch (IllegalArgumentException e) {
            System.out.println("ERROR: BDialog.open: " + e);
            if (details != null) {
                details.printStackTrace();
            }
            throw e;
        }
    }

    public static int open(BWidget parent, String title, Object content, int buttons, BImage icon, String details) {
        return BDialog.open(parent, title, content, buttons, icon, details, null);
    }

    public static int open(BWidget parent, String title, Object content, int buttons, BImage icon, String details, Consumer<BDialog> dialogConsumer) {
        BWidget w;
        BOptionDialog dialog = BDialog.make(parent, title, content, buttons, icon, details);
        dialog.setBoundsCenteredOnOwner();
        if (dialogConsumer != null) {
            dialogConsumer.accept(dialog);
        }
        dialog.open();
        if (dialog.getResult() == 0 && dialog.isShowing()) {
            dialog.close(2);
        }
        if (content instanceof BWidget && (w = (BWidget)content).getPropertyInParent() != null) {
            BWidget wp = w.getParentWidget();
            wp.set(w.getPropertyInParent(), (BValue)new BNullWidget());
        }
        return dialog.getResult();
    }

    private static BOptionDialog make(BWidget parent, String title, Object content, int buttons, BImage icon, String details) {
        BWidget c = null;
        c = content instanceof BWidget ? (BWidget)content : new BLabel(String.valueOf(content), BHalign.left);
        return new BOptionDialog(parent, title, c, buttons, icon, details);
    }

    public BDialog(BWidget owner, String title, boolean modal, BWidget content) {
        super(UiEnv.get().makeDialogPeer(owner, title, modal));
        this.setContent(content);
        this.owner = owner;
    }

    public BDialog(BWidget owner, String title, boolean modal) {
        super(UiEnv.get().makeDialogPeer(owner, title, modal));
        this.owner = owner;
    }

    public BDialog() {
        super(UiEnv.get().makeDialogPeer(null, "", false));
        this.owner = null;
    }

    public BWidget getOwner() {
        return this.owner;
    }

    public String getTitle() {
        return ((DialogPeer)this.getShellPeer()).getTitle();
    }

    public void setTitle(String title) {
        ((DialogPeer)this.getShellPeer()).setTitle(title);
    }

    public boolean isModal() {
        return ((DialogPeer)this.getShellPeer()).isModal();
    }

    public void setModal(boolean modal) {
        ((DialogPeer)this.getShellPeer()).setModal(modal);
    }

    public boolean isResizable() {
        return ((DialogPeer)this.getShellPeer()).isResizable();
    }

    public void setResizable(boolean resizable) {
        ((DialogPeer)this.getShellPeer()).setResizable(resizable);
    }

    @Override
    public void handleEscape() {
        this.windowClosing(null);
    }

    @Override
    public void windowClosing(BWindowEvent event) {
        this.close();
    }

    public void setBoundsCenteredOnOwner() {
        try {
            ShellPeer peer = this.getOwner().getShell().getShellPeer();
            this.setBoundsCenteredOn(peer.getScreenBounds());
        }
        catch (RuntimeException e) {
            this.setBoundsCenteredOnScreen();
        }
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }
}

