/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraTopics;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="displayWidget", type="BWidget", defaultValue="new BNullWidget()"), @NiagaraProperty(name="dropDownWidget", type="BWidget", defaultValue="new BNullWidget()"), @NiagaraProperty(name="dropDownEnabled", type="boolean", defaultValue="true")})
@NiagaraActions(value={@NiagaraAction(name="openDropDown"), @NiagaraAction(name="closeDropDown")})
@NiagaraTopics(value={@NiagaraTopic(name="valueModified", eventType="BWidgetEvent"), @NiagaraTopic(name="actionPerformed", eventType="BWidgetEvent")})
public class BDropDown
extends BWidget {
    @Generated
    public static final Property displayWidget = BDropDown.newProperty((int)0, (BValue)new BNullWidget(), null);
    @Generated
    public static final Property dropDownWidget = BDropDown.newProperty((int)0, (BValue)new BNullWidget(), null);
    @Generated
    public static final Property dropDownEnabled = BDropDown.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Action openDropDown = BDropDown.newAction((int)0, null);
    @Generated
    public static final Action closeDropDown = BDropDown.newAction((int)0, null);
    @Generated
    public static final Topic valueModified = BDropDown.newTopic((int)0, null);
    @Generated
    public static final Topic actionPerformed = BDropDown.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDropDown.class);
    private static final BIcon icon = BIcon.std((String)"widgets/comboBox.png");
    private RectGeom buttonBounds = new RectGeom();

    @Generated
    public BWidget getDisplayWidget() {
        return (BWidget)this.get(displayWidget);
    }

    @Generated
    public void setDisplayWidget(BWidget v) {
        this.set(displayWidget, (BValue)v, null);
    }

    @Generated
    public BWidget getDropDownWidget() {
        return (BWidget)this.get(dropDownWidget);
    }

    @Generated
    public void setDropDownWidget(BWidget v) {
        this.set(dropDownWidget, (BValue)v, null);
    }

    @Generated
    public boolean getDropDownEnabled() {
        return this.getBoolean(dropDownEnabled);
    }

    @Generated
    public void setDropDownEnabled(boolean v) {
        this.setBoolean(dropDownEnabled, v, null);
    }

    @Generated
    public void openDropDown() {
        this.invoke(openDropDown, null, null);
    }

    @Generated
    public void closeDropDown() {
        this.invoke(closeDropDown, null, null);
    }

    @Generated
    public void fireValueModified(BWidgetEvent event) {
        this.fire(valueModified, (BValue)event, null);
    }

    @Generated
    public void fireActionPerformed(BWidgetEvent event) {
        this.fire(actionPerformed, (BValue)event, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDropDown(BWidget displayWidget, BWidget dropDownWidget) {
        this.setDisplayWidget(displayWidget);
        this.setDropDownWidget(dropDownWidget);
    }

    public BDropDown() {
    }

    @Override
    public void changed(Property prop, Context context) {
        if (prop == dropDownEnabled) {
            BWidget widget = this.getDropDownWidget();
            if (widget != null && !widget.isNull()) {
                StyleUtils.toggleStyleClass(widget, "readonly", !this.getBoolean(dropDownEnabled));
            }
            if ((widget = this.getDisplayWidget()) != null && !widget.isNull()) {
                StyleUtils.toggleStyleClass(widget, "readonly", !this.getBoolean(dropDownEnabled));
            }
        }
        this.relayout();
    }

    @Override
    public void computePreferredSize() {
        BWidget display = this.getDisplayWidget();
        display.computePreferredSize();
        double pw = display.getPreferredWidth();
        double ph = display.getPreferredHeight();
        BInsets insets = this.getBorderInsets();
        pw += insets.left + insets.right;
        ph += insets.top + insets.bottom;
        if (this.getDropDownEnabled()) {
            pw += ph;
        }
        this.setPreferredSize(pw, ph);
    }

    @Override
    public void doLayout(BWidget[] kids) {
        double w = this.getWidth();
        double h = this.getHeight();
        BWidget display = this.getDisplayWidget();
        display.computePreferredSize();
        BInsets insets = this.getBorderInsets();
        if (this.getDropDownEnabled()) {
            double ph = Math.min(h - insets.top - insets.right, display.getPreferredHeight());
            this.buttonBounds.width = Math.min(ph, 16.0);
            this.buttonBounds.height = h - insets.top - insets.right;
            this.buttonBounds.x = w - insets.right - this.buttonBounds.width;
            this.buttonBounds.y = insets.top;
        } else {
            this.buttonBounds.x = 0.0;
            this.buttonBounds.y = 0.0;
            this.buttonBounds.width = 0.0;
            this.buttonBounds.height = 0.0;
        }
        double dw = w - insets.left - insets.right - this.buttonBounds.width;
        double dh = h - insets.top - insets.bottom;
        display.setBounds(insets.left, insets.right, dw, dh);
        if (!this.isDropDownOpen()) {
            BWidget dropDown = this.getDropDownWidget();
            dropDown.setBounds(0.0, h, 0.0, 0.0);
        }
    }

    public BInsets getBorderInsets() {
        return Theme.dropDown().getBorderInsets();
    }

    @Override
    public void setEnabled(boolean v) {
        super.setEnabled(v);
        this.getDisplayWidget().setEnabled(v);
        this.setDropDownEnabled(v);
    }

    @Override
    public void paint(Graphics g) {
        this.paintChild(g, this.getDisplayWidget());
        this.paintBorder(g);
        if (this.getDropDownEnabled()) {
            this.paintButton(g);
        }
    }

    void paintBorder(Graphics g) {
        Theme.dropDown().paintBorder(g, this);
    }

    void paintButton(Graphics g) {
        Theme.dropDown().paintButton(g, this, this.buttonBounds, this.isDropDownOpen());
    }

    @Override
    public String getStyleSelector() {
        return "drop-down";
    }

    public boolean isDropDownOpen() {
        return UiEnv.get().isPopupOpen(this.getDropDownWidget());
    }

    public void doCloseDropDown() {
        UiEnv.get().closePopup(null);
        this.repaint();
    }

    public void doOpenDropDown() {
        if (!this.getDropDownEnabled()) {
            return;
        }
        if (this.isDropDownOpen()) {
            return;
        }
        BWidget dropDown = this.getDropDownWidget();
        int fixedHeight = -1;
        dropDown.computePreferredSize();
        double width = Math.max(this.getWidth(), dropDown.getPreferredWidth());
        double ph = dropDown.getPreferredHeight();
        if (ph > 300.0) {
            fixedHeight = 308;
        }
        UiEnv.get().openPopup(dropDown, this, 0.0, this.getHeight(), width, fixedHeight);
        this.repaint();
    }

    @Override
    public void mousePressed(BMouseEvent event) {
        this.openDropDown();
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }
}

