/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.util.ThrowableUtil;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.baja.gx.BImage;
import javax.baja.sys.BModule;
import javax.baja.ui.BAccelerator;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.CommandEvent;
import javax.baja.ui.UndoManager;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;

public class Command {
    private String keyBase;
    protected String label;
    protected BImage icon;
    protected BAccelerator accelerator;
    protected String description;
    private final BWidget owner;
    private WeakHashMap<BWidget, Object> registry = new WeakHashMap();
    private boolean enabled = true;

    public Command(BWidget owner, BModule module, String keyBase) {
        this(owner, module.getLexicon(), keyBase);
    }

    public Command(BWidget owner, Lexicon lexicon, String keyBase) {
        if (owner == null) {
            throw new NullPointerException("Null owner");
        }
        this.owner = owner;
        this.keyBase = keyBase;
        String label = lexicon.get(keyBase + ".label");
        String icon = lexicon.get(keyBase + ".icon");
        String acc = lexicon.get(keyBase + ".accelerator");
        String desc = lexicon.get(keyBase + ".description");
        this.label = label;
        if (acc != null) {
            try {
                this.accelerator = BAccelerator.make(acc);
            }
            catch (RuntimeException e) {
                System.out.println("Invalid accelerator for Command " + keyBase);
                e.printStackTrace();
            }
        }
        this.description = desc;
        if (icon != null) {
            this.icon = BImage.make((String)icon);
        }
    }

    public Command(BWidget owner, Properties props, String keyBase) {
        if (owner == null) {
            throw new NullPointerException("Null owner");
        }
        this.owner = owner;
        this.keyBase = keyBase;
        String label = props.getProperty(keyBase + ".label");
        String icon = props.getProperty(keyBase + ".icon");
        String acc = props.getProperty(keyBase + ".accelerator");
        String desc = props.getProperty(keyBase + ".description");
        this.label = label;
        if (acc != null) {
            try {
                this.accelerator = BAccelerator.make(acc);
            }
            catch (RuntimeException e) {
                System.out.println("Invalid accelerator for Command " + keyBase);
                e.printStackTrace();
            }
        }
        this.description = desc;
        if (icon != null) {
            this.icon = BImage.make((String)icon);
        }
    }

    public Command(BWidget owner, String label, BImage icon, BAccelerator acc, String description) {
        if (owner == null) {
            throw new NullPointerException("Null owner");
        }
        this.owner = owner;
        this.label = label;
        this.icon = icon;
        this.accelerator = acc;
        this.description = description;
    }

    public Command(BWidget owner, String label) {
        if (owner == null) {
            throw new NullPointerException("Null owner");
        }
        this.owner = owner;
        this.label = label;
    }

    public final BWidget getOwner() {
        return this.owner;
    }

    public final BWidgetShell getShell() {
        return this.owner.getShell();
    }

    public String getLabel() {
        return this.label;
    }

    public String getKeyBase() {
        return this.keyBase;
    }

    public BAccelerator getAccelerator() {
        return this.accelerator;
    }

    public BImage getIcon() {
        return this.icon;
    }

    public String getDescription() {
        return this.description;
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        for (BWidget widget : this.getRegistry()) {
            widget.setEnabled(enabled);
        }
    }

    public synchronized BWidget[] getRegistry() {
        return this.registry.keySet().toArray(new BWidget[0]);
    }

    public synchronized void register(BWidget widget) {
        this.registry.put(widget, null);
        widget.setEnabled(this.enabled);
    }

    public synchronized void unregister(BWidget widget) {
        this.registry.remove(widget);
    }

    public final void invoke() {
        this.invoke(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invoke(CommandEvent event) {
        BWidgetShell shell;
        boolean doBusy;
        if (event == null) {
            event = CommandEvent.NULL;
        }
        boolean bl = doBusy = (shell = this.owner.getShell()) != null && this.isBusyForInvoke();
        if (doBusy) {
            shell.enterBusy();
        }
        try {
            UndoManager um;
            CommandArtifact artifact = this.doInvoke(event);
            if (artifact != null && this.owner != null && (um = this.owner.getUndoManager()) != null) {
                um.addArtifact(artifact);
            }
        }
        catch (Throwable e) {
            ThrowableUtil.dump((Throwable)e);
            String title = UiLexicon.bajaui().getText("dialog.error");
            String msg = UiLexicon.bajaui().getText("command.error", new Object[]{this.getLabel()});
            BDialog.error(this.owner, title, (Object)msg, e);
        }
        finally {
            if (doBusy) {
                shell.exitBusy();
            }
        }
    }

    public CommandArtifact doInvoke(CommandEvent event) throws Exception {
        return this.doInvoke();
    }

    public CommandArtifact doInvoke() throws Exception {
        return null;
    }

    protected boolean isBusyForInvoke() {
        return true;
    }

    public Command merge(Command c) {
        if (this.getClass() == c.getClass() && this.owner == c.owner) {
            return this.doMerge(c);
        }
        return null;
    }

    protected Command doMerge(Command c) {
        return null;
    }

    public String toString() {
        return "Command: " + this.label;
    }
}

