/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.commands;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;

public class InvokeActionCommand
extends Command {
    private BComponent target;
    private Action action;
    private BValue actionArg;

    public InvokeActionCommand(BWidget owner, BComponent target, Action action) {
        this(owner, target, action, null);
    }

    public InvokeActionCommand(BWidget owner, BComponent target, Action action, BValue actionArg) {
        super(owner, target.getDisplayName((Slot)action, null));
        this.target = target;
        this.action = action;
        this.actionArg = actionArg;
    }

    @Override
    public CommandArtifact doInvoke() throws Exception {
        BValue arg;
        if (this.target.isMounted()) {
            this.target.getComponentSpace().sync();
        }
        this.action = this.target.getAction(this.action.getName());
        if (Flags.isConfirmRequired((BComplex)this.target, (Slot)this.action)) {
            if (Sys.isStation()) {
                return null;
            }
            String title = this.target.getDisplayName((Slot)this.action, null);
            Object[] args = new Object[]{this.target.getDisplayName((Slot)this.action, null)};
            String msg = UiLexicon.bajaui().getText("invoke.confirm", args);
            if (BDialog.confirm(this.getShell(), title, msg) != 4) {
                return null;
            }
        }
        if ((arg = this.actionArg) == null && (arg = this.target.getActionParameterDefault(this.action)) != null) {
            if (Sys.isStation()) {
                return null;
            }
            while (true) {
                BFacets facets = this.target.getSlotFacets((Slot)this.action);
                String title = this.target.getDisplayName((Slot)this.action, null);
                try {
                    Class cls = Sys.loadClass((String)"workbench", (String)"javax.baja.workbench.fieldeditor.BWbFieldEditor");
                    Method method = cls.getMethod("dialog", BWidget.class, String.class, BObject.class, Context.class);
                    arg = (BValue)method.invoke(null, this.getShell(), title, arg, facets);
                    if (arg == null) {
                        return null;
                    }
                }
                catch (Throwable e) {
                    if (e instanceof InvocationTargetException) {
                        e = ((InvocationTargetException)e).getTargetException();
                    }
                    String err = UiLexicon.bajaui().getText("invoke.input.error");
                    if (e.getClass().getName().equals("javax.baja.workbench.CannotSaveException")) {
                        BDialog.error((BWidget)this.getShell(), title, (Object)(err + "  " + e.getMessage()), e);
                        continue;
                    }
                    BDialog.error((BWidget)this.getShell(), title, (Object)err, e);
                }
                break;
            }
        }
        this.target.invoke(this.action, arg, null);
        return null;
    }
}

