/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.file;

import javax.baja.file.BIFile;
import javax.baja.file.IExtFileFilter;
import javax.baja.file.types.image.BImageFile;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.ui.util.UiLexicon;

public class ExtFileFilter
implements IExtFileFilter {
    public static ExtFileFilter images = new ExtFileFilter(UiLexicon.bajaui().getText("filter.images"), ExtFileFilter.getRegisteredImages());
    private final String[] ext;
    private final String desc;

    public static String getRegisteredImages() {
        StringBuilder b = new StringBuilder();
        b.append("png");
        for (String ext : Sys.getRegistry().getFileExtensions(BImageFile.TYPE.getTypeInfo())) {
            if ("png".equals(ext)) continue;
            if (b.length() > 0) {
                b.append(',');
            }
            b.append(ext);
        }
        return b.toString();
    }

    public ExtFileFilter(String desc, String ext) {
        this(desc, TextUtil.split((String)ext, (char)','));
    }

    public ExtFileFilter(String desc, String[] ext) {
        this.ext = ext;
        this.desc = desc;
    }

    public boolean accept(BIFile file) {
        for (String s : this.ext) {
            if (file.isDirectory() || file.getExtension() == null || !file.getExtension().equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    public String getDescription(Context cx) {
        return this.desc;
    }

    public boolean acceptExtension(String extension) {
        for (String s : this.ext) {
            if (extension == null || !extension.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    public String getDefaultExtension() {
        if (this.ext.length > 0) {
            return this.ext[0];
        }
        return null;
    }
}

