/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.list;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.RectGeom;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraTopics;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BScrollBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BMouseWheelEvent;
import javax.baja.ui.event.BScrollEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.list.DefaultListModel;
import javax.baja.ui.list.ListController;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.list.ListRenderer;
import javax.baja.ui.list.ListSelection;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="multipleSelection", type="boolean", defaultValue="true"), @NiagaraProperty(name="vscrollBar", type="BScrollBar", defaultValue="new BScrollBar(BOrientation.vertical)", flags=7)})
@NiagaraAction(name="vscroll", parameterType="BScrollEvent", defaultValue="new BScrollEvent()")
@NiagaraTopics(value={@NiagaraTopic(name="actionPerformed", eventType="BWidgetEvent"), @NiagaraTopic(name="cancelled", eventType="BWidgetEvent"), @NiagaraTopic(name="listModified", eventType="BWidgetEvent"), @NiagaraTopic(name="selectionModified", eventType="BWidgetEvent")})
public class BList
extends BTransferWidget {
    @Generated
    public static final Property multipleSelection = BList.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property vscrollBar = BList.newProperty((int)7, (BValue)new BScrollBar(BOrientation.vertical), null);
    @Generated
    public static final Action vscroll = BList.newAction((int)0, (BValue)new BScrollEvent(), null);
    @Generated
    public static final Topic actionPerformed = BList.newTopic((int)0, null);
    @Generated
    public static final Topic cancelled = BList.newTopic((int)0, null);
    @Generated
    public static final Topic listModified = BList.newTopic((int)0, null);
    @Generated
    public static final Topic selectionModified = BList.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BList.class);
    private static final BIcon icon = BIcon.std((String)"widgets/list.png");
    BScrollBar scrollBar;
    ListModel model;
    ListController controller;
    ListRenderer renderer;
    ListSelection selection;
    double itemHeight;
    ListRenderer.Item item = new ListRenderer.Item();

    @Generated
    public boolean getMultipleSelection() {
        return this.getBoolean(multipleSelection);
    }

    @Generated
    public void setMultipleSelection(boolean v) {
        this.setBoolean(multipleSelection, v, null);
    }

    @Generated
    public BScrollBar getVscrollBar() {
        return (BScrollBar)this.get(vscrollBar);
    }

    @Generated
    public void setVscrollBar(BScrollBar v) {
        this.set(vscrollBar, (BValue)v, null);
    }

    @Generated
    public void vscroll(BScrollEvent parameter) {
        this.invoke(vscroll, (BValue)parameter, null);
    }

    @Generated
    public void fireActionPerformed(BWidgetEvent event) {
        this.fire(actionPerformed, (BValue)event, null);
    }

    @Generated
    public void fireCancelled(BWidgetEvent event) {
        this.fire(cancelled, (BValue)event, null);
    }

    @Generated
    public void fireListModified(BWidgetEvent event) {
        this.fire(listModified, (BValue)event, null);
    }

    @Generated
    public void fireSelectionModified(BWidgetEvent event) {
        this.fire(selectionModified, (BValue)event, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BList() {
        this(new DefaultListModel(), new ListController());
    }

    public BList(ListModel model) {
        this(model, new ListController());
    }

    public BList(ListController controller) {
        this(new DefaultListModel(), controller);
    }

    public BList(ListModel model, ListController controller) {
        this.setModel(model);
        this.setController(controller);
        this.setSelection(new ListSelection());
        this.setRenderer(new ListRenderer());
        this.linkTo(this.getVscrollBar(), (Slot)BScrollBar.positionChanged, (Slot)vscroll);
    }

    public void started() {
        this.linkTo(this.getVscrollBar(), (Slot)BScrollBar.positionChanged, (Slot)vscroll);
    }

    public ListModel getModel() {
        return this.model;
    }

    public void setModel(ListModel model) {
        this.installSupport(this.model, model);
        this.model = model;
    }

    public ListController getController() {
        return this.controller;
    }

    public void setController(ListController controller) {
        this.installSupport(this.controller, controller);
        this.controller = controller;
    }

    public ListSelection getSelection() {
        return this.selection;
    }

    public void setSelection(ListSelection selection) {
        this.installSupport(this.selection, selection);
        this.selection = selection;
    }

    public ListRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(ListRenderer renderer) {
        this.installSupport(this.renderer, renderer);
        this.renderer = renderer;
        this.itemHeight = renderer.getItemHeight();
    }

    private void installSupport(ListSupport old, ListSupport support) {
        if (support == null) {
            throw new NullPointerException();
        }
        if (old == support) {
            return;
        }
        if (support.list != null) {
            throw new IllegalArgumentException("Already installed on another list");
        }
        if (old != null) {
            old.list = null;
        }
        support.list = this;
    }

    @Override
    public void changed(Property prop, Context context) {
        this.relayout();
    }

    @Override
    public void computePreferredSize() {
        double w = 0.0;
        double h = 0.0;
        int count = this.model.getItemCount();
        for (int i = 0; i < count; ++i) {
            this.item.index = i;
            this.item.icon = this.model.getItemIcon(i);
            this.item.value = this.model.getItem(i);
            w = Math.max(w, this.renderer.getPreferredItemWidth(this.item));
        }
        h += (double)this.model.getItemCount() * this.itemHeight;
        w = Math.max(w, 10.0);
        h = Math.max(h, 10.0);
        this.setPreferredSize(w + 2.0, h + 2.0);
    }

    @Override
    public void doLayout(BWidget[] kids) {
        double w = this.getWidth();
        double h = this.getHeight();
        int count = this.model.getItemCount();
        double scrollWidth = Theme.scrollBar().getFixedWidth();
        int visibleRows = this.getVisibleRowCount();
        BScrollBar sb = this.getVscrollBar();
        if (visibleRows < count) {
            sb.setVisible(true);
            sb.setMin(0);
            sb.setMax(count);
            sb.setExtent(visibleRows);
            sb.setBlockIncrement(Math.max(3, visibleRows - 1));
            sb.setBounds(w - scrollWidth - 1.0, 1.0, scrollWidth, h - 2.0);
        } else {
            sb.setVisible(false);
            sb.setBounds(0.0, 0.0, 0.0, 0.0);
            sb.setPosition(0);
            sb.setMin(0);
            sb.setMax(visibleRows);
            sb.setExtent(visibleRows);
        }
    }

    public int getVisibleRowCount() {
        return (int)(this.getHeight() / this.itemHeight);
    }

    public int getItemIndexAt(double x, double y) {
        if (x < 0.0 || x > this.getWidth() - this.getVscrollBar().getWidth()) {
            return -1;
        }
        int index = (int)(y / this.itemHeight) + this.getVscrollBar().getPosition();
        if (index < this.model.getItemCount()) {
            return index;
        }
        return -1;
    }

    public RectGeom getItemBounds(int index) {
        double x = 0.0;
        double y = (double)index * this.itemHeight;
        double w = this.getWidth() - this.getVscrollBar().getWidth();
        double h = this.itemHeight;
        return new RectGeom(x, y, w, h);
    }

    public void ensureItemIsVisible(int index) {
        int visible = this.getVisibleRowCount();
        if (visible <= 0) {
            if (this.getParent() instanceof BDropDown) {
                visible = (int)(308.0 / this.itemHeight);
            } else {
                return;
            }
        }
        int start = this.getVscrollBar().getPosition();
        int end = start + visible;
        int itemCount = this.model.getItemCount();
        BScrollBar sb = this.getVscrollBar();
        sb.setMax(Math.max(visible, itemCount));
        if (index < start) {
            sb.setPosition(index);
        } else if (index >= end) {
            int pos = index - visible + 1;
            if (pos >= itemCount) {
                pos = itemCount - 1;
            }
            if (pos < 0) {
                pos = 0;
            }
            sb.setPosition(pos);
        }
    }

    public void doVscroll(BScrollEvent event) {
        this.repaint();
    }

    public int getItemCount() {
        return this.model.getItemCount();
    }

    public Object getItem(int index) {
        return this.model.getItem(index);
    }

    public int indexOfItem(Object value) {
        return this.model.indexOfItem(value);
    }

    public void addItem(Object value) {
        this.model.addItem(null, value);
    }

    public void addItem(BImage icon, Object value) {
        this.model.addItem(icon, value);
    }

    public void insertItem(int index, Object value) {
        this.model.insertItem(index, value);
    }

    public void insertItem(int index, BImage icon, Object value) {
        this.model.insertItem(index, icon, value);
    }

    public void setItem(int index, Object value) {
        this.model.setItem(index, value);
    }

    public void setItem(int index, BImage icon, Object value) {
        this.model.setItem(index, icon, value);
    }

    public void removeItem(Object value) {
        this.model.removeItem(value);
    }

    public void removeItem(int index) {
        this.model.removeItem(index);
    }

    public void removeAllItems() {
        this.model.removeAllItems();
    }

    public void removeSelectedItems() {
        int[] selections = this.getSelection().getItems();
        this.getSelection().deselectAll();
        for (int i = selections.length - 1; i >= 0; --i) {
            this.removeItem(selections[i]);
        }
    }

    public boolean isSelected(int index) {
        return this.getSelection().isSelected(index);
    }

    public boolean isSelected(Object item) {
        return this.getSelection().isSelected(this.indexOfItem(item));
    }

    public int getSelectedIndex() {
        return this.getSelection().getItem();
    }

    public int[] getSelectedIndices() {
        return this.getSelection().getItems();
    }

    public Object getSelectedItem() {
        int index = this.getSelectedIndex();
        if (index < 0 || index >= this.getModel().getItemCount()) {
            return null;
        }
        return this.getModel().getItem(index);
    }

    public Object[] getSelectedItems() {
        int[] indices = this.getSelectedIndices();
        Object[] result = new Object[indices.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getModel().getItem(indices[i]);
        }
        return result;
    }

    public void setSelectedIndex(int index) {
        this.getSelection().deselectAll();
        this.getSelection().select(index);
    }

    public void setSelectedItem(Object value) {
        this.getSelection().deselectAll();
        int index = this.indexOfItem(value);
        if (index != -1) {
            this.setSelectedIndex(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        IGeom origClip = g.getClip();
        BScrollBar scrollBar = this.getVscrollBar();
        int count = this.model.getItemCount();
        int visibleRows = this.getVisibleRowCount();
        double w = this.getWidth();
        double h = this.getHeight();
        double ih = this.itemHeight;
        double iw = w - scrollBar.getWidth();
        Theme.dropDown().paintBackground(g, this);
        int start = scrollBar.getPosition();
        int end = Math.min(start + visibleRows + 1, count);
        double y = 2.0;
        for (int i = start; i < end; ++i) {
            g.push();
            try {
                this.paintItem(g, i, y, iw);
            }
            finally {
                g.pop();
            }
            y += ih;
        }
        Theme.dropDown().paintBorder(g, this);
        this.paintChildren(g);
    }

    private void paintItem(Graphics g, int index, double y, double itemWidth) {
        BImage icon = null;
        Object value = "?";
        try {
            icon = this.model.getItemIcon(index);
            value = this.model.getItem(index);
        }
        catch (Exception e) {
            System.out.println("ERROR:  BList.paintItem: " + index);
            System.out.println("  " + e);
        }
        ListRenderer.Item item = this.item;
        item.icon = icon;
        item.index = index;
        item.value = value;
        item.width = itemWidth;
        item.height = this.itemHeight;
        item.selected = this.selection.isSelected(index);
        double x = 1.0;
        double wClip = Math.min(item.width, this.getWidth() - x - x);
        double hClip = Math.min(item.height, this.getHeight() - y - 2.0);
        g.clip(x, y, wClip, hClip);
        g.translate(x, y);
        this.renderer.paintItem(g, item);
        g.translate(-x, -y);
    }

    @Override
    public String getStyleSelector() {
        return "list";
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    @Override
    public void focusGained(BFocusEvent event) {
        this.controller.focusGained(event);
    }

    @Override
    public void focusLost(BFocusEvent event) {
        this.controller.focusLost(event);
    }

    @Override
    public void keyPressed(BKeyEvent event) {
        this.controller.keyPressed(event);
    }

    @Override
    public void keyReleased(BKeyEvent event) {
        this.controller.keyReleased(event);
    }

    @Override
    public void keyTyped(BKeyEvent event) {
        this.controller.keyTyped(event);
    }

    @Override
    public void mousePressed(BMouseEvent event) {
        this.controller.mousePressed(event);
    }

    @Override
    public void mouseReleased(BMouseEvent event) {
        this.controller.mouseReleased(event);
    }

    @Override
    public void mouseEntered(BMouseEvent event) {
        this.controller.mouseEntered(event);
    }

    @Override
    public void mouseExited(BMouseEvent event) {
        this.controller.mouseExited(event);
    }

    @Override
    public void mouseMoved(BMouseEvent event) {
        this.controller.mouseMoved(event);
    }

    @Override
    public void mouseDragged(BMouseEvent event) {
        this.controller.mouseDragged(event);
    }

    @Override
    public void mousePulsed(BMouseEvent event) {
        this.controller.mousePulsed(event);
    }

    @Override
    public void mouseWheel(BMouseWheelEvent event) {
        this.controller.mouseWheel(event);
    }

    @Override
    public TransferEnvelope getTransferData() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public CommandArtifact insertTransferData(TransferContext cx) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public CommandArtifact removeTransferData(TransferContext cx) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }

    public static abstract class ListSupport {
        BList list;

        public final BList getList() {
            return this.list;
        }

        public ListModel getModel() {
            return this.list.model;
        }

        public ListController getController() {
            return this.list.controller;
        }

        public ListRenderer getRenderer() {
            return this.list.renderer;
        }

        public ListSelection getSelection() {
            return this.list.selection;
        }

        public BWidgetShell getShell() {
            return this.list.getShell();
        }
    }
}

