/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.list;

import java.util.ArrayList;
import javax.baja.gx.BImage;
import javax.baja.ui.list.ListModel;

public class DefaultListModel
extends ListModel {
    protected ArrayList<Item> items = new ArrayList();

    @Override
    public int getItemCount() {
        return this.items.size();
    }

    @Override
    public int indexOfItem(Object value) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.items.get((int)i).value.equals(value)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object getItem(int index) {
        return this.items.get((int)index).value;
    }

    @Override
    public BImage getItemIcon(int index) {
        return this.items.get((int)index).icon;
    }

    @Override
    public void addItem(BImage icon, Object value) {
        this.items.add(new Item(icon, value));
        this.updateList();
    }

    @Override
    public void insertItem(int index, BImage icon, Object value) {
        this.items.add(index, new Item(icon, value));
        this.updateList();
    }

    @Override
    public void setItem(int index, BImage icon, Object value) {
        this.items.set(index, new Item(icon, value));
        this.updateList();
    }

    @Override
    public void removeItem(Object value) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.items.get((int)i).value.equals(value)) continue;
            this.items.remove(i);
            this.updateList();
            return;
        }
    }

    @Override
    public void removeItem(int index) {
        this.items.remove(index);
        this.updateList();
    }

    @Override
    public void removeAllItems() {
        this.items.clear();
        this.updateList();
    }

    public static class Item {
        public BImage icon;
        public Object value;

        public Item(BImage icon, Object value) {
            this.icon = icon;
            this.value = value;
        }

        public Item(Object value) {
            this.value = value;
        }
    }
}

