/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.pane;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.BBrush;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BPane;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="summary", type="BWidget", defaultValue="new BNullWidget()"), @NiagaraProperty(name="expansion", type="BWidget", defaultValue="new BNullWidget()"), @NiagaraProperty(name="expanderHalign", type="BHalign", defaultValue="BHalign.right"), @NiagaraProperty(name="summaryBackground", type="BBrush", defaultValue="BBrush.NULL")})
@NiagaraTopic(name="expanderEvent", eventType="BWidgetEvent")
public class BExpandablePane
extends BPane {
    @Generated
    public static final Property summary = BExpandablePane.newProperty((int)0, (BValue)new BNullWidget(), null);
    @Generated
    public static final Property expansion = BExpandablePane.newProperty((int)0, (BValue)new BNullWidget(), null);
    @Generated
    public static final Property expanderHalign = BExpandablePane.newProperty((int)0, (BValue)BHalign.right, null);
    @Generated
    public static final Property summaryBackground = BExpandablePane.newProperty((int)0, (BValue)BBrush.NULL, null);
    @Generated
    public static final Topic expanderEvent = BExpandablePane.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BExpandablePane.class);
    private static final BIcon icon = BIcon.std((String)"widgets/expandablePane.png");
    private static final double GAP = 2.0;
    private static final double MIN_EXPANDER_HEIGHT = 17.0;
    private boolean isExpanded = false;
    private boolean expanderVisible = true;
    private RectGeom button = new RectGeom();
    private boolean overButton;

    @Generated
    public BWidget getSummary() {
        return (BWidget)this.get(summary);
    }

    @Generated
    public void setSummary(BWidget v) {
        this.set(summary, (BValue)v, null);
    }

    @Generated
    public BWidget getExpansion() {
        return (BWidget)this.get(expansion);
    }

    @Generated
    public void setExpansion(BWidget v) {
        this.set(expansion, (BValue)v, null);
    }

    @Generated
    public BHalign getExpanderHalign() {
        return (BHalign)this.get(expanderHalign);
    }

    @Generated
    public void setExpanderHalign(BHalign v) {
        this.set(expanderHalign, (BValue)v, null);
    }

    @Generated
    public BBrush getSummaryBackground() {
        return (BBrush)this.get(summaryBackground);
    }

    @Generated
    public void setSummaryBackground(BBrush v) {
        this.set(summaryBackground, (BValue)v, null);
    }

    @Generated
    public void fireExpanderEvent(BWidgetEvent event) {
        this.fire(expanderEvent, (BValue)event, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BExpandablePane(BWidget summary, BWidget expansion, BHalign align) {
        this.setSummary(summary);
        this.setExpansion(expansion);
        this.setExpanderHalign(align);
    }

    public BExpandablePane(BWidget summary, BWidget expansion) {
        this.setSummary(summary);
        this.setExpansion(expansion);
    }

    public BExpandablePane() {
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setExpanded(boolean isExpanded) {
        if (this.isExpanded != isExpanded) {
            this.isExpanded = isExpanded;
            if (isExpanded) {
                this.relayoutSync();
                this.scrollToVisible(new RectGeom(0.0, 0.0, this.getWidth(), this.getHeight()));
            } else {
                this.relayout();
            }
        }
    }

    public void setExpanderVisible(boolean expanderVisible) {
        if (this.expanderVisible != expanderVisible) {
            this.expanderVisible = expanderVisible;
            this.relayout();
        }
    }

    public boolean isExpanderVisible() {
        return this.expanderVisible;
    }

    @Override
    public void computePreferredSize() {
        BWidget summary = this.getSummary();
        summary.computePreferredSize();
        double pw = summary.getPreferredWidth();
        double ph = summary.getPreferredHeight();
        if (this.expanderVisible) {
            pw += 2.0 + Theme.expandablePane().getExpanderWidth();
            ph = Math.max(ph, 17.0);
        }
        if (this.isExpanded) {
            BWidget expansion = this.getExpansion();
            expansion.computePreferredSize();
            pw = Math.max(pw, expansion.getPreferredWidth());
            ph += expansion.getPreferredHeight();
        }
        this.setPreferredSize(pw, ph);
    }

    @Override
    public void doLayout(BWidget[] kids) {
        double gap;
        double w = this.getWidth();
        double h = this.getHeight();
        BWidget summary = this.getSummary();
        summary.computePreferredSize();
        double sw = summary.getPreferredWidth();
        double sh = summary.getPreferredHeight();
        double seh = Math.max(sh, 17.0);
        double d = gap = summary.isNull() ? 0.0 : 2.0;
        if (this.expanderVisible) {
            double yoffset;
            double ew = Theme.expandablePane().getExpanderWidth();
            double d2 = yoffset = sh >= seh ? seh - sh : 0.0;
            if (this.getExpanderHalign() == BHalign.right) {
                summary.setBounds(0.0, (seh - sh) / 2.0, Math.min(sw, w - gap - ew), sh);
                this.button.set(sw + gap, yoffset, ew, seh);
            } else {
                this.button.set(0.0, yoffset, ew, seh);
                summary.setBounds(ew + gap, (seh - sh) / 2.0, Math.min(sw, w - gap - ew), sh);
            }
        } else {
            summary.setBounds(0.0, (seh - sh) / 2.0, sw, sh);
            this.button.set(0.0, 0.0, 0.0, 0.0);
        }
        BWidget expansion = this.getExpansion();
        if (this.isExpanded) {
            expansion.setBounds(0.0, seh, w, h - seh);
        } else {
            expansion.setBounds(0.0, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void paint(Graphics g) {
        BBrush bg = this.getSummaryBackground();
        if (!bg.isNull()) {
            g.setBrush(bg);
            g.fillRect(0.0, 0.0, this.getWidth(), Math.max(this.getSummary().getHeight(), 17.0));
        }
        this.paintChild(g, this.getSummary());
        if (this.isExpanded) {
            this.paintChild(g, this.getExpansion());
        }
        if (this.expanderVisible) {
            Theme.expandablePane().paintButton(g, this, this.button, this.isExpanded, this.overButton);
        }
    }

    @Override
    public void mouseReleased(BMouseEvent event) {
        if (!this.getEnabled()) {
            return;
        }
        if (this.button.contains(event.getX(), event.getY())) {
            this.setExpanded(!this.isExpanded);
            this.fireExpanderEvent(new BWidgetEvent(2, this));
        }
    }

    @Override
    public void mouseEntered(BMouseEvent event) {
        if (!this.getEnabled()) {
            return;
        }
        super.mouseEntered(event);
        this.checkOverButton(event);
    }

    @Override
    public void mouseExited(BMouseEvent event) {
        if (!this.getEnabled()) {
            return;
        }
        this.overButton = false;
        this.repaint();
    }

    @Override
    public void mouseMoved(BMouseEvent event) {
        if (!this.getEnabled()) {
            return;
        }
        super.mouseMoved(event);
        this.checkOverButton(event);
    }

    private void checkOverButton(BMouseEvent event) {
        double my;
        double mx = event.getX();
        boolean nowOverButton = this.button.contains(mx, my = event.getY());
        if (nowOverButton != this.overButton) {
            this.overButton = nowOverButton;
            this.repaint();
        }
    }

    public RectGeom getButtonGeom() {
        return this.button;
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }
}

